/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.CmykJpegReader;

import com.alkacon.simapi.CmykJpegReader.BufferedImageIcon;
import com.alkacon.simapi.CmykJpegReader.IIOUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public abstract class ImageReaderBase
extends ImageReader {
    private static final Point ORIGIN = new Point(0, 0);
    protected ImageInputStream imageInput;

    protected ImageReaderBase(ImageReaderSpi provider) {
        super(provider);
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        this.resetMembers();
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        this.imageInput = input instanceof ImageInputStream ? (ImageInputStream)input : null;
    }

    @Override
    public void dispose() {
        this.resetMembers();
        super.dispose();
    }

    @Override
    public void reset() {
        this.resetMembers();
        super.reset();
    }

    protected abstract void resetMembers();

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        this.assertInput();
        return 1;
    }

    protected void checkBounds(int index) throws IOException {
        this.assertInput();
        if (index < this.getMinIndex()) {
            throw new IndexOutOfBoundsException("index < minIndex");
        }
        if (this.getNumImages(false) != -1 && index >= this.getNumImages(false)) {
            throw new IndexOutOfBoundsException("index >= numImages (" + index + " >= " + this.getNumImages(false) + ")");
        }
    }

    protected void assertInput() {
        if (this.getInput() == null) {
            throw new IllegalStateException("getInput() == null");
        }
    }

    public static BufferedImage getDestination(ImageReadParam param, Iterator<ImageTypeSpecifier> types, int width, int height) throws IIOException {
        if (types == null || !types.hasNext()) {
            throw new IllegalArgumentException("imageTypes null or empty!");
        }
        ImageTypeSpecifier imageType = null;
        if (param != null) {
            BufferedImage dest = param.getDestination();
            if (dest != null) {
                boolean found = false;
                while (types.hasNext()) {
                    ImageTypeSpecifier specifier = types.next();
                    int bufferedImageType = specifier.getBufferedImageType();
                    if (bufferedImageType != 0 && bufferedImageType == dest.getType()) {
                        found = true;
                        break;
                    }
                    if (specifier.getSampleModel().getTransferType() != dest.getSampleModel().getTransferType() || specifier.getNumBands() > dest.getSampleModel().getNumBands()) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new IIOException(String.format("Destination image from ImageReadParam does not match legal imageTypes from reader: %s", dest));
                }
                return dest;
            }
            imageType = param.getDestinationType();
        }
        if (imageType == null) {
            imageType = types.next();
        } else {
            boolean foundIt = false;
            while (types.hasNext()) {
                ImageTypeSpecifier type = types.next();
                if (!type.equals(imageType)) continue;
                foundIt = true;
                break;
            }
            if (!foundIt) {
                throw new IIOException(String.format("Destination type from ImageReadParam does not match legal imageTypes from reader: %s", imageType));
            }
        }
        Rectangle srcRegion = new Rectangle(0, 0, 0, 0);
        Rectangle destRegion = new Rectangle(0, 0, 0, 0);
        ImageReaderBase.computeRegions(param, width, height, null, srcRegion, destRegion);
        int destWidth = destRegion.x + destRegion.width;
        int destHeight = destRegion.y + destRegion.height;
        if ((long)destWidth * (long)destHeight > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("destination width * height > Integer.MAX_VALUE: %d", (long)destWidth * (long)destHeight));
        }
        return imageType.createBufferedImage(destWidth, destHeight);
    }

    protected static BufferedImage fakeAOI(BufferedImage pImage, ImageReadParam pParam) {
        return IIOUtil.fakeAOI(pImage, ImageReaderBase.getSourceRegion(pParam, pImage.getWidth(), pImage.getHeight()));
    }

    protected static Image fakeSubsampling(Image pImage, ImageReadParam pParam) {
        return IIOUtil.fakeSubsampling(pImage, pParam);
    }

    protected static boolean hasExplicitDestination(ImageReadParam pParam) {
        return pParam != null && (pParam.getDestination() != null || pParam.getDestinationType() != null || !ORIGIN.equals(pParam.getDestinationOffset()));
    }

    public static void main(String[] pArgs) throws IOException {
        BufferedImage image = ImageIO.read(new File(pArgs[0]));
        if (image == null) {
            System.err.println("Supported formats: " + Arrays.toString(IIOUtil.getNormalizedReaderFormatNames()));
            System.exit(1);
        }
        ImageReaderBase.showIt(image, pArgs[0]);
    }

    protected static void showIt(final BufferedImage pImage, final String pTitle) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    JFrame frame = new JFrame(pTitle);
                    frame.getRootPane().getActionMap().put("window-close", new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Window window = SwingUtilities.getWindowAncestor((Component)e.getSource());
                            window.setVisible(false);
                            window.dispose();
                        }
                    });
                    frame.getRootPane().getInputMap().put(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "window-close");
                    frame.addWindowListener(new ExitIfNoWindowPresentHandler());
                    frame.setDefaultCloseOperation(2);
                    frame.setLocationByPlatform(true);
                    JPanel pane = new JPanel(new BorderLayout());
                    JScrollPane scroll = new JScrollPane(pImage != null ? new ImageLabel(pImage) : new JLabel("(no image data)", 0));
                    scroll.setBorder(null);
                    pane.add(scroll);
                    frame.setContentPane(pane);
                    frame.pack();
                    frame.setVisible(true);
                }
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    private static class ExitIfNoWindowPresentHandler
    extends WindowAdapter {
        private ExitIfNoWindowPresentHandler() {
        }

        @Override
        public void windowClosed(WindowEvent e) {
            Window[] windows = Window.getWindows();
            if (windows == null || windows.length == 0) {
                System.exit(0);
            }
        }
    }

    private static class ImageLabel
    extends JLabel {
        static final String ZOOM_IN = "zoom-in";
        static final String ZOOM_OUT = "zoom-out";
        static final String ZOOM_ACTUAL = "zoom-actual";
        Paint backgroundPaint;
        final Paint checkeredBG;
        final Color defaultBG;

        public ImageLabel(BufferedImage pImage) {
            super(new BufferedImageIcon(pImage));
            this.setOpaque(false);
            this.setCursor(Cursor.getPredefinedCursor(1));
            this.checkeredBG = ImageLabel.createTexture();
            this.defaultBG = ImageLabel.getDefaultBackground(pImage);
            this.backgroundPaint = this.defaultBG != null ? this.defaultBG : this.checkeredBG;
            this.setupActions(pImage);
            this.setComponentPopupMenu(this.createPopupMenu());
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        ImageLabel.this.getComponentPopupMenu().show(ImageLabel.this, e.getX(), e.getY());
                    }
                }
            });
        }

        private void setupActions(BufferedImage pImage) {
            this.bindAction(new ZoomAction("Zoom in", pImage, 2.0), ZOOM_IN, KeyStroke.getKeyStroke('+'), KeyStroke.getKeyStroke(107, 0));
            this.bindAction(new ZoomAction("Zoom out", pImage, 0.5), ZOOM_OUT, KeyStroke.getKeyStroke('-'), KeyStroke.getKeyStroke(109, 0));
            this.bindAction(new ZoomAction("Zoom actual", pImage), ZOOM_ACTUAL, KeyStroke.getKeyStroke('0'), KeyStroke.getKeyStroke(48, 0));
        }

        private void bindAction(AbstractAction action, String key, KeyStroke ... keyStrokes) {
            for (KeyStroke keyStroke : keyStrokes) {
                this.getInputMap(2).put(keyStroke, key);
            }
            this.getActionMap().put(key, action);
        }

        private JPopupMenu createPopupMenu() {
            JPopupMenu popup = new JPopupMenu();
            popup.add(this.getActionMap().get(ZOOM_ACTUAL));
            popup.add(this.getActionMap().get(ZOOM_IN));
            popup.add(this.getActionMap().get(ZOOM_OUT));
            popup.addSeparator();
            ButtonGroup group = new ButtonGroup();
            JMenu background = new JMenu("Background");
            popup.add(background);
            ChangeBackgroundAction checkered = new ChangeBackgroundAction("Checkered", this.checkeredBG);
            checkered.putValue("SwingSelectedKey", this.backgroundPaint == this.checkeredBG);
            this.addCheckBoxItem(checkered, background, group);
            background.addSeparator();
            this.addCheckBoxItem(new ChangeBackgroundAction("White", Color.WHITE), background, group);
            this.addCheckBoxItem(new ChangeBackgroundAction("Light", Color.LIGHT_GRAY), background, group);
            this.addCheckBoxItem(new ChangeBackgroundAction("Gray", Color.GRAY), background, group);
            this.addCheckBoxItem(new ChangeBackgroundAction("Dark", Color.DARK_GRAY), background, group);
            this.addCheckBoxItem(new ChangeBackgroundAction("Black", Color.BLACK), background, group);
            background.addSeparator();
            ChooseBackgroundAction chooseBackgroundAction = new ChooseBackgroundAction("Choose...", this.defaultBG != null ? this.defaultBG : Color.BLUE);
            chooseBackgroundAction.putValue("SwingSelectedKey", this.backgroundPaint == this.defaultBG);
            this.addCheckBoxItem(chooseBackgroundAction, background, group);
            return popup;
        }

        private void addCheckBoxItem(Action pAction, JMenu pPopup, ButtonGroup pGroup) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(pAction);
            pGroup.add(item);
            pPopup.add(item);
        }

        private static Color getDefaultBackground(BufferedImage pImage) {
            IndexColorModel cm;
            int transparent;
            if (pImage.getColorModel() instanceof IndexColorModel && (transparent = (cm = (IndexColorModel)pImage.getColorModel()).getTransparentPixel()) >= 0) {
                return new Color(cm.getRGB(transparent), false);
            }
            return null;
        }

        private static Paint createTexture() {
            GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            BufferedImage pattern = graphicsConfiguration.createCompatibleImage(20, 20);
            Graphics2D g = pattern.createGraphics();
            try {
                g.setColor(Color.LIGHT_GRAY);
                g.fillRect(0, 0, pattern.getWidth(), pattern.getHeight());
                g.setColor(Color.GRAY);
                g.fillRect(0, 0, pattern.getWidth() / 2, pattern.getHeight() / 2);
                g.fillRect(pattern.getWidth() / 2, pattern.getHeight() / 2, pattern.getWidth() / 2, pattern.getHeight() / 2);
            }
            finally {
                g.dispose();
            }
            return new TexturePaint(pattern, new Rectangle(pattern.getWidth(), pattern.getHeight()));
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D gr = (Graphics2D)g;
            gr.setPaint(this.backgroundPaint);
            gr.fillRect(0, 0, this.getWidth(), this.getHeight());
            super.paintComponent(g);
        }

        private class ZoomAction
        extends AbstractAction {
            private final BufferedImage image;
            private final double zoomFactor;

            public ZoomAction(String name, BufferedImage image, double zoomFactor) {
                super(name);
                this.image = image;
                this.zoomFactor = zoomFactor;
            }

            public ZoomAction(String name, BufferedImage image) {
                this(name, image, 0.0);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.zoomFactor <= 0.0) {
                    ImageLabel.this.setIcon(new BufferedImageIcon(this.image));
                } else {
                    Icon current = ImageLabel.this.getIcon();
                    int w = (int)Math.max(Math.min((double)current.getIconWidth() * this.zoomFactor, (double)(this.image.getWidth() * 16)), (double)(this.image.getWidth() / 16));
                    int h = (int)Math.max(Math.min((double)current.getIconHeight() * this.zoomFactor, (double)(this.image.getHeight() * 16)), (double)(this.image.getHeight() / 16));
                    ImageLabel.this.setIcon(new BufferedImageIcon(this.image, Math.max(w, 2), Math.max(h, 2), w > this.image.getWidth() || h > this.image.getHeight()));
                }
            }
        }

        private class ChooseBackgroundAction
        extends ChangeBackgroundAction {
            public ChooseBackgroundAction(String pName, Color pColor) {
                super(pName, pColor);
                this.putValue("SmallIcon", new Icon(){

                    @Override
                    public void paintIcon(Component c, Graphics pGraphics, int x, int y) {
                        Graphics g = pGraphics.create();
                        g.setColor((Color)ChooseBackgroundAction.this.paint);
                        g.fillRect(x, y, 16, 16);
                        g.dispose();
                    }

                    @Override
                    public int getIconWidth() {
                        return 16;
                    }

                    @Override
                    public int getIconHeight() {
                        return 16;
                    }
                });
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Color selected = JColorChooser.showDialog(ImageLabel.this, "Choose background", (Color)this.paint);
                if (selected != null) {
                    this.paint = selected;
                    super.actionPerformed(e);
                }
            }
        }

        private class ChangeBackgroundAction
        extends AbstractAction {
            protected Paint paint;

            public ChangeBackgroundAction(String pName, Paint pPaint) {
                super(pName);
                this.paint = pPaint;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageLabel.this.backgroundPaint = this.paint;
                ImageLabel.this.repaint();
            }
        }
    }
}

