/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.CmykJpegReader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class FastByteArrayOutputStream
extends ByteArrayOutputStream {
    protected int maxGrowSize = 0x100000;

    public FastByteArrayOutputStream(int pSize) {
        super(pSize);
    }

    public FastByteArrayOutputStream(byte[] pBuffer) {
        super(0);
        this.buf = pBuffer;
        this.count = pBuffer.length;
    }

    @Override
    public void write(byte[] pBytes, int pOffset, int pLength) {
        if (pOffset < 0 || pOffset > pBytes.length || pLength < 0 || pOffset + pLength > pBytes.length || pOffset + pLength < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (pLength == 0) {
            return;
        }
        int newCount = this.count + pLength;
        this.growIfNeeded(newCount);
        System.arraycopy(pBytes, pOffset, this.buf, this.count, pLength);
        this.count = newCount;
    }

    @Override
    public void write(int pByte) {
        int newCount = this.count + 1;
        this.growIfNeeded(newCount);
        this.buf[this.count] = (byte)pByte;
        this.count = newCount;
    }

    private void growIfNeeded(int pNewCount) {
        if (pNewCount > this.buf.length) {
            int newSize = Math.max(Math.min(this.buf.length << 1, this.buf.length + this.maxGrowSize), pNewCount);
            byte[] newBuf = new byte[newSize];
            System.arraycopy(this.buf, 0, newBuf, 0, this.count);
            this.buf = newBuf;
        }
    }

    @Override
    public void writeTo(OutputStream pOut) throws IOException {
        pOut.write(this.buf, 0, this.count);
    }

    @Override
    public byte[] toByteArray() {
        byte[] newBuf = new byte[this.count];
        System.arraycopy(this.buf, 0, newBuf, 0, this.count);
        return newBuf;
    }

    public ByteArrayInputStream createInputStream() {
        return new ByteArrayInputStream(this.buf, 0, this.count);
    }
}

