/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.CmykJpegReader;

import java.io.OutputStream;
import java.io.Writer;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMImplementationList;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public final class DOMSerializer {
    private static final String PARAM_PRETTY_PRINT = "format-pretty-print";
    private static final String PARAM_XML_DECLARATION = "xml-declaration";
    private final LSSerializer serializer;
    private final LSOutput output;

    private DOMSerializer() {
        DOMImplementationLS domImpl = Support.getImplementation();
        this.serializer = domImpl.createLSSerializer();
        this.output = domImpl.createLSOutput();
    }

    public DOMSerializer(OutputStream pStream, String pEncoding) {
        this();
        this.output.setByteStream(pStream);
        this.output.setEncoding(pEncoding);
    }

    public DOMSerializer(Writer pStream) {
        this();
        this.output.setCharacterStream(pStream);
    }

    public void setPrettyPrint(boolean pPrettyPrint) {
        DOMConfiguration configuration = this.serializer.getDomConfig();
        if (configuration.canSetParameter(PARAM_PRETTY_PRINT, pPrettyPrint)) {
            configuration.setParameter(PARAM_PRETTY_PRINT, pPrettyPrint);
        }
    }

    public boolean getPrettyPrint() {
        return Boolean.TRUE.equals(this.serializer.getDomConfig().getParameter(PARAM_PRETTY_PRINT));
    }

    private void setXMLDeclaration(boolean pXMLDeclaration) {
        this.serializer.getDomConfig().setParameter(PARAM_XML_DECLARATION, pXMLDeclaration);
    }

    public void serialize(Document pDocument) {
        this.serializeImpl(pDocument, true);
    }

    public void serialize(Node pNode) {
        this.serializeImpl(pNode, false);
    }

    private void serializeImpl(Node pNode, boolean pOmitDecl) {
        this.setXMLDeclaration(pOmitDecl);
        this.serializer.write(pNode, this.output);
    }

    private static class Support {
        private static final DOMImplementationRegistry DOM_REGISTRY = Support.createDOMRegistry();

        private Support() {
        }

        static DOMImplementationLS getImplementation() {
            DOMImplementationLS implementation = (DOMImplementationLS)((Object)DOM_REGISTRY.getDOMImplementation("LS 3.0"));
            if (implementation == null) {
                DOMImplementationList list = DOM_REGISTRY.getDOMImplementationList("");
                System.err.println("DOM implementations (" + list.getLength() + "):");
                for (int i = 0; i < list.getLength(); ++i) {
                    System.err.println("    " + list.item(i));
                }
                throw new IllegalStateException("Could not create DOM Implementation (no LS support found)");
            }
            return implementation;
        }

        private static DOMImplementationRegistry createDOMRegistry() {
            try {
                return DOMImplementationRegistry.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
            catch (InstantiationException e) {
                throw new IllegalStateException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

