/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.CmykJpegReader;

import com.alkacon.simapi.CmykJpegReader.Validate;
import java.io.IOException;
import javax.imageio.stream.ImageInputStreamImpl;

public final class ByteArrayImageInputStream
extends ImageInputStreamImpl {
    private final byte[] data;
    private final int dataOffset;
    private final int dataLength;

    public ByteArrayImageInputStream(byte[] pData) {
        this(pData, 0, pData != null ? pData.length : -1);
    }

    public ByteArrayImageInputStream(byte[] pData, int offset, int length) {
        this.data = Validate.notNull(pData, "data");
        this.dataOffset = ByteArrayImageInputStream.isBetween(0, pData.length, offset, "offset");
        this.dataLength = ByteArrayImageInputStream.isBetween(0, pData.length - offset, length, "length");
    }

    private static int isBetween(int low, int high, int value, String name) {
        return Validate.isTrue(value >= low && value <= high, value, String.format("%s out of range [%d, %d]: %d", name, low, high, value));
    }

    @Override
    public int read() throws IOException {
        if (this.streamPos >= (long)this.dataLength) {
            return -1;
        }
        this.bitOffset = 0;
        return this.data[(int)this.streamPos++ + this.dataOffset] & 0xFF;
    }

    @Override
    public int read(byte[] pBuffer, int pOffset, int pLength) throws IOException {
        if (this.streamPos >= (long)this.dataLength) {
            return -1;
        }
        int length = (int)Math.min((long)this.dataLength - this.streamPos, (long)pLength);
        this.bitOffset = 0;
        System.arraycopy(this.data, (int)this.streamPos + this.dataOffset, pBuffer, pOffset, length);
        this.streamPos += (long)length;
        return length;
    }

    @Override
    public long length() {
        return this.dataLength;
    }

    @Override
    public boolean isCached() {
        return true;
    }

    @Override
    public boolean isCachedMemory() {
        return true;
    }
}

