/*
 * Copyright (C) Jerry Huxtable 1998
 */
package com.alkacon.simapi.filter;

import java.awt.*;
import java.awt.image.*;

public class ContrastFilter extends TransferFilter {

	static final long serialVersionUID = -2724874183243154495L;
	
	private float gain = 0.5f;
	private float bias = 0.5f;
	
	protected int transferFunction(int v) {
		float f = (float)v / 255;
		f = ImageMath.gain(f, gain);
		f = ImageMath.bias(f, bias);
		return PixelUtils.clamp((int)(f * 255));
	}

	public void setGain(float gain) {
		this.gain = gain;
		initialized = false;
	}
	
	public float getGain() {
		return gain;
	}

	public void setBias(float bias) {
		this.bias = bias;
		initialized = false;
	}
	
	public float getBias() {
		return bias;
	}

	public String toString() {
		return "Colors/Contrast...";
	}

}

