package com.alkacon.simapi.filter.fill;

import java.awt.*;

public class SeedFill {

	private final static int MAX = 1000;

	private int[] stack = new int[4*MAX];
	private int sp = 0;
	private int minX, minY, maxX, maxY;
	private PixelOp pixelOp;
	private PixelCompareOp compareOp;

	public SeedFill() {
	}
	
	public Rectangle fill(int w, int h, int x, int y, PixelOp pixelOp, PixelCompareOp compareOp) {
		Rectangle bounds = null;
		int l = 0, x1, x2, dy;
		
		this.pixelOp = pixelOp;
		this.compareOp = compareOp;

		minX = minY = 0;
		maxX = w-1;
		maxY = h-1;
		if (!compareOp.thisPixel(x, y) || x < minX || x > maxX || y < minY || y > maxY)
			return null;

		bounds = new Rectangle(x, y, 1, 1);
		push(y, x, x, 1);
		push(y+1, x, x, -1);
		while (sp > 0) {
			boolean skip;

			// Pop stack
			dy = stack[--sp];
			x2 = stack[--sp];
			x1 = stack[--sp];
			y = stack[--sp] + dy;

			for (x = x1; x >= minX && compareOp.thisPixel(x, y); x--) {
				pixelOp.apply(x, y);
				bounds.add(x, y);
			}
			if (x >= x1)
				skip = true;
			else {
				skip = false;
				l = x+1;
				if (l < x1)
					push(y, l, x1-1, -dy);
				x = x1+1;
			}
			do {
				if (!skip) {
					for (; x <= maxX && compareOp.thisPixel(x, y); x++) {
						pixelOp.apply(x, y);
						bounds.add(x, y);
					}
					push(y, l, x-1, dy);
					if (x > x2+1)
						push(y, x2+1, x-1, -dy);
				}
				for (x++; x <= x2 && !compareOp.thisPixel(x, y); x++)
					;
				l = x;
				skip = false;
			} while (x <= x2);
		}
		bounds.width++;
		bounds.height++;
		return bounds;
	}
	
	private void push(int y, int xl, int xr, int dy) {
		if (sp < MAX && y+dy >= minY && y+dy <= maxY) {
			stack[sp++] = y;
			stack[sp++] = xl;
			stack[sp++] = xr;
			stack[sp++] = dy;
		}
	}
	
}
