/*
 * Copyright (C) Jerry Huxtable 1998
 */
package com.alkacon.simapi.filter;

import java.awt.*;
import java.awt.image.*;

public class LookupFilter extends RGBImageFilter implements java.io.Serializable {

	static final long serialVersionUID = 4823747720743333615L;
	
	private Colormap colormap = new Gradient();
	
	public LookupFilter() {
		canFilterIndexColorModel = true;
	}

	public void setColormap(Colormap colormap) {
		this.colormap = colormap;
	}

	public Colormap getColormap() {
		return colormap;
	}

	public int filterRGB(int x, int y, int rgb) {
//		int a = rgb & 0xff000000;
		int r = (rgb >> 16) & 0xff;
		int g = (rgb >> 8) & 0xff;
		int b = rgb & 0xff;
		rgb = (r + g + b) / 3;
		return colormap.getColor(rgb/255.0f);
	}

	public String toString() {
		return "Colors/Lookup...";
	}

}


