/*
 * Copyright (C) Jerry Huxtable 1998
 */
package com.alkacon.simapi.filter;

import java.awt.*;
import java.awt.image.*;

public class FillFilter extends RGBImageFilter implements java.io.Serializable {

	static final long serialVersionUID = 3545801679342659341L;
	
	private int fillColor;

	public FillFilter() {
		this(0xff000000);
	}

	public FillFilter(int color) {
		this.fillColor = color;
	}

	public void setFillColor(int fillColor) {
		this.fillColor = fillColor;
	}

	public int getFillColor() {
		return fillColor;
	}

	public int filterRGB(int x, int y, int rgb) {
		return fillColor;
	}
}

