/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter;

import com.alkacon.simapi.filter.ImageMath;
import com.alkacon.simapi.filter.WarpGrid;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class WarpGridEditor
extends JPanel {
    private Image image;
    private WarpGrid warpGrid;
    private boolean showGrid = true;

    public WarpGridEditor() {
        this.setLayout(new BorderLayout());
        WarpGridCanvas canvas = new WarpGridCanvas();
        JScrollPane scrollPane = new JScrollPane(canvas);
        this.add((Component)scrollPane, "Center");
    }

    public void setWarpGrid(WarpGrid warpGrid) {
        this.warpGrid = warpGrid;
    }

    public WarpGrid getWarpGrid() {
        return this.warpGrid;
    }

    public void setImage(Image image) {
        this.image = image;
        this.repaint();
    }

    public void setShowGrid(boolean showGrid) {
        this.showGrid = showGrid;
        this.repaint();
    }

    public boolean getShowGrid() {
        return this.showGrid;
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, 200);
    }

    private void gridChanged() {
        this.firePropertyChange("warpGrid", null, this.warpGrid);
    }

    class WarpGridCanvas
    extends JComponent {
        private Graphics dragGraphics;
        private int dragRow = -1;
        private int dragCol = -1;
        private int dragX = -1;
        private int dragY = -1;

        public WarpGridCanvas() {
            this.enableEvents(16L);
        }

        public Dimension getMinimumSize() {
            return new Dimension(64, 64);
        }

        public Dimension getPreferredSize() {
            if (WarpGridEditor.this.image != null) {
                return new Dimension(WarpGridEditor.this.image.getWidth(this), WarpGridEditor.this.image.getHeight(this));
            }
            return new Dimension(164, 164);
        }

        public void paintComponent(Graphics g) {
            Dimension size = this.getSize();
            if (WarpGridEditor.this.image != null) {
                g.drawImage(WarpGridEditor.this.image, 0, 0, this);
            }
            if (WarpGridEditor.this.showGrid) {
                g.setColor(Color.yellow);
                int index = 0;
                for (int row = 0; row < ((WarpGridEditor)WarpGridEditor.this).warpGrid.rows; ++row) {
                    for (int col = 0; col < ((WarpGridEditor)WarpGridEditor.this).warpGrid.cols; ++col) {
                        int x = (int)((WarpGridEditor)WarpGridEditor.this).warpGrid.xGrid[index];
                        int y = (int)((WarpGridEditor)WarpGridEditor.this).warpGrid.yGrid[index];
                        if (row > 0) {
                            g.drawLine(x, y, (int)((WarpGridEditor)WarpGridEditor.this).warpGrid.xGrid[index - ((WarpGridEditor)WarpGridEditor.this).warpGrid.cols], (int)((WarpGridEditor)WarpGridEditor.this).warpGrid.yGrid[index - ((WarpGridEditor)WarpGridEditor.this).warpGrid.cols]);
                        }
                        if (col > 0) {
                            g.drawLine(x, y, (int)((WarpGridEditor)WarpGridEditor.this).warpGrid.xGrid[index - 1], (int)((WarpGridEditor)WarpGridEditor.this).warpGrid.yGrid[index - 1]);
                        }
                        g.fillOval(x - 2, y - 2, 5, 5);
                        ++index;
                    }
                }
            }
        }

        protected void processMouseEvent(MouseEvent e) {
            if (!this.isEnabled() || WarpGridEditor.this.warpGrid == null) {
                return;
            }
            Dimension size = this.getSize();
            int id = e.getID();
            int x = e.getX();
            int y = e.getY();
            switch (id) {
                case 501: {
                    this.dragRow = -1;
                    int index = 0;
                    for (int row = 0; row < ((WarpGridEditor)WarpGridEditor.this).warpGrid.rows; ++row) {
                        for (int col = 0; col < ((WarpGridEditor)WarpGridEditor.this).warpGrid.cols; ++col) {
                            int wx = (int)((WarpGridEditor)WarpGridEditor.this).warpGrid.xGrid[index];
                            int wy = (int)((WarpGridEditor)WarpGridEditor.this).warpGrid.yGrid[index];
                            if (wx - 2 <= x && x <= wx + 2 && wy - 2 <= y && y <= wy + 2) {
                                this.dragX = x;
                                this.dragY = y;
                                this.dragRow = row;
                                this.dragCol = col;
                                this.dragGraphics = this.getGraphics();
                                this.dragGraphics.setXORMode(this.getBackground());
                                this.dragGraphics.fillOval(this.dragX - 2, this.dragY - 2, 5, 5);
                                this.enableEvents(48L);
                                return;
                            }
                            ++index;
                        }
                    }
                    break;
                }
                case 502: {
                    this.enableEvents(16L);
                    if (this.dragRow != -1) {
                        this.dragGraphics.fillOval(this.dragX - 2, this.dragY - 2, 5, 5);
                        this.dragGraphics.dispose();
                        this.dragGraphics = null;
                        int index = this.dragRow * ((WarpGridEditor)WarpGridEditor.this).warpGrid.cols + this.dragCol;
                        ((WarpGridEditor)WarpGridEditor.this).warpGrid.xGrid[index] = ImageMath.clamp(x, 0, WarpGridEditor.this.image.getWidth(this));
                        ((WarpGridEditor)WarpGridEditor.this).warpGrid.yGrid[index] = ImageMath.clamp(y, 0, WarpGridEditor.this.image.getHeight(this));
                        this.repaint();
                        WarpGridEditor.this.gridChanged();
                    }
                    this.dragCol = -1;
                    this.dragRow = -1;
                }
            }
            super.processMouseEvent(e);
        }

        protected void processMouseMotionEvent(MouseEvent e) {
            int id = e.getID();
            int x = e.getX();
            int y = e.getY();
            switch (id) {
                case 506: {
                    if (this.dragRow == -1) break;
                    this.dragGraphics.fillOval(this.dragX - 2, this.dragY - 2, 5, 5);
                    this.dragX = ImageMath.clamp(x, 0, WarpGridEditor.this.image.getWidth(this));
                    this.dragY = ImageMath.clamp(y, 0, WarpGridEditor.this.image.getHeight(this));
                    this.dragGraphics.fillOval(this.dragX - 2, this.dragY - 2, 5, 5);
                }
            }
            super.processMouseMotionEvent(e);
        }
    }
}

