/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter;

import java.awt.image.RGBImageFilter;
import java.io.Serializable;

public abstract class TransferFilter
extends RGBImageFilter
implements Serializable {
    protected int[] rTable;
    protected int[] gTable;
    protected int[] bTable;
    protected boolean initialized = false;

    public TransferFilter() {
        this.canFilterIndexColorModel = true;
    }

    public int filterRGB(int x, int y, int rgb) {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
        int a = rgb & 0xFF000000;
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        r = this.rTable[r];
        g = this.gTable[g];
        b = this.bTable[b];
        return a | r << 16 | g << 8 | b;
    }

    public void setDimensions(int width, int height) {
        this.initialized = false;
        super.setDimensions(width, height);
    }

    protected void initialize() {
        this.bTable = this.makeTable();
        this.gTable = this.bTable;
        this.rTable = this.bTable;
    }

    protected int[] makeTable() {
        int[] table = new int[256];
        for (int i = 0; i < 256; ++i) {
            table[i] = this.transferFunction(i);
        }
        return table;
    }

    protected int transferFunction(int v) {
        return 0;
    }
}

