/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter;

import com.alkacon.simapi.filter.PixelUtils;
import java.awt.image.RGBImageFilter;
import java.io.Serializable;

public class RGBAdjustFilter
extends RGBImageFilter
implements Serializable {
    static final long serialVersionUID = 3509907597266563800L;
    public float rFactor;
    public float gFactor;
    public float bFactor;

    public RGBAdjustFilter() {
        this(0.0f, 0.0f, 0.0f);
    }

    public RGBAdjustFilter(float r, float g, float b) {
        this.rFactor = 1.0f + r;
        this.gFactor = 1.0f + g;
        this.bFactor = 1.0f + b;
        this.canFilterIndexColorModel = true;
    }

    public int filterRGB(int x, int y, int rgb) {
        int a = rgb & 0xFF000000;
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        r = PixelUtils.clamp((int)((float)r * this.rFactor));
        g = PixelUtils.clamp((int)((float)g * this.gFactor));
        b = PixelUtils.clamp((int)((float)b * this.bFactor));
        return a | r << 16 | g << 8 | b;
    }

    public String toString() {
        return "Colors/Adjust RGB...";
    }
}

