/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter;

import com.alkacon.simapi.filter.ImageDisplay;
import com.alkacon.simapi.filter.WarpFilter;
import com.alkacon.simapi.filter.WarpGrid;
import com.alkacon.simapi.filter.WarpGridEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.FilteredImageSource;
import java.awt.image.MemoryImageSource;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Morph
extends JPanel
implements PropertyChangeListener,
ChangeListener,
ActionListener,
ItemListener {
    private int rows = 7;
    private int cols = 7;
    private WarpGridEditor editor1;
    private WarpGridEditor editor2;
    private WarpGridEditor editor3;
    private WarpGrid warpGrid1;
    private WarpGrid warpGrid2;
    private WarpGrid warpGrid3;
    private WarpFilter filter = new WarpFilter();
    private Image sourceImage;
    private Image destImage;
    private JSlider tSlider;
    private JCheckBox dissolveCheck;
    private JCheckBox showGridCheck;
    private JComboBox gridCombo;
    private JButton animateButton;
    private float t = 1.0f;
    private boolean dissolveEm = true;

    public Morph(String imageName1, String imageName2) {
        JPanel panel = new JPanel();
        this.setLayout(new BorderLayout());
        panel.setLayout(new GridLayout(1, 3));
        this.editor1 = new WarpGridEditor();
        this.editor2 = new WarpGridEditor();
        this.editor3 = new WarpGridEditor();
        this.sourceImage = this.getToolkit().getImage(imageName1);
        this.destImage = this.getToolkit().getImage(imageName2);
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(this.sourceImage, 0);
        tracker.addImage(this.destImage, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        this.warpGrid1 = new WarpGrid(this.rows, this.cols, this.sourceImage.getWidth(this), this.sourceImage.getHeight(this));
        this.warpGrid2 = new WarpGrid(this.rows, this.cols, this.destImage.getWidth(this), this.destImage.getHeight(this));
        this.warpGrid3 = new WarpGrid(this.rows, this.cols, this.sourceImage.getWidth(this), this.sourceImage.getHeight(this));
        this.editor1.setBorder(new TitledBorder("Source"));
        this.editor1.setImage(this.sourceImage);
        this.editor1.setWarpGrid(this.warpGrid1);
        this.editor1.addPropertyChangeListener(this);
        this.editor2.setBorder(new TitledBorder("Destination"));
        this.editor2.setImage(this.destImage);
        this.editor2.setWarpGrid(this.warpGrid2);
        this.editor2.addPropertyChangeListener(this);
        this.editor3.setBorder(new TitledBorder("Intermediate"));
        this.editor3.setImage(this.sourceImage);
        this.editor3.setWarpGrid(this.warpGrid3);
        this.editor3.setEnabled(false);
        panel.add(this.editor1);
        panel.add(this.editor2);
        panel.add(this.editor3);
        this.add((Component)panel, "Center");
        panel = new JPanel();
        this.tSlider = new JSlider(0, 0, 100, 0);
        panel.add(this.tSlider);
        this.tSlider.setPaintTicks(true);
        this.tSlider.setMajorTickSpacing(50);
        this.tSlider.setMinorTickSpacing(10);
        this.tSlider.setPaintLabels(true);
        this.tSlider.setValue((int)((double)this.t * 100.0));
        this.tSlider.addChangeListener(this);
        panel.add(new JLabel("Grid Size:", 4));
        this.gridCombo = new JComboBox();
        panel.add(this.gridCombo);
        for (int i = 0; i < 12; ++i) {
            this.gridCombo.addItem(i + 3 + "x" + (i + 3));
        }
        this.gridCombo.setSelectedIndex(this.rows - 3);
        this.gridCombo.addItemListener(this);
        this.dissolveCheck = new JCheckBox("Dissolve");
        panel.add(this.dissolveCheck);
        this.dissolveCheck.setSelected(this.dissolveEm);
        this.dissolveCheck.addChangeListener(this);
        this.showGridCheck = new JCheckBox("Show Grids");
        panel.add(this.showGridCheck);
        this.showGridCheck.setSelected(true);
        this.showGridCheck.addChangeListener(this);
        this.animateButton = new JButton("Animate");
        panel.add(this.animateButton);
        this.animateButton.addActionListener(this);
        this.add((Component)panel, "South");
    }

    public void setGridSize(int rows, int cols) {
        this.warpGrid1 = new WarpGrid(rows, cols, this.sourceImage.getWidth(this), this.sourceImage.getHeight(this));
        this.warpGrid2 = new WarpGrid(rows, cols, this.destImage.getWidth(this), this.destImage.getHeight(this));
        this.warpGrid3 = new WarpGrid(rows, cols, this.sourceImage.getWidth(this), this.sourceImage.getHeight(this));
        this.editor1.setWarpGrid(this.warpGrid1);
        this.editor2.setWarpGrid(this.warpGrid2);
        this.editor3.setWarpGrid(this.warpGrid3);
        this.editor1.repaint();
        this.editor2.repaint();
        this.editor3.repaint();
        this.preview();
    }

    public void preview() {
        if (this.dissolveEm) {
            int width = this.sourceImage.getWidth(this);
            int height = this.sourceImage.getHeight(this);
            int[] srcPixels = this.filter.getPixels(this.sourceImage, width, height);
            int[] destPixels = this.filter.getPixels(this.destImage, width, height);
            int[] outPixels = new int[width * height];
            this.filter.morph(srcPixels, destPixels, outPixels, this.warpGrid1, this.warpGrid2, width, height, this.t);
            this.editor3.setImage(this.createImage(new MemoryImageSource(width, height, outPixels, 0, width)));
        } else {
            this.filter.setSourceGrid(this.warpGrid1);
            this.warpGrid1.lerp(this.t, this.warpGrid2, this.warpGrid3);
            this.filter.setDestGrid(this.warpGrid3);
            this.editor3.setImage(this.createImage(new FilteredImageSource(this.sourceImage.getSource(), this.filter)));
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        this.preview();
    }

    public void stateChanged(ChangeEvent e) {
        if (this.filter != null) {
            Object source = e.getSource();
            if (source instanceof JSlider && ((JSlider)source).getValueIsAdjusting()) {
                return;
            }
            if (source == this.tSlider) {
                this.t = (float)this.tSlider.getValue() / 100.0f;
            } else if (source == this.dissolveCheck) {
                this.dissolveEm = this.dissolveCheck.isSelected();
            } else if (source == this.showGridCheck) {
                boolean b = this.showGridCheck.isSelected();
                this.editor1.setShowGrid(b);
                this.editor2.setShowGrid(b);
                this.editor3.setShowGrid(b);
                return;
            }
            this.preview();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (this.filter != null) {
            Object source = e.getSource();
            if (source == this.gridCombo) {
                int i = this.gridCombo.getSelectedIndex();
                this.setGridSize(i + 3, i + 3);
            }
            this.preview();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String text;
        Object source = e.getSource();
        if (source == this.animateButton && (text = (String)JOptionPane.showInputDialog(this, "Number of Frames:", "Animate", -1, null, null, "10")) != null) {
            try {
                int numFrames = Integer.parseInt(text);
                WarpFilter wf = (WarpFilter)this.filter.clone();
                wf.setSourceGrid(this.warpGrid1);
                wf.setDestGrid(this.warpGrid2);
                int width = this.sourceImage.getWidth(this);
                int height = this.sourceImage.getHeight(this);
                Image image = this.createImage(numFrames * width, height);
                Graphics g = image.getGraphics();
                for (int i = 0; i < numFrames; ++i) {
                    float t = (float)i / (float)(numFrames - 1);
                    int[] srcPixels = this.filter.getPixels(this.sourceImage, width, height);
                    int[] destPixels = this.filter.getPixels(this.destImage, width, height);
                    int[] outPixels = new int[width * height];
                    this.filter.morph(srcPixels, destPixels, outPixels, this.warpGrid1, this.warpGrid2, width, height, t);
                    Image f = this.createImage(new MemoryImageSource(width, height, outPixels, 0, width));
                    g.drawImage(f, i * width, 0, this);
                }
                g.dispose();
                Frame frame = new Frame();
                ImageDisplay canvas = new ImageDisplay();
                canvas.setImage(image);
                frame.add((Component)new JScrollPane(canvas), "Center");
                frame.pack();
                frame.show();
            }
            catch (NumberFormatException ex) {
                this.getToolkit().beep();
            }
        }
    }

    public static void main(String[] args) {
        if (args.length >= 2) {
            Frame f = new Frame("Warp");
            f.add(new Morph(args[0], args[1]));
            f.pack();
            f.show();
        } else {
            System.out.println("Usage: Morph image1 image2");
        }
    }
}

