/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter;

import com.alkacon.simapi.filter.Kernel;
import com.alkacon.simapi.filter.PixelUtils;
import com.alkacon.simapi.filter.WholeImageFilter;

public class ConvolveFilter
extends WholeImageFilter {
    static final long serialVersionUID = 2239251672685254626L;
    protected Kernel kernel = null;
    public boolean alpha = true;

    public ConvolveFilter() {
        this(new float[9]);
    }

    public ConvolveFilter(float[] matrix) {
        this(new Kernel(3, 3, matrix));
    }

    public ConvolveFilter(int rows, int cols, float[] matrix) {
        this(new Kernel(rows, cols, matrix));
    }

    public ConvolveFilter(Kernel kernel) {
        this.kernel = kernel;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public void imageComplete(int status) {
        if (status == 1 || status == 4) {
            this.consumer.imageComplete(status);
            return;
        }
        int width = this.originalSpace.width;
        int height = this.originalSpace.height;
        int[] outPixels = new int[width * height];
        ConvolveFilter.convolve(this.kernel, this.inPixels, outPixels, width, height, this.alpha);
        this.consumer.setPixels(0, 0, width, height, this.defaultRGBModel, outPixels, 0, width);
        this.consumer.imageComplete(status);
        this.inPixels = null;
    }

    public static void convolve(Kernel kernel, int[] inPixels, int[] outPixels, int width, int height) {
        ConvolveFilter.convolve(kernel, inPixels, outPixels, width, height, true);
    }

    public static void convolve(Kernel kernel, int[] inPixels, int[] outPixels, int width, int height, boolean alpha) {
        if (kernel.rows == 1) {
            ConvolveFilter.convolveH(kernel, inPixels, outPixels, width, height, alpha);
        } else if (kernel.cols == 1) {
            ConvolveFilter.convolveV(kernel, inPixels, outPixels, width, height, alpha);
        } else {
            ConvolveFilter.convolveHV(kernel, inPixels, outPixels, width, height, alpha);
        }
    }

    public static void convolveHV(Kernel kernel, int[] inPixels, int[] outPixels, int width, int height, boolean alpha) {
        int index = 0;
        float[] matrix = kernel.matrix;
        int rows = kernel.rows;
        int cols = kernel.cols;
        int rows2 = rows / 2;
        int cols2 = cols / 2;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float r = 0.0f;
                float g = 0.0f;
                float b = 0.0f;
                float a = 0.0f;
                for (int row = -rows2; row <= rows2; ++row) {
                    int iy = y + row;
                    int ioffset = 0 <= iy && iy < height ? iy * width : y * width;
                    int moffset = cols * (row + rows2) + cols2;
                    for (int col = -cols2; col <= cols2; ++col) {
                        float f = matrix[moffset + col];
                        if (f == 0.0f) continue;
                        int ix = x + col;
                        if (0 > ix || ix >= width) {
                            ix = x;
                        }
                        int rgb = inPixels[ioffset + ix];
                        a += f * (float)(rgb >> 24 & 0xFF);
                        r += f * (float)(rgb >> 16 & 0xFF);
                        g += f * (float)(rgb >> 8 & 0xFF);
                        b += f * (float)(rgb & 0xFF);
                    }
                }
                int ia = alpha ? PixelUtils.clamp((int)((double)a + 0.5)) : 255;
                int ir = PixelUtils.clamp((int)((double)r + 0.5));
                int ig = PixelUtils.clamp((int)((double)g + 0.5));
                int ib = PixelUtils.clamp((int)((double)b + 0.5));
                outPixels[index++] = ia << 24 | ir << 16 | ig << 8 | ib;
            }
        }
    }

    public static void convolveH(Kernel kernel, int[] inPixels, int[] outPixels, int width, int height, boolean alpha) {
        int index = 0;
        float[] matrix = kernel.matrix;
        int cols = kernel.cols;
        int cols2 = cols / 2;
        for (int y = 0; y < height; ++y) {
            int ioffset = y * width;
            for (int x = 0; x < width; ++x) {
                float r = 0.0f;
                float g = 0.0f;
                float b = 0.0f;
                float a = 0.0f;
                int moffset = cols2;
                for (int col = -cols2; col <= cols2; ++col) {
                    float f = matrix[moffset + col];
                    if (f == 0.0f) continue;
                    int ix = x + col;
                    if (0 > ix || ix >= width) {
                        ix = x;
                    }
                    int rgb = inPixels[ioffset + ix];
                    a += f * (float)(rgb >> 24 & 0xFF);
                    r += f * (float)(rgb >> 16 & 0xFF);
                    g += f * (float)(rgb >> 8 & 0xFF);
                    b += f * (float)(rgb & 0xFF);
                }
                int ia = alpha ? PixelUtils.clamp((int)((double)a + 0.5)) : 255;
                int ir = PixelUtils.clamp((int)((double)r + 0.5));
                int ig = PixelUtils.clamp((int)((double)g + 0.5));
                int ib = PixelUtils.clamp((int)((double)b + 0.5));
                outPixels[index++] = ia << 24 | ir << 16 | ig << 8 | ib;
            }
        }
    }

    public static void convolveV(Kernel kernel, int[] inPixels, int[] outPixels, int width, int height, boolean alpha) {
        int index = 0;
        float[] matrix = kernel.matrix;
        int rows = kernel.rows;
        int rows2 = rows / 2;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float r = 0.0f;
                float g = 0.0f;
                float b = 0.0f;
                float a = 0.0f;
                for (int row = -rows2; row <= rows2; ++row) {
                    int iy = y + row;
                    int ioffset = 0 <= iy && iy < height ? iy * width : y * width;
                    float f = matrix[row + rows2];
                    if (f == 0.0f) continue;
                    int rgb = inPixels[ioffset + x];
                    a += f * (float)(rgb >> 24 & 0xFF);
                    r += f * (float)(rgb >> 16 & 0xFF);
                    g += f * (float)(rgb >> 8 & 0xFF);
                    b += f * (float)(rgb & 0xFF);
                }
                int ia = alpha ? PixelUtils.clamp((int)((double)a + 0.5)) : 255;
                int ir = PixelUtils.clamp((int)((double)r + 0.5));
                int ig = PixelUtils.clamp((int)((double)g + 0.5));
                int ib = PixelUtils.clamp((int)((double)b + 0.5));
                outPixels[index++] = ia << 24 | ir << 16 | ig << 8 | ib;
            }
        }
    }

    public String toString() {
        return "Blur/Convolve...";
    }
}

