/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi;

import com.alkacon.simapi.RenderSettings;
import com.alkacon.simapi.filter.WholeImageFilter;
import com.alkacon.simapi.filter.buffered.BoxBlurFilter;
import com.alkacon.simapi.filter.buffered.GaussianFilter;
import com.alkacon.simapi.util.GifImageWriterSpi;
import com.alkacon.simapi.util.Quantize;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

public class Simapi {
    public static final Color COLOR_TRANSPARENT = new Color(0, 0, 0, 255);
    public static final int POS_CENTER = 0;
    public static final int POS_DOWN_LEFT = 1;
    public static final int POS_DOWN_RIGHT = 2;
    public static final int POS_STRAIGHT_DOWN = 3;
    public static final int POS_STRAIGHT_LEFT = 4;
    public static final int POS_STRAIGHT_RIGHT = 5;
    public static final int POS_STRAIGHT_UP = 6;
    public static final int POS_UP_LEFT = 7;
    public static final int POS_UP_RIGHT = 8;
    public static final int RENDER_MEDIUM = 1;
    public static final int RENDER_QUALITY = 0;
    public static final int RENDER_SPEED = 2;
    public static final String TYPE_BMP = "BMP";
    public static final String TYPE_GIF = "GIF";
    public static final String TYPE_JPEG = "JPEG";
    public static final String TYPE_PNG = "PNG";
    public static final String TYPE_PNM = "PNM";
    public static final String TYPE_TIFF = "TIFF";
    private RenderSettings m_renderSettings;

    public Simapi() {
        this(new RenderSettings(0));
    }

    public Simapi(RenderSettings renderSettings) {
        this.m_renderSettings = renderSettings;
    }

    public static String getImageType(String filename) {
        String type;
        if (filename == null) {
            return null;
        }
        int pos = filename.lastIndexOf(46);
        if (pos < 0) {
            type = filename;
        } else {
            if (pos < filename.length()) {
                ++pos;
            }
            type = filename.substring(pos);
        }
        type = type.trim().toUpperCase();
        if (type.equals(TYPE_JPEG) || type.equals("JPG")) {
            type = TYPE_JPEG;
        } else if (type.equals(TYPE_GIF)) {
            type = TYPE_GIF;
        } else if (type.equals(TYPE_PNG)) {
            type = TYPE_PNG;
        } else if (type.equals(TYPE_TIFF) || type.equals("TIF")) {
            type = TYPE_TIFF;
        } else if (type.equals(TYPE_BMP)) {
            type = TYPE_BMP;
        } else if (type.equals(TYPE_PNM) || type.equals("PBM") || type.equals("PGM") || type.equals("PPM")) {
            type = TYPE_PNM;
        }
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(type);
        if (iter.hasNext()) {
            return type;
        }
        return null;
    }

    public static BufferedImage read(byte[] source) throws IOException {
        return Simapi.read(new ByteArrayInputStream(source));
    }

    public static BufferedImage read(File source) throws IOException {
        return Simapi.ensureImageIsSystemType(ImageIO.read(source), true);
    }

    public static BufferedImage read(InputStream source) throws IOException {
        return Simapi.ensureImageIsSystemType(ImageIO.read(source), true);
    }

    public static BufferedImage read(String source) throws IOException {
        return Simapi.read(new File(source));
    }

    public static BufferedImage read(URL source) throws IOException {
        return Simapi.ensureImageIsSystemType(ImageIO.read(source), true);
    }

    protected static BufferedImage ensureImageIsSystemType(BufferedImage image, boolean allowTransparent) {
        switch (image.getType()) {
            case 1: 
            case 2: {
                return image;
            }
        }
        BufferedImage result = allowTransparent && image.getColorModel().getTransparency() != 1 ? new BufferedImage(image.getWidth(), image.getHeight(), 2) : new BufferedImage(image.getWidth(), image.getHeight(), 1);
        Graphics2D g = result.createGraphics();
        g.drawImage((Image)image, 0, 0, null);
        g.dispose();
        image.flush();
        image = null;
        return result;
    }

    public BufferedImage applyFilter(BufferedImage image, ImageFilter filter) {
        Image img = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), filter));
        PixelGrabber pg = new PixelGrabber(img, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        BufferedImage result = new BufferedImage(img.getWidth(null), img.getHeight(null), pg.getColorModel().hasAlpha() ? 2 : 1);
        Graphics2D g = result.createGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        return result;
    }

    public Rectangle applyFilterDimensions(int width, int height) {
        Rectangle base = new Rectangle(width, height);
        for (ImageFilter filter : this.m_renderSettings.getImageFilters()) {
            if (!(filter instanceof WholeImageFilter)) continue;
            WholeImageFilter wholeFilter = (WholeImageFilter)filter;
            base = wholeFilter.getTransformedSpace(base);
        }
        return base;
    }

    public BufferedImage applyFilters(BufferedImage image) {
        image = Simapi.ensureImageIsSystemType(image, true);
        this.threadSetNice();
        for (ImageFilter filter : this.m_renderSettings.getImageFilters()) {
            image = this.applyFilter(image, filter);
        }
        this.threadSetNormal();
        return image;
    }

    public BufferedImage crop(BufferedImage image, int width, int height, int cropPosition) {
        int y;
        int x;
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        if (imageWidth == width && imageHeight == height) {
            return image;
        }
        switch (cropPosition) {
            case 1: {
                x = 0;
                y = imageHeight - height;
                break;
            }
            case 2: {
                x = imageWidth - width;
                y = imageHeight - height;
                break;
            }
            case 3: {
                x = (imageWidth - width) / 2;
                y = imageHeight - height;
                break;
            }
            case 4: {
                x = 0;
                y = (imageHeight - height) / 2;
                break;
            }
            case 5: {
                x = imageWidth - width;
                y = (imageHeight - height) / 2;
                break;
            }
            case 6: {
                x = (imageWidth - width) / 2;
                y = 0;
                break;
            }
            case 7: {
                x = 0;
                y = 0;
                break;
            }
            case 8: {
                x = imageWidth - width;
                y = 0;
                break;
            }
            default: {
                x = (imageWidth - width) / 2;
                y = (imageHeight - height) / 2;
            }
        }
        return image.getSubimage(x, y, width, height);
    }

    public BufferedImage crop(BufferedImage image, int x, int y, int width, int height) {
        return this.crop(image, x, y, width, height, COLOR_TRANSPARENT);
    }

    public BufferedImage crop(BufferedImage image, int x, int y, int width, int height, Color backgroundColor) {
        if (x < 0 || y < 0 || x + width >= image.getWidth() || y + height >= image.getHeight()) {
            int xpos = x;
            int ypos = y;
            int imageWidth = image.getWidth();
            int imageHeight = image.getHeight();
            if (x < 0) {
                xpos = Math.abs(x);
                x = 0;
                imageWidth += xpos;
            } else {
                xpos = 0;
            }
            if (y < 0) {
                ypos = Math.abs(y);
                y = 0;
                imageHeight += ypos;
            } else {
                ypos = 0;
            }
            if (imageWidth < width) {
                imageWidth += width;
            }
            if (imageHeight < height) {
                imageHeight += height;
            }
            BufferedImage result = this.createImage(image.getColorModel(), imageWidth, imageHeight);
            Graphics2D g = result.createGraphics();
            ColorModel cm = result.getColorModel();
            if (!cm.hasAlpha() && backgroundColor == COLOR_TRANSPARENT) {
                backgroundColor = this.m_renderSettings.getTransparentReplaceColor();
            }
            if (backgroundColor != COLOR_TRANSPARENT) {
                g.setPaintMode();
                g.setColor(backgroundColor);
                g.fillRect(0, 0, result.getWidth(), result.getHeight());
            }
            g.drawImage((Image)image, xpos, ypos, null);
            g.dispose();
            image = result;
        }
        return image.getSubimage(x, y, width, height);
    }

    public BufferedImage cropToSize(BufferedImage image, int x, int y, int width, int height, int targetWidth, int targetHeight) {
        return this.cropToSize(image, x, y, width, height, targetWidth, targetHeight, COLOR_TRANSPARENT);
    }

    public BufferedImage cropToSize(BufferedImage image, int x, int y, int width, int height, int targetWidth, int targetHeight, Color backgroundColor) {
        image = this.crop(image, x, y, width, height, backgroundColor);
        image = this.resize(image, targetWidth, targetHeight);
        return image;
    }

    public byte[] getBytes(BufferedImage image, String type) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        this.write(image, out, type);
        return out.toByteArray();
    }

    public BufferedImage reduceColors(BufferedImage image, int maxColors, boolean alphaToBitmask) {
        return Quantize.process(image, maxColors, alphaToBitmask);
    }

    public BufferedImage resize(BufferedImage image, int width, int height) {
        return this.resize(image, width, height, false);
    }

    public BufferedImage resize(BufferedImage image, int width, int height, boolean bestfit) {
        return this.resize(image, width, height, bestfit, true);
    }

    public BufferedImage resize(BufferedImage image, int width, int height, boolean bestfit, boolean blowup) {
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        if (imageWidth == width && imageHeight == height || !blowup && imageWidth < width && imageHeight < height) {
            return image;
        }
        float widthScale = (float)width / (float)imageWidth;
        float heightScale = (float)height / (float)imageHeight;
        int targetWidth = width;
        int targetHeight = height;
        if (bestfit) {
            if (widthScale < heightScale) {
                heightScale = widthScale;
                targetHeight = (int)((float)imageHeight * heightScale);
                if (imageHeight > 50 && Math.abs(targetHeight - height) == 1) {
                    targetHeight = height;
                }
            } else if (widthScale > heightScale) {
                widthScale = heightScale;
                targetWidth = (int)((float)imageWidth * widthScale);
                if (imageWidth > 50 && Math.abs(targetWidth - width) == 1) {
                    targetWidth = width;
                }
            }
        }
        return this.scale(image, widthScale, heightScale, targetWidth, targetHeight);
    }

    public BufferedImage resize(BufferedImage image, int width, int height, Color backgroundColor, int position) {
        return this.resize(image, width, height, backgroundColor, position, true);
    }

    public BufferedImage resize(BufferedImage image, int width, int height, Color backgroundColor, int position, boolean blowup) {
        int y;
        int x;
        BufferedImage scaled = this.resize(image, width, height, true, blowup);
        int scaledWidth = scaled.getWidth();
        int scaledHeight = scaled.getHeight();
        ColorModel cm = scaled.getColorModel();
        if (!cm.hasAlpha() && backgroundColor == COLOR_TRANSPARENT) {
            backgroundColor = this.m_renderSettings.getTransparentReplaceColor();
        }
        if (scaledWidth == width && scaledHeight == height) {
            if (image.getColorModel().hasAlpha() && backgroundColor != COLOR_TRANSPARENT) {
                position = 7;
            } else {
                return scaled;
            }
        }
        this.threadSetNice();
        BufferedImage result = this.createImage(scaled.getColorModel(), width, height);
        Graphics2D g = result.createGraphics();
        if (backgroundColor != COLOR_TRANSPARENT) {
            g.setPaintMode();
            g.setColor(backgroundColor);
            g.fillRect(0, 0, width, height);
        }
        switch (position) {
            case 1: {
                x = 0;
                y = height - scaledHeight;
                break;
            }
            case 2: {
                x = width - scaledWidth;
                y = height - scaledHeight;
                break;
            }
            case 3: {
                x = (width - scaledWidth) / 2;
                y = height - scaledHeight;
                break;
            }
            case 4: {
                x = 0;
                y = (height - scaledHeight) / 2;
                break;
            }
            case 5: {
                x = width - scaledWidth;
                y = (height - scaledHeight) / 2;
                break;
            }
            case 6: {
                x = (width - scaledWidth) / 2;
                y = 0;
                break;
            }
            case 7: {
                x = 0;
                y = 0;
                break;
            }
            case 8: {
                x = width - scaledWidth;
                y = 0;
                break;
            }
            default: {
                x = (width - scaledWidth) / 2;
                y = (height - scaledHeight) / 2;
            }
        }
        g.drawImage((Image)scaled, x, y, null);
        g.dispose();
        scaled.flush();
        scaled = null;
        this.threadSetNormal();
        return result;
    }

    public BufferedImage resize(BufferedImage image, int width, int height, int position) {
        BufferedImage scaledImage;
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        if (imageWidth == width && imageHeight == height) {
            return image;
        }
        float widthScale = (float)width / (float)imageWidth;
        float heightScale = (float)height / (float)imageHeight;
        if (widthScale >= heightScale) {
            heightScale = widthScale;
        } else {
            widthScale = heightScale;
        }
        if ((double)widthScale != 1.0 && (double)heightScale != 1.0) {
            scaledImage = this.scale(image, widthScale, heightScale);
            imageWidth = scaledImage.getWidth();
            imageHeight = scaledImage.getHeight();
        } else {
            scaledImage = image;
        }
        return this.crop(scaledImage, width, height, position);
    }

    public BufferedImage scale(BufferedImage image, float scale) {
        return this.scale(image, scale, scale);
    }

    public BufferedImage scale(BufferedImage image, float widthScale, float heightScale) {
        int targetWidth = Math.round((float)image.getWidth() * widthScale);
        int targetHeight = Math.round((float)image.getHeight() * heightScale);
        return this.scale(image, widthScale, heightScale, targetWidth, targetHeight);
    }

    public BufferedImage scale(BufferedImage image, float widthScale, float heightScale, int targetWidth, int targetHeight) {
        if (this.m_renderSettings.isUseBlur() && (widthScale < 0.575f || heightScale < 0.575f)) {
            this.threadSetNice();
            int pixel = image.getWidth() * image.getHeight();
            if (pixel > this.m_renderSettings.getMaximumBlurSize()) {
                double fac = Math.sqrt((double)this.m_renderSettings.getMaximumBlurSize() / (double)pixel);
                int height = (int)((double)image.getHeight() * fac);
                int width = (int)((double)image.getWidth() * fac);
                image = this.scale(image, width, height);
                widthScale = (float)targetWidth / (float)width;
                heightScale = (float)targetHeight / (float)height;
            }
            double factor = (double)((float)image.getWidth() / (widthScale * (float)image.getWidth()) + (float)image.getHeight() / (heightScale * (float)image.getHeight())) / 2.0;
            int average = (image.getWidth() + image.getHeight()) / 2;
            if (factor < 5.0 && average < 1000) {
                GaussianFilter gauss = new GaussianFilter();
                double radius = Math.sqrt(2.0 * factor);
                gauss.setRadius((float)radius);
                image = gauss.filter(image, null);
            } else {
                double root = Math.sqrt(factor);
                int radius = factor < 3.5 || pixel > this.m_renderSettings.getMaximumBlurSize() ? (int)Math.floor(root) : (int)Math.round(root);
                BoxBlurFilter blur = new BoxBlurFilter();
                blur.setRadius(radius);
                image = blur.filter(image, null);
            }
            this.threadSetNormal();
        }
        return this.scale(image, targetWidth, targetHeight);
    }

    public BufferedImage scale(BufferedImage image, int targetWidth, int targetHeight) {
        BufferedImage result = this.createImage(image.getColorModel(), targetWidth, targetHeight);
        Graphics2D g = result.createGraphics();
        g.setRenderingHints(this.m_renderSettings.getRenderingHints());
        g.drawImage(image, 0, 0, targetWidth, targetHeight, null);
        g.dispose();
        return result;
    }

    public void write(BufferedImage image, File destination, String type) throws IOException {
        this.write(image, (Object)destination, type);
    }

    public void write(BufferedImage image, OutputStream destination, String type) throws IOException {
        this.write(image, (Object)destination, type);
    }

    public void write(BufferedImage image, String destination, String type) throws IOException {
        this.write(image, new File(destination), type);
    }

    protected BufferedImage createImage(ColorModel colorModel, int width, int height) {
        BufferedImage result = colorModel.getTransparency() == 1 && this.m_renderSettings.getTransparentReplaceColor() != COLOR_TRANSPARENT ? new BufferedImage(width, height, 1) : new BufferedImage(width, height, 2);
        return result;
    }

    protected void write(BufferedImage im, Object output, String formatName) throws IOException {
        ImageWriter writer;
        ImageWriteParam param;
        if (output == null) {
            throw new IllegalArgumentException("output == null!");
        }
        if (im == null) {
            throw new IllegalArgumentException("image == null!");
        }
        if (formatName == null) {
            throw new IllegalArgumentException("formatName == null!");
        }
        ImageOutputStream stream = null;
        try {
            stream = ImageIO.createImageOutputStream(output);
        }
        catch (IOException e) {
            throw new IIOException("Can't create output stream!", e);
        }
        formatName = Simapi.getImageType(formatName);
        if (formatName == null) {
            throw new IllegalArgumentException("no writers found for format '" + formatName + "'");
        }
        if (im.getColorModel().hasAlpha() && (TYPE_JPEG == formatName || TYPE_TIFF == formatName || TYPE_BMP == formatName)) {
            BufferedImage result = new BufferedImage(im.getWidth(), im.getHeight(), 1);
            Graphics2D g = result.createGraphics();
            g.setPaintMode();
            g.setColor(this.m_renderSettings.getTransparentReplaceColor());
            g.fillRect(0, 0, result.getWidth(), result.getHeight());
            g.drawImage((Image)im, 0, 0, null);
            g.dispose();
            im = result;
        }
        if ((param = (writer = ImageIO.getImageWritersByFormatName(formatName).next()).getDefaultWriteParam()).canWriteCompressed()) {
            param.setCompressionMode(2);
            if (param.getCompressionTypes() != null && param.getCompressionType() == null) {
                param.setCompressionType(param.getCompressionTypes()[0]);
            }
            param.setCompressionQuality(this.m_renderSettings.getCompressionQuality());
        }
        writer.setOutput(stream);
        writer.write(null, new IIOImage(im, null, null), param);
        stream.flush();
        writer.dispose();
        stream.close();
    }

    private void threadSetNice() {
        Thread t = Thread.currentThread();
        if (t.getPriority() > this.m_renderSettings.getThreadNicePriority()) {
            this.m_renderSettings.setThreadOldPriority(t.getPriority());
            try {
                t.setPriority(this.m_renderSettings.getThreadNicePriority());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void threadSetNormal() {
        Thread t = Thread.currentThread();
        if (t.getPriority() != this.m_renderSettings.getThreadOldPriority()) {
            try {
                t.setPriority(this.m_renderSettings.getThreadOldPriority());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        GifImageWriterSpi alkaconGifSpi = new GifImageWriterSpi();
        IIORegistry.getDefaultInstance().registerServiceProvider(alkaconGifSpi);
        Iterator<ImageWriterSpi> i = null;
        try {
            i = IIORegistry.getDefaultInstance().getServiceProviders(ImageWriterSpi.class, true);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        if (i != null) {
            block2: while (i.hasNext()) {
                ImageWriterSpi spi = i.next();
                if (spi.getClass() == GifImageWriterSpi.class) continue;
                String[] formats = spi.getFormatNames();
                for (int j = 0; j < formats.length; ++j) {
                    String format = formats[j];
                    if (!"gif".equals(format.toLowerCase())) continue;
                    IIORegistry.getDefaultInstance().setOrdering(ImageWriterSpi.class, alkaconGifSpi, spi);
                    continue block2;
                }
            }
        }
    }
}

