/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tea.okhttp;

import com.aliyun.tea.TeaRequest;
import com.aliyun.tea.okhttp.OkRequestBody;
import java.net.URL;
import java.util.Map;
import okhttp3.Request;
import okhttp3.RequestBody;

public class OkRequestBuilder {
    private final Request.Builder builder;

    public OkRequestBuilder(Request.Builder builder) {
        this.builder = builder;
    }

    public OkRequestBuilder url(URL url) {
        this.builder.url(url);
        return this;
    }

    public OkRequestBuilder header(Map<String, String> headers) {
        for (String headerName : headers.keySet()) {
            this.builder.header(headerName, headers.get(headerName));
        }
        return this;
    }

    public Request buildRequest(TeaRequest request) {
        String method;
        switch (method = request.method.toUpperCase()) {
            case "DELETE": {
                OkRequestBody requestBody = new OkRequestBody(request);
                this.builder.delete((RequestBody)requestBody);
                break;
            }
            case "POST": {
                OkRequestBody requestBody = new OkRequestBody(request);
                this.builder.post((RequestBody)requestBody);
                break;
            }
            case "PUT": {
                OkRequestBody requestBody = new OkRequestBody(request);
                this.builder.put((RequestBody)requestBody);
                break;
            }
            case "PATCH": {
                OkRequestBody requestBody = new OkRequestBody(request);
                this.builder.patch((RequestBody)requestBody);
                break;
            }
            case "HEAD": {
                this.builder.head();
                break;
            }
            default: {
                this.builder.get();
            }
        }
        return this.builder.build();
    }
}

