package com.aliyun.core.tracing;

import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanContext;

public interface AlibabaCloudSpanBuilder extends SpanBuilder {
    /**
     * 指定此Span为根Span。
     *
     * @return 当前SpanBuilder实例，用于链式调用。
     */
    AlibabaCloudSpanBuilder asRootSpan();

    /**
     * 设置此Span为指定Span的子Span。
     *
     * @param parent 父Span的SpanContext。
     * @return 当前SpanBuilder实例，用于链式调用。
     */
    AlibabaCloudSpanBuilder asChildOf(SpanContext parent);

    @Override
    AlibabaCloudSpan startSpan();
}
