/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.credentials.provider;

import com.aliyun.credentials.AccessKeyCredential;
import com.aliyun.credentials.AlibabaCloudCredentials;
import com.aliyun.credentials.exception.CredentialException;
import com.aliyun.credentials.provider.AlibabaCloudCredentialsProvider;
import com.aliyun.credentials.provider.CredentialsProviderFactory;
import com.aliyun.credentials.provider.EcsRamRoleCredentialProvider;
import com.aliyun.credentials.provider.RamRoleArnCredentialProvider;
import com.aliyun.credentials.provider.RsaKeyPairCredentialProvider;
import com.aliyun.credentials.utils.AuthConstant;
import com.aliyun.credentials.utils.AuthUtils;
import com.aliyun.credentials.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.ini4j.Profile;
import org.ini4j.Wini;

public class ProfileCredentialsProvider
implements AlibabaCloudCredentialsProvider {
    private static volatile Wini ini;

    private static Wini getIni(String filePath) throws IOException {
        if (null == ini) {
            ini = new Wini(new File(filePath));
        }
        return ini;
    }

    @Override
    public AlibabaCloudCredentials getCredentials() throws CredentialException, IOException, ParseException {
        Wini ini;
        String filePath = AuthUtils.getEnvironmentCredentialsFile();
        if (filePath == null) {
            filePath = AuthConstant.DEFAULT_CREDENTIALS_FILE_PATH;
        }
        if (filePath.length() == 0) {
            throw new CredentialException("The specified credentials file is empty");
        }
        try {
            ini = ProfileCredentialsProvider.getIni(filePath);
        }
        catch (IOException e) {
            return null;
        }
        Map<String, Map<String, String>> client = this.loadIni(ini);
        Map<String, String> clientConfig = client.get(AuthUtils.getClientType());
        if (clientConfig == null) {
            throw new CredentialException("Client is not open in the specified credentials file");
        }
        CredentialsProviderFactory credentialsProviderFactory = new CredentialsProviderFactory();
        return this.createCredential(clientConfig, credentialsProviderFactory);
    }

    private Map<String, Map<String, String>> loadIni(Wini ini) {
        HashMap<String, Map<String, String>> client = new HashMap<String, Map<String, String>>(16);
        for (Map.Entry clientType : ini.entrySet()) {
            boolean enable = ((Profile.Section)clientType.getValue()).get((Object)"enable", Boolean.TYPE);
            if (!enable) continue;
            HashMap clientConfig = new HashMap(16);
            for (Map.Entry enabledClient : ((Profile.Section)clientType.getValue()).entrySet()) {
                clientConfig.put(enabledClient.getKey(), enabledClient.getValue());
            }
            client.put((String)clientType.getKey(), clientConfig);
        }
        return client;
    }

    private AlibabaCloudCredentials createCredential(Map<String, String> clientConfig, CredentialsProviderFactory factory) throws CredentialException, IOException, ParseException {
        String configType = clientConfig.get("type");
        if (StringUtils.isEmpty(configType)) {
            throw new CredentialException("The configured client type is empty");
        }
        if ("ram_role_arn".equals(configType)) {
            return this.getSTSAssumeRoleSessionCredentials(clientConfig, factory);
        }
        if ("rsa_key_pair".equals(configType)) {
            return this.getSTSGetSessionAccessKeyCredentials(clientConfig, factory);
        }
        if ("ecs_ram_role".equals(configType)) {
            return this.getInstanceProfileCredentials(clientConfig, factory);
        }
        String accessKeyId = clientConfig.get("access_key_id");
        String accessKeySecret = clientConfig.get("access_key_secret");
        if (StringUtils.isEmpty(accessKeyId) || StringUtils.isEmpty(accessKeySecret)) {
            return null;
        }
        return new AccessKeyCredential(accessKeyId, accessKeySecret);
    }

    private AlibabaCloudCredentials getSTSAssumeRoleSessionCredentials(Map<String, String> clientConfig, CredentialsProviderFactory factory) throws CredentialException {
        String accessKeyId = clientConfig.get("access_key_id");
        String accessKeySecret = clientConfig.get("access_key_secret");
        String roleSessionName = clientConfig.get("role_session_name");
        String roleArn = clientConfig.get("role_arn");
        String regionId = clientConfig.get("region_id");
        String policy = clientConfig.get("policy");
        if (StringUtils.isEmpty(accessKeyId) || StringUtils.isEmpty(accessKeySecret)) {
            throw new CredentialException("The configured access_key_id or access_key_secret is empty");
        }
        if (StringUtils.isEmpty(roleSessionName) || StringUtils.isEmpty(roleArn)) {
            throw new CredentialException("The configured role_session_name or role_arn is empty");
        }
        RamRoleArnCredentialProvider provider = factory.createCredentialsProvider(new RamRoleArnCredentialProvider(accessKeyId, accessKeySecret, roleSessionName, roleArn, regionId, policy));
        return provider.getCredentials();
    }

    public AlibabaCloudCredentials getSTSGetSessionAccessKeyCredentials(Map<String, String> clientConfig, CredentialsProviderFactory factory) throws CredentialException, IOException {
        String publicKeyId = clientConfig.get("public_key_id");
        String privateKeyFile = clientConfig.get("private_key_file");
        if (StringUtils.isEmpty(privateKeyFile)) {
            throw new CredentialException("The configured private_key_file is empty");
        }
        String privateKey = AuthUtils.getPrivateKey(privateKeyFile);
        if (StringUtils.isEmpty(publicKeyId) || StringUtils.isEmpty(privateKey)) {
            throw new CredentialException("The configured public_key_id or private_key_file content is empty");
        }
        RsaKeyPairCredentialProvider provider = factory.createCredentialsProvider(new RsaKeyPairCredentialProvider(publicKeyId, privateKey));
        return provider.getCredentials();
    }

    private AlibabaCloudCredentials getInstanceProfileCredentials(Map<String, String> clientConfig, CredentialsProviderFactory factory) throws CredentialException, MalformedURLException, ParseException {
        String roleName = clientConfig.get("role_name");
        if (StringUtils.isEmpty(roleName)) {
            throw new CredentialException("The configured role_name is empty");
        }
        EcsRamRoleCredentialProvider provider = factory.createCredentialsProvider(new EcsRamRoleCredentialProvider(roleName));
        return provider.getCredentials();
    }
}

