/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.imageprocess20200320.external.google.gson.internal.bind;

import com.aliyun.imageprocess20200320.external.google.gson.Gson;
import com.aliyun.imageprocess20200320.external.google.gson.JsonSyntaxException;
import com.aliyun.imageprocess20200320.external.google.gson.TypeAdapter;
import com.aliyun.imageprocess20200320.external.google.gson.TypeAdapterFactory;
import com.aliyun.imageprocess20200320.external.google.gson.reflect.TypeToken;
import com.aliyun.imageprocess20200320.external.google.gson.stream.JsonReader;
import com.aliyun.imageprocess20200320.external.google.gson.stream.JsonToken;
import com.aliyun.imageprocess20200320.external.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public final class SqlDateTypeAdapter
extends TypeAdapter<Date> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            return typeToken.getRawType() == Date.class ? new SqlDateTypeAdapter() : null;
        }
    };
    private final DateFormat format = new SimpleDateFormat("MMM d, yyyy");

    @Override
    public synchronized Date read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        try {
            long utilDate = this.format.parse(in.nextString()).getTime();
            return new Date(utilDate);
        }
        catch (ParseException e) {
            throw new JsonSyntaxException(e);
        }
    }

    @Override
    public synchronized void write(JsonWriter out, Date value) throws IOException {
        out.value(value == null ? null : this.format.format(value));
    }
}

