/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.network;

import com.alibaba.sdk.android.oss.ClientException;
import com.alibaba.sdk.android.oss.ServiceException;
import com.alibaba.sdk.android.oss.common.OSSLog;
import com.alibaba.sdk.android.oss.common.utils.CRC64;
import com.alibaba.sdk.android.oss.common.utils.DateUtil;
import com.alibaba.sdk.android.oss.common.utils.OSSUtils;
import com.alibaba.sdk.android.oss.internal.OSSRetryHandler;
import com.alibaba.sdk.android.oss.internal.OSSRetryType;
import com.alibaba.sdk.android.oss.internal.RequestMessage;
import com.alibaba.sdk.android.oss.internal.ResponseMessage;
import com.alibaba.sdk.android.oss.internal.ResponseParser;
import com.alibaba.sdk.android.oss.internal.ResponseParsers;
import com.alibaba.sdk.android.oss.model.GetObjectRequest;
import com.alibaba.sdk.android.oss.model.ListBucketsRequest;
import com.alibaba.sdk.android.oss.model.OSSResult;
import com.alibaba.sdk.android.oss.network.ExecutionContext;
import com.alibaba.sdk.android.oss.network.NetworkProgressHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.zip.CheckedInputStream;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OSSRequestTask<T extends OSSResult>
implements Callable<T> {
    private ResponseParser<T> responseParser;
    private RequestMessage message;
    private ExecutionContext context;
    private OkHttpClient client;
    private OSSRetryHandler retryHandler;
    private int currentRetryCount = 0;

    public OSSRequestTask(RequestMessage message, ResponseParser parser, ExecutionContext context, int maxRetry) {
        this.responseParser = parser;
        this.message = message;
        this.context = context;
        this.client = context.getClient();
        this.retryHandler = new OSSRetryHandler(maxRetry);
    }

    @Override
    public T call() throws Exception {
        Request request = null;
        ResponseMessage responseMessage = null;
        Exception exception = null;
        Call call = null;
        try {
            if (this.context.getApplicationContext() != null) {
                OSSLog.logInfo(OSSUtils.buildBaseLogInfo(this.context.getApplicationContext()));
            }
            OSSLog.logDebug("[call] - ");
            Object ossRequest = this.context.getRequest();
            OSSUtils.ensureRequestValid(ossRequest, this.message);
            OSSUtils.signRequest(this.message);
            if (this.context.getCancellationHandler().isCancelled()) {
                throw new InterruptedIOException("This task is cancelled!");
            }
            Request.Builder requestBuilder = new Request.Builder();
            String url = ossRequest instanceof ListBucketsRequest ? this.message.buildOSSServiceURL() : this.message.buildCanonicalURL();
            requestBuilder = requestBuilder.url(url);
            for (String key : this.message.getHeaders().keySet()) {
                requestBuilder = requestBuilder.addHeader(key, (String)this.message.getHeaders().get(key));
            }
            String contentType = (String)this.message.getHeaders().get("Content-Type");
            OSSLog.logDebug("request method = " + (Object)((Object)this.message.getMethod()));
            switch (this.message.getMethod()) {
                case POST: 
                case PUT: {
                    OSSUtils.assertTrue(contentType != null, "Content type can't be null when upload!");
                    InputStream inputStream = null;
                    String stringBody = null;
                    long length = 0L;
                    if (this.message.getUploadData() != null) {
                        inputStream = new ByteArrayInputStream(this.message.getUploadData());
                        length = this.message.getUploadData().length;
                    } else if (this.message.getUploadFilePath() != null) {
                        File file = new File(this.message.getUploadFilePath());
                        inputStream = new FileInputStream(file);
                        length = file.length();
                        if (length <= 0L) {
                            throw new ClientException("the length of file is 0!");
                        }
                    } else if (this.message.getUploadUri() != null) {
                        inputStream = this.context.getApplicationContext().getContentResolver().openInputStream(this.message.getUploadUri());
                        length = this.context.getApplicationContext().getContentResolver().openFileDescriptor(this.message.getUploadUri(), "r").getStatSize();
                    } else if (this.message.getContent() != null) {
                        inputStream = this.message.getContent();
                        length = this.message.getContentLength();
                    } else {
                        stringBody = this.message.getStringBody();
                    }
                    if (inputStream != null) {
                        if (this.message.isCheckCRC64()) {
                            inputStream = new CheckedInputStream(inputStream, new CRC64());
                        }
                        this.message.setContent(inputStream);
                        this.message.setContentLength(length);
                        requestBuilder = requestBuilder.method(this.message.getMethod().toString(), (RequestBody)NetworkProgressHelper.addProgressRequestBody(inputStream, length, contentType, this.context));
                        break;
                    }
                    if (stringBody != null) {
                        requestBuilder = requestBuilder.method(this.message.getMethod().toString(), RequestBody.create((MediaType)MediaType.parse((String)contentType), (byte[])stringBody.getBytes("UTF-8")));
                        break;
                    }
                    requestBuilder = requestBuilder.method(this.message.getMethod().toString(), RequestBody.create(null, (byte[])new byte[0]));
                    break;
                }
                case GET: {
                    requestBuilder = requestBuilder.get();
                    break;
                }
                case HEAD: {
                    requestBuilder = requestBuilder.head();
                    break;
                }
                case DELETE: {
                    requestBuilder = requestBuilder.delete();
                    break;
                }
            }
            request = requestBuilder.build();
            if (ossRequest instanceof GetObjectRequest) {
                this.client = NetworkProgressHelper.addProgressResponseListener(this.client, this.context);
                OSSLog.logDebug("getObject");
            }
            call = this.client.newCall(request);
            this.context.getCancellationHandler().setCall(call);
            Response response = call.execute();
            if (OSSLog.isEnableLog()) {
                Map headerMap = response.headers().toMultimap();
                StringBuilder printRsp = new StringBuilder();
                printRsp.append("response:---------------------\n");
                printRsp.append("response code: " + response.code() + " for url: " + request.url() + "\n");
                for (String key : headerMap.keySet()) {
                    printRsp.append("responseHeader [" + key + "]: ").append((String)((List)headerMap.get(key)).get(0) + "\n");
                }
                OSSLog.logDebug(printRsp.toString());
            }
            responseMessage = this.buildResponseMessage(this.message, response);
        }
        catch (Exception e) {
            OSSLog.logError("Encounter local execpiton: " + e.toString());
            if (OSSLog.isEnableLog()) {
                e.printStackTrace();
            }
            exception = new ClientException(e.getMessage(), e);
        }
        if (exception == null && (responseMessage.getStatusCode() == 203 || responseMessage.getStatusCode() >= 300)) {
            exception = ResponseParsers.parseResponseErrorXML(responseMessage, request.method().equals("HEAD"));
        } else if (exception == null) {
            try {
                T result = this.responseParser.parse(responseMessage);
                if (this.context.getCompletedCallback() != null) {
                    this.context.getCompletedCallback().onSuccess(this.context.getRequest(), result);
                }
                return result;
            }
            catch (IOException e) {
                exception = new ClientException(e.getMessage(), e);
            }
        }
        if (call != null && call.isCanceled() || this.context.getCancellationHandler().isCancelled()) {
            exception = new ClientException("Task is cancelled!", exception.getCause(), true);
        }
        OSSRetryType retryType = this.retryHandler.shouldRetry(exception, this.currentRetryCount);
        OSSLog.logError("[run] - retry, retry type: " + (Object)((Object)retryType));
        if (retryType == OSSRetryType.OSSRetryTypeShouldRetry) {
            ++this.currentRetryCount;
            if (this.context.getRetryCallback() != null) {
                this.context.getRetryCallback().onRetryCallback();
            }
            try {
                Thread.sleep(this.retryHandler.timeInterval(this.currentRetryCount, retryType));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                e.printStackTrace();
            }
            return (T)this.call();
        }
        if (retryType == OSSRetryType.OSSRetryTypeShouldFixedTimeSkewedAndRetry) {
            if (responseMessage != null) {
                String responseDateString = (String)responseMessage.getHeaders().get("Date");
                try {
                    long serverTime = DateUtil.parseRfc822Date(responseDateString).getTime();
                    DateUtil.setCurrentServerTime(serverTime);
                    this.message.getHeaders().put("Date", responseDateString);
                }
                catch (Exception ignore) {
                    OSSLog.logError("[error] - synchronize time, reponseDate:" + responseDateString);
                }
            }
            ++this.currentRetryCount;
            if (this.context.getRetryCallback() != null) {
                this.context.getRetryCallback().onRetryCallback();
            }
            return (T)this.call();
        }
        if (exception instanceof ClientException) {
            if (this.context.getCompletedCallback() != null) {
                this.context.getCompletedCallback().onFailure(this.context.getRequest(), (ClientException)exception, null);
            }
        } else if (this.context.getCompletedCallback() != null) {
            this.context.getCompletedCallback().onFailure(this.context.getRequest(), null, (ServiceException)exception);
        }
        throw exception;
    }

    private ResponseMessage buildResponseMessage(RequestMessage request, Response response) {
        ResponseMessage responseMessage = new ResponseMessage();
        responseMessage.setRequest(request);
        responseMessage.setResponse(response);
        HashMap<String, String> headers = new HashMap<String, String>();
        Headers responseHeaders = response.headers();
        for (int i = 0; i < responseHeaders.size(); ++i) {
            headers.put(responseHeaders.name(i), responseHeaders.value(i));
        }
        responseMessage.setHeaders(headers);
        responseMessage.setStatusCode(response.code());
        responseMessage.setContentLength(response.body().contentLength());
        responseMessage.setContent(response.body().byteStream());
        return responseMessage;
    }
}

