/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.common.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.InetAddresses;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import android.webkit.MimeTypeMap;
import com.alibaba.sdk.android.oss.common.OSSConstants;
import com.alibaba.sdk.android.oss.common.OSSLog;
import com.alibaba.sdk.android.oss.common.auth.HmacSHA1Signature;
import com.alibaba.sdk.android.oss.common.auth.OSSCredentialProvider;
import com.alibaba.sdk.android.oss.common.auth.OSSCustomSignerCredentialProvider;
import com.alibaba.sdk.android.oss.common.auth.OSSFederationCredentialProvider;
import com.alibaba.sdk.android.oss.common.auth.OSSFederationToken;
import com.alibaba.sdk.android.oss.common.auth.OSSPlainTextAKSKCredentialProvider;
import com.alibaba.sdk.android.oss.common.auth.OSSStsTokenCredentialProvider;
import com.alibaba.sdk.android.oss.common.utils.DateUtil;
import com.alibaba.sdk.android.oss.common.utils.HttpUtil;
import com.alibaba.sdk.android.oss.exception.InconsistentException;
import com.alibaba.sdk.android.oss.internal.RequestMessage;
import com.alibaba.sdk.android.oss.model.CopyObjectRequest;
import com.alibaba.sdk.android.oss.model.CreateBucketRequest;
import com.alibaba.sdk.android.oss.model.DeleteBucketLifecycleRequest;
import com.alibaba.sdk.android.oss.model.DeleteBucketLoggingRequest;
import com.alibaba.sdk.android.oss.model.DeleteBucketRequest;
import com.alibaba.sdk.android.oss.model.DeleteMultipleObjectRequest;
import com.alibaba.sdk.android.oss.model.GetBucketACLRequest;
import com.alibaba.sdk.android.oss.model.GetBucketInfoRequest;
import com.alibaba.sdk.android.oss.model.GetBucketLifecycleRequest;
import com.alibaba.sdk.android.oss.model.GetBucketLoggingRequest;
import com.alibaba.sdk.android.oss.model.GetBucketRefererRequest;
import com.alibaba.sdk.android.oss.model.ListBucketsRequest;
import com.alibaba.sdk.android.oss.model.ListMultipartUploadsRequest;
import com.alibaba.sdk.android.oss.model.ListObjectsRequest;
import com.alibaba.sdk.android.oss.model.OSSRequest;
import com.alibaba.sdk.android.oss.model.ObjectMetadata;
import com.alibaba.sdk.android.oss.model.PartETag;
import com.alibaba.sdk.android.oss.model.PutBucketLifecycleRequest;
import com.alibaba.sdk.android.oss.model.PutBucketLoggingRequest;
import com.alibaba.sdk.android.oss.model.PutBucketRefererRequest;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.json.JSONObject;

public class OSSUtils {
    private static final String NEW_LINE = "\n";
    private static final List<String> SIGNED_PARAMTERS = Arrays.asList("bucketInfo", "acl", "uploads", "location", "cors", "logging", "website", "referer", "lifecycle", "delete", "append", "uploadId", "partNumber", "security-token", "position", "response-cache-control", "response-content-disposition", "response-content-encoding", "response-content-language", "response-content-type", "response-expires", "x-oss-process", "sequential", "symlink", "restore");

    public static void populateRequestMetadata(Map<String, String> headers, ObjectMetadata metadata) {
        Map<String, String> userMetadata;
        if (metadata == null) {
            return;
        }
        Map<String, Object> rawMetadata = metadata.getRawMetadata();
        if (rawMetadata != null) {
            for (Map.Entry<String, Object> entry : rawMetadata.entrySet()) {
                headers.put(entry.getKey(), entry.getValue().toString());
            }
        }
        if ((userMetadata = metadata.getUserMetadata()) != null) {
            for (Map.Entry<String, String> entry : userMetadata.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (key != null) {
                    key = key.trim();
                }
                if (value != null) {
                    value = value.trim();
                }
                headers.put(key, value);
            }
        }
    }

    public static void populateListBucketRequestParameters(ListBucketsRequest listBucketsRequest, Map<String, String> params) {
        if (listBucketsRequest.getPrefix() != null) {
            params.put("prefix", listBucketsRequest.getPrefix());
        }
        if (listBucketsRequest.getMarker() != null) {
            params.put("marker", listBucketsRequest.getMarker());
        }
        if (listBucketsRequest.getMaxKeys() != null) {
            params.put("max-keys", Integer.toString(listBucketsRequest.getMaxKeys()));
        }
    }

    public static void populateListObjectsRequestParameters(ListObjectsRequest listObjectsRequest, Map<String, String> params) {
        if (listObjectsRequest.getPrefix() != null) {
            params.put("prefix", listObjectsRequest.getPrefix());
        }
        if (listObjectsRequest.getMarker() != null) {
            params.put("marker", listObjectsRequest.getMarker());
        }
        if (listObjectsRequest.getDelimiter() != null) {
            params.put("delimiter", listObjectsRequest.getDelimiter());
        }
        if (listObjectsRequest.getMaxKeys() != null) {
            params.put("max-keys", Integer.toString(listObjectsRequest.getMaxKeys()));
        }
        if (listObjectsRequest.getEncodingType() != null) {
            params.put("encoding-type", listObjectsRequest.getEncodingType());
        }
    }

    public static void populateListMultipartUploadsRequestParameters(ListMultipartUploadsRequest request, Map<String, String> params) {
        if (request.getDelimiter() != null) {
            params.put("delimiter", request.getDelimiter());
        }
        if (request.getMaxUploads() != null) {
            params.put("max-uploads", Integer.toString(request.getMaxUploads()));
        }
        if (request.getKeyMarker() != null) {
            params.put("key-marker", request.getKeyMarker());
        }
        if (request.getPrefix() != null) {
            params.put("prefix", request.getPrefix());
        }
        if (request.getUploadIdMarker() != null) {
            params.put("upload-id-marker", request.getUploadIdMarker());
        }
        if (request.getEncodingType() != null) {
            params.put("encoding-type", request.getEncodingType());
        }
    }

    public static boolean checkParamRange(long param, long from, boolean leftInclusive, long to, boolean rightInclusive) {
        if (leftInclusive && rightInclusive) {
            return from <= param && param <= to;
        }
        if (leftInclusive && !rightInclusive) {
            return from <= param && param < to;
        }
        if (!leftInclusive && !rightInclusive) {
            return from < param && param < to;
        }
        return from < param && param <= to;
    }

    public static void populateCopyObjectHeaders(CopyObjectRequest copyObjectRequest, Map<String, String> headers) {
        String copySourceHeader = "/" + copyObjectRequest.getSourceBucketName() + "/" + HttpUtil.urlEncode(copyObjectRequest.getSourceKey(), "utf-8");
        headers.put("x-oss-copy-source", copySourceHeader);
        OSSUtils.addDateHeader(headers, "x-oss-copy-source-if-modified-since", copyObjectRequest.getModifiedSinceConstraint());
        OSSUtils.addDateHeader(headers, "x-oss-copy-source-if-unmodified-since", copyObjectRequest.getUnmodifiedSinceConstraint());
        OSSUtils.addStringListHeader(headers, "x-oss-copy-source-if-match", copyObjectRequest.getMatchingETagConstraints());
        OSSUtils.addStringListHeader(headers, "x-oss-copy-source-if-none-match", copyObjectRequest.getNonmatchingEtagConstraints());
        OSSUtils.addHeader(headers, "x-oss-server-side-encryption", copyObjectRequest.getServerSideEncryption());
        ObjectMetadata newObjectMetadata = copyObjectRequest.getNewObjectMetadata();
        if (newObjectMetadata != null) {
            headers.put("x-oss-metadata-directive", MetadataDirective.REPLACE.toString());
            OSSUtils.populateRequestMetadata(headers, newObjectMetadata);
        }
        OSSUtils.removeHeader(headers, "Content-Length");
    }

    public static String buildXMLFromPartEtagList(List<PartETag> partETagList) {
        StringBuilder builder = new StringBuilder();
        builder.append("<CompleteMultipartUpload>\n");
        for (PartETag partETag : partETagList) {
            builder.append("<Part>\n");
            builder.append("<PartNumber>" + partETag.getPartNumber() + "</PartNumber>\n");
            builder.append("<ETag>" + partETag.getETag() + "</ETag>\n");
            builder.append("</Part>\n");
        }
        builder.append("</CompleteMultipartUpload>\n");
        return builder.toString();
    }

    public static void addHeader(Map<String, String> headers, String header, String value) {
        if (value != null) {
            headers.put(header, value);
        }
    }

    public static void addDateHeader(Map<String, String> headers, String header, Date value) {
        if (value != null) {
            headers.put(header, DateUtil.formatRfc822Date(value));
        }
    }

    public static void addStringListHeader(Map<String, String> headers, String header, List<String> values) {
        if (values != null && !values.isEmpty()) {
            headers.put(header, OSSUtils.join(values));
        }
    }

    public static void removeHeader(Map<String, String> headers, String header) {
        if (header != null && headers.containsKey(header)) {
            headers.remove(header);
        }
    }

    public static String join(List<String> strings) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String s : strings) {
            if (!first) {
                result.append(", ");
            }
            result.append(s);
            first = false;
        }
        return result.toString();
    }

    public static boolean isEmptyString(String str) {
        return TextUtils.isEmpty((CharSequence)str);
    }

    public static String buildCanonicalString(RequestMessage request) {
        StringBuilder canonicalString = new StringBuilder();
        canonicalString.append(request.getMethod().toString() + NEW_LINE);
        Map headers = request.getHeaders();
        TreeMap<String, String> headersToSign = new TreeMap<String, String>();
        if (headers != null) {
            for (Map.Entry header : headers.entrySet()) {
                String lowerKey;
                if (header.getKey() == null || !(lowerKey = ((String)header.getKey()).toLowerCase()).equals("Content-Type".toLowerCase()) && !lowerKey.equals("Content-MD5".toLowerCase()) && !lowerKey.equals("Date".toLowerCase()) && !lowerKey.startsWith("x-oss-")) continue;
                headersToSign.put(lowerKey, ((String)header.getValue()).trim());
            }
        }
        if (!headersToSign.containsKey("Content-Type".toLowerCase())) {
            headersToSign.put("Content-Type".toLowerCase(), "");
        }
        if (!headersToSign.containsKey("Content-MD5".toLowerCase())) {
            headersToSign.put("Content-MD5".toLowerCase(), "");
        }
        for (Map.Entry entry : headersToSign.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (key.startsWith("x-oss-")) {
                canonicalString.append(key).append(':').append(value);
            } else {
                canonicalString.append(value);
            }
            canonicalString.append(NEW_LINE);
        }
        canonicalString.append(OSSUtils.buildCanonicalizedResource(request.getBucketName(), request.getObjectKey(), request.getParameters()));
        return canonicalString.toString();
    }

    public static String buildCanonicalizedResource(String bucketName, String objectKey, Map<String, String> parameters) {
        String resourcePath = bucketName == null && objectKey == null ? "/" : (objectKey == null ? "/" + bucketName + "/" : "/" + bucketName + "/" + objectKey);
        return OSSUtils.buildCanonicalizedResource(resourcePath, parameters);
    }

    public static String buildCanonicalizedResource(String resourcePath, Map<String, String> parameters) {
        StringBuilder builder = new StringBuilder();
        builder.append(resourcePath);
        if (parameters != null) {
            Object[] parameterNames = parameters.keySet().toArray(new String[parameters.size()]);
            Arrays.sort(parameterNames);
            int separater = 63;
            for (Object paramName : parameterNames) {
                if (!SIGNED_PARAMTERS.contains(paramName)) continue;
                builder.append((char)separater);
                builder.append((String)paramName);
                String paramValue = parameters.get(paramName);
                if (!OSSUtils.isEmptyString(paramValue)) {
                    builder.append("=").append(paramValue);
                }
                separater = 38;
            }
        }
        return builder.toString();
    }

    public static String paramToQueryString(Map<String, String> params, String charset) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder paramString = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> p : params.entrySet()) {
            String key = p.getKey();
            String value = p.getValue();
            if (!first) {
                paramString.append("&");
            }
            paramString.append(HttpUtil.urlEncode(key, charset));
            if (!OSSUtils.isEmptyString(value)) {
                paramString.append("=").append(HttpUtil.urlEncode(value, charset));
            }
            first = false;
        }
        return paramString.toString();
    }

    public static String populateMapToBase64JsonString(Map<String, String> map) {
        JSONObject jsonObj = new JSONObject(map);
        return Base64.encodeToString((byte[])jsonObj.toString().getBytes(), (int)2);
    }

    public static String sign(String accessKey, String screctKey, String content) {
        String signature;
        try {
            signature = new HmacSHA1Signature().computeSignature(screctKey, content);
            signature = signature.trim();
        }
        catch (Exception e) {
            throw new IllegalStateException("Compute signature failed!", e);
        }
        return "OSS " + accessKey + ":" + signature;
    }

    public static boolean isOssOriginHost(String host) {
        if (TextUtils.isEmpty((CharSequence)host)) {
            return false;
        }
        for (String suffix : OSSConstants.OSS_ORIGN_HOST) {
            if (!host.toLowerCase().endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCname(String host) {
        for (String suffix : OSSConstants.DEFAULT_CNAME_EXCLUDE_LIST) {
            if (!host.toLowerCase().endsWith(suffix)) continue;
            return false;
        }
        return true;
    }

    public static boolean isInCustomCnameExcludeList(String endpoint, List<String> customCnameExludeList) {
        for (String host : customCnameExludeList) {
            if (!endpoint.endsWith(host.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static void assertTrue(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public static boolean validateBucketName(String bucketName) {
        if (bucketName == null) {
            return false;
        }
        String BUCKETNAME_REGX = "^[a-z0-9][a-z0-9\\-]{1,61}[a-z0-9]$";
        return bucketName.matches("^[a-z0-9][a-z0-9\\-]{1,61}[a-z0-9]$");
    }

    public static void ensureBucketNameValid(String bucketName) {
        if (!OSSUtils.validateBucketName(bucketName)) {
            throw new IllegalArgumentException("The bucket name is invalid. \nA bucket name must: \n1) be comprised of lower-case characters, numbers or dash(-); \n2) start with lower case or numbers; \n3) be between 3-63 characters long. ");
        }
    }

    public static boolean validateObjectKey(String objectKey) {
        if (objectKey == null) {
            return false;
        }
        if (objectKey.length() <= 0 || objectKey.length() > 1023) {
            return false;
        }
        try {
            byte[] keyBytes = objectKey.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
        char[] keyChars = objectKey.toCharArray();
        char beginKeyChar = keyChars[0];
        if (beginKeyChar == '/' || beginKeyChar == '\\') {
            return false;
        }
        for (char keyChar : keyChars) {
            if (keyChar == '\t' || keyChar >= ' ') continue;
            return false;
        }
        return true;
    }

    public static void ensureObjectKeyValid(String objectKey) {
        if (!OSSUtils.validateObjectKey(objectKey)) {
            throw new IllegalArgumentException("The object key is invalid. \nAn object name should be: \n1) between 1 - 1023 bytes long when encoded as UTF-8 \n2) cannot contain LF or CR or unsupported chars in XML1.0, \n3) cannot begin with \"/\" or \"\\\".");
        }
    }

    public static boolean doesRequestNeedObjectKey(OSSRequest request) {
        return !(request instanceof ListObjectsRequest) && !(request instanceof ListBucketsRequest) && !(request instanceof CreateBucketRequest) && !(request instanceof DeleteBucketRequest) && !(request instanceof GetBucketInfoRequest) && !(request instanceof GetBucketACLRequest) && !(request instanceof DeleteMultipleObjectRequest) && !(request instanceof ListMultipartUploadsRequest) && !(request instanceof GetBucketRefererRequest) && !(request instanceof PutBucketRefererRequest) && !(request instanceof PutBucketLoggingRequest) && !(request instanceof GetBucketLoggingRequest) && !(request instanceof PutBucketLoggingRequest) && !(request instanceof GetBucketLoggingRequest) && !(request instanceof DeleteBucketLoggingRequest) && !(request instanceof PutBucketLifecycleRequest) && !(request instanceof GetBucketLifecycleRequest) && !(request instanceof DeleteBucketLifecycleRequest);
    }

    public static boolean doesBucketNameValid(OSSRequest request) {
        return !(request instanceof ListBucketsRequest);
    }

    public static void ensureRequestValid(OSSRequest request, RequestMessage message) {
        if (OSSUtils.doesBucketNameValid(request)) {
            OSSUtils.ensureBucketNameValid(message.getBucketName());
        }
        if (OSSUtils.doesRequestNeedObjectKey(request)) {
            OSSUtils.ensureObjectKeyValid(message.getObjectKey());
        }
        if (request instanceof CopyObjectRequest) {
            OSSUtils.ensureObjectKeyValid(((CopyObjectRequest)request).getDestinationKey());
        }
    }

    public static String determineContentType(String initValue, String srcPath, String toObjectKey) {
        String extension;
        String contentType;
        if (initValue != null) {
            return initValue;
        }
        MimeTypeMap typeMap = MimeTypeMap.getSingleton();
        if (srcPath != null && (contentType = typeMap.getMimeTypeFromExtension(extension = srcPath.substring(srcPath.lastIndexOf(46) + 1))) != null) {
            return contentType;
        }
        if (toObjectKey != null && (contentType = typeMap.getMimeTypeFromExtension(extension = toObjectKey.substring(toObjectKey.lastIndexOf(46) + 1))) != null) {
            return contentType;
        }
        return "application/octet-stream";
    }

    public static void signRequest(RequestMessage message) throws Exception {
        OSSLog.logDebug("signRequest start");
        if (!message.isAuthorizationRequired()) {
            return;
        }
        if (message.getCredentialProvider() == null) {
            throw new IllegalStateException("\u5f53\u524dCredentialProvider\u4e3a\u7a7a\uff01\uff01\uff01\n1. \u8bf7\u68c0\u67e5\u60a8\u662f\u5426\u5728\u521d\u59cb\u5316OSSService\u65f6\u8bbe\u7f6eCredentialProvider;\n2. \u5982\u679c\u60a8bucket\u4e3a\u516c\u5171\u6743\u9650\uff0c\u8bf7\u786e\u8ba4\u83b7\u53d6\u5230Bucket\u540e\u5df2\u7ecf\u8c03\u7528Bucket\u4e2d\u63a5\u53e3\u58f0\u660eACL;");
        }
        OSSCredentialProvider credentialProvider = message.getCredentialProvider();
        OSSFederationToken federationToken = null;
        if (credentialProvider instanceof OSSFederationCredentialProvider) {
            federationToken = ((OSSFederationCredentialProvider)credentialProvider).getValidFederationToken();
            if (federationToken == null) {
                OSSLog.logError("Can't get a federation token");
                throw new IOException("Can't get a federation token");
            }
            message.getHeaders().put("x-oss-security-token", federationToken.getSecurityToken());
        } else if (credentialProvider instanceof OSSStsTokenCredentialProvider) {
            federationToken = credentialProvider.getFederationToken();
            message.getHeaders().put("x-oss-security-token", federationToken.getSecurityToken());
        }
        String contentToSign = OSSUtils.buildCanonicalString(message);
        String signature = "---initValue---";
        OSSLog.logDebug("get contentToSign");
        if (credentialProvider instanceof OSSFederationCredentialProvider || credentialProvider instanceof OSSStsTokenCredentialProvider) {
            signature = OSSUtils.sign(federationToken.getTempAK(), federationToken.getTempSK(), contentToSign);
        } else if (credentialProvider instanceof OSSPlainTextAKSKCredentialProvider) {
            signature = OSSUtils.sign(((OSSPlainTextAKSKCredentialProvider)credentialProvider).getAccessKeyId(), ((OSSPlainTextAKSKCredentialProvider)credentialProvider).getAccessKeySecret(), contentToSign);
        } else if (credentialProvider instanceof OSSCustomSignerCredentialProvider) {
            signature = ((OSSCustomSignerCredentialProvider)credentialProvider).signContent(contentToSign);
        }
        OSSLog.logDebug("signed content: " + contentToSign + "   \n ---------   signature: " + signature, false);
        OSSLog.logDebug("get signature");
        message.getHeaders().put("Authorization", signature);
    }

    public static String buildBaseLogInfo(Context context) {
        StringBuilder sb = new StringBuilder();
        sb.append("=====[device info]=====\n");
        sb.append("[INFO]: android_version\uff1a" + Build.VERSION.RELEASE + NEW_LINE);
        sb.append("[INFO]: mobile_model\uff1a" + Build.MODEL + NEW_LINE);
        String operatorName = OSSUtils.getOperatorName(context);
        if (!TextUtils.isEmpty((CharSequence)operatorName)) {
            sb.append("[INFO]: operator_name\uff1a" + operatorName + NEW_LINE);
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        String networkState = "unconnected";
        String netType = "unknown";
        if (activeNetworkInfo != null && activeNetworkInfo.getState() == NetworkInfo.State.CONNECTED) {
            netType = activeNetworkInfo.getTypeName() + " ";
            networkState = "connected";
        }
        sb.append("[INFO]: network_state\uff1a" + networkState + NEW_LINE);
        sb.append("[INFO]: network_type\uff1a" + netType);
        return sb.toString();
    }

    private static String getOperatorName(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        String operator = telephonyManager.getSimOperator();
        String operatorName = "";
        if (operator != null) {
            operatorName = operator.equals("46000") || operator.equals("46002") ? "CMCC" : (operator.equals("46001") ? "CUCC" : (operator.equals("46003") ? "CTCC" : operator));
        }
        return operatorName;
    }

    public static void checkChecksum(Long clientChecksum, Long serverChecksum, String requestId) throws InconsistentException {
        if (clientChecksum != null && serverChecksum != null && !clientChecksum.equals(serverChecksum)) {
            throw new InconsistentException(clientChecksum, serverChecksum, requestId);
        }
    }

    public static boolean isValidateIP(String host) throws Exception {
        if (host == null) {
            throw new Exception("host is null");
        }
        if (Build.VERSION.SDK_INT >= 29) {
            return InetAddresses.isNumericAddress((String)host);
        }
        try {
            Class<?> aClass = Class.forName("java.net.InetAddress");
            Method isNumeric = aClass.getMethod("isNumeric", String.class);
            Boolean isIp = (Boolean)isNumeric.invoke(null, host);
            return isIp;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
    }

    public static String buildTriggerCallbackBody(Map<String, String> callbackParams, Map<String, String> callbackVars) {
        JSONObject jsonObj;
        StringBuilder builder = new StringBuilder();
        builder.append("x-oss-process=trigger/callback,callback_");
        if (callbackParams != null && callbackParams.size() > 0) {
            jsonObj = new JSONObject(callbackParams);
            String paramsJsonString = Base64.encodeToString((byte[])jsonObj.toString().getBytes(), (int)2);
            builder.append(paramsJsonString);
        }
        builder.append(",callback-var_");
        if (callbackVars != null && callbackVars.size() > 0) {
            jsonObj = new JSONObject(callbackVars);
            String varsJsonString = Base64.encodeToString((byte[])jsonObj.toString().getBytes(), (int)2);
            builder.append(varsJsonString);
        }
        return builder.toString();
    }

    public static String buildImagePersistentBody(String toBucketName, String toObjectKey, String action) {
        StringBuilder builder = new StringBuilder();
        builder.append("x-oss-process=");
        if (action.startsWith("image/")) {
            builder.append(action);
        } else {
            builder.append("image/");
            builder.append(action);
        }
        builder.append("|sys/");
        if (!TextUtils.isEmpty((CharSequence)toBucketName) && !TextUtils.isEmpty((CharSequence)toObjectKey)) {
            String bucketName_base64 = Base64.encodeToString((byte[])toBucketName.getBytes(), (int)2);
            String objectkey_base64 = Base64.encodeToString((byte[])toObjectKey.getBytes(), (int)2);
            builder.append("saveas,o_");
            builder.append(objectkey_base64);
            builder.append(",b_");
            builder.append(bucketName_base64);
        }
        String body = builder.toString();
        OSSLog.logDebug("ImagePersistent body : " + body);
        return body;
    }

    private static enum MetadataDirective {
        COPY("COPY"),
        REPLACE("REPLACE");

        private final String directiveAsString;

        private MetadataDirective(String directiveAsString) {
            this.directiveAsString = directiveAsString;
        }

        public String toString() {
            return this.directiveAsString;
        }
    }
}

