/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.internal;

import com.alibaba.sdk.android.oss.ClientException;
import com.alibaba.sdk.android.oss.ServiceException;
import com.alibaba.sdk.android.oss.TaskCancelException;
import com.alibaba.sdk.android.oss.callback.OSSCompletedCallback;
import com.alibaba.sdk.android.oss.callback.OSSProgressCallback;
import com.alibaba.sdk.android.oss.common.OSSLog;
import com.alibaba.sdk.android.oss.common.utils.BinaryUtil;
import com.alibaba.sdk.android.oss.internal.InternalRequestOperation;
import com.alibaba.sdk.android.oss.model.CompleteMultipartUploadRequest;
import com.alibaba.sdk.android.oss.model.CompleteMultipartUploadResult;
import com.alibaba.sdk.android.oss.model.MultipartUploadRequest;
import com.alibaba.sdk.android.oss.model.OSSRequest;
import com.alibaba.sdk.android.oss.model.PartETag;
import com.alibaba.sdk.android.oss.model.UploadPartRequest;
import com.alibaba.sdk.android.oss.model.UploadPartResult;
import com.alibaba.sdk.android.oss.network.ExecutionContext;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class BaseMultipartUploadTask<Request extends MultipartUploadRequest, Result extends CompleteMultipartUploadResult>
implements Callable<Result> {
    protected final int CPU_SIZE = Runtime.getRuntime().availableProcessors() * 2;
    protected final int MAX_CORE_POOL_SIZE = this.CPU_SIZE < 5 ? this.CPU_SIZE : 5;
    protected final int MAX_IMUM_POOL_SIZE = this.CPU_SIZE;
    protected final int KEEP_ALIVE_TIME = 3000;
    protected final int MAX_QUEUE_SIZE = 5000;
    protected ThreadPoolExecutor mPoolExecutor = new ThreadPoolExecutor(this.MAX_CORE_POOL_SIZE, this.MAX_IMUM_POOL_SIZE, 3000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(5000), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, "oss-android-multipart-thread");
        }
    });
    protected List<PartETag> mPartETags = new ArrayList<PartETag>();
    protected Object mLock = new Object();
    protected InternalRequestOperation mApiOperation;
    protected ExecutionContext mContext;
    protected Exception mUploadException;
    protected boolean mIsCancel;
    protected File mUploadFile;
    protected String mUploadId;
    protected long mFileLength;
    protected int mPartExceptionCount;
    protected int mRunPartTaskCount;
    protected long mUploadedLength = 0L;
    protected boolean mCheckCRC64 = false;
    protected Request mRequest;
    protected OSSCompletedCallback<Request, Result> mCompletedCallback;
    protected OSSProgressCallback<Request> mProgressCallback;
    protected int[] mPartAttr = new int[2];
    protected String mUploadFilePath;
    protected long mLastPartSize;

    public BaseMultipartUploadTask(InternalRequestOperation operation, Request request, OSSCompletedCallback<Request, Result> completedCallback, ExecutionContext context) {
        this.mApiOperation = operation;
        this.mRequest = request;
        this.mProgressCallback = ((MultipartUploadRequest)request).getProgressCallback();
        this.mCompletedCallback = completedCallback;
        this.mContext = context;
        this.mCheckCRC64 = ((OSSRequest)request).getCRC64() == OSSRequest.CRC64Config.YES;
    }

    protected abstract void abortThisUpload();

    protected abstract void initMultipartUploadId() throws IOException, ClientException, ServiceException;

    protected abstract Result doMultipartUpload() throws IOException, ServiceException, ClientException, InterruptedException;

    protected void checkCancel() throws ClientException {
        if (this.mContext.getCancellationHandler().isCancelled()) {
            TaskCancelException e = new TaskCancelException("multipart cancel");
            throw new ClientException(e.getMessage(), e, true);
        }
    }

    protected void preUploadPart(int readIndex, int byteCount, int partNumber) throws Exception {
    }

    protected void uploadPartFinish(PartETag partETag) throws Exception {
    }

    @Override
    public Result call() throws Exception {
        try {
            this.checkInitData();
            this.initMultipartUploadId();
            Result result = this.doMultipartUpload();
            if (this.mCompletedCallback != null) {
                this.mCompletedCallback.onSuccess(this.mRequest, result);
            }
            return result;
        }
        catch (ServiceException e) {
            if (this.mCompletedCallback != null) {
                this.mCompletedCallback.onFailure(this.mRequest, null, e);
            }
            throw e;
        }
        catch (Exception e) {
            ClientException temp = e instanceof ClientException ? (ClientException)e : new ClientException(e.toString(), e);
            if (this.mCompletedCallback != null) {
                this.mCompletedCallback.onFailure(this.mRequest, temp, null);
            }
            throw temp;
        }
    }

    protected void checkInitData() throws ClientException {
        this.mUploadFilePath = ((MultipartUploadRequest)this.mRequest).getUploadFilePath();
        this.mUploadedLength = 0L;
        this.mUploadFile = new File(this.mUploadFilePath);
        this.mFileLength = this.mUploadFile.length();
        if (this.mFileLength == 0L) {
            throw new ClientException("file length must not be 0");
        }
        this.checkPartSize(this.mPartAttr);
        long partSize = ((MultipartUploadRequest)this.mRequest).getPartSize();
        int partNumber = this.mPartAttr[1];
        OSSLog.logDebug("[checkInitData] - partNumber : " + partNumber);
        OSSLog.logDebug("[checkInitData] - partSize : " + partSize);
        if (partNumber > 1 && partSize < 102400L) {
            throw new ClientException("Part size must be greater than or equal to 100KB!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uploadPart(int readIndex, int byteCount, int partNumber) {
        RandomAccessFile raf = null;
        try {
            if (this.mContext.getCancellationHandler().isCancelled()) {
                this.mPoolExecutor.getQueue().clear();
                return;
            }
            Object e = this.mLock;
            synchronized (e) {
                ++this.mRunPartTaskCount;
            }
            this.preUploadPart(readIndex, byteCount, partNumber);
            raf = new RandomAccessFile(this.mUploadFile, "r");
            UploadPartRequest uploadPart = new UploadPartRequest(((MultipartUploadRequest)this.mRequest).getBucketName(), ((MultipartUploadRequest)this.mRequest).getObjectKey(), this.mUploadId, readIndex + 1);
            long skip = (long)readIndex * ((MultipartUploadRequest)this.mRequest).getPartSize();
            byte[] partContent = new byte[byteCount];
            raf.seek(skip);
            raf.readFully(partContent, 0, byteCount);
            uploadPart.setPartContent(partContent);
            uploadPart.setMd5Digest(BinaryUtil.calculateBase64Md5(partContent));
            uploadPart.setCRC64(((OSSRequest)this.mRequest).getCRC64());
            UploadPartResult uploadPartResult = this.mApiOperation.syncUploadPart(uploadPart);
            Object object = this.mLock;
            synchronized (object) {
                PartETag partETag = new PartETag(uploadPart.getPartNumber(), uploadPartResult.getETag());
                partETag.setPartSize(byteCount);
                if (this.mCheckCRC64) {
                    partETag.setCRC64(uploadPartResult.getClientCRC());
                }
                this.mPartETags.add(partETag);
                this.mUploadedLength += (long)byteCount;
                this.uploadPartFinish(partETag);
                if (this.mContext.getCancellationHandler().isCancelled()) {
                    if (this.mPartETags.size() == this.mRunPartTaskCount - this.mPartExceptionCount) {
                        TaskCancelException e2 = new TaskCancelException("multipart cancel");
                        throw new ClientException(e2.getMessage(), e2, true);
                    }
                } else {
                    if (this.mPartETags.size() == partNumber - this.mPartExceptionCount) {
                        this.notifyMultipartThread();
                    }
                    this.onProgressCallback(this.mRequest, this.mUploadedLength, this.mFileLength);
                }
            }
        }
        catch (Exception e) {
            this.processException(e);
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (IOException e) {
                OSSLog.logThrowable2Local(e);
            }
        }
    }

    protected abstract void processException(Exception var1);

    protected CompleteMultipartUploadResult completeMultipartUploadResult() throws ClientException, ServiceException {
        CompleteMultipartUploadResult completeResult = null;
        if (this.mPartETags.size() > 0) {
            Collections.sort(this.mPartETags, new Comparator<PartETag>(){

                @Override
                public int compare(PartETag lhs, PartETag rhs) {
                    if (lhs.getPartNumber() < rhs.getPartNumber()) {
                        return -1;
                    }
                    if (lhs.getPartNumber() > rhs.getPartNumber()) {
                        return 1;
                    }
                    return 0;
                }
            });
            CompleteMultipartUploadRequest complete = new CompleteMultipartUploadRequest(((MultipartUploadRequest)this.mRequest).getBucketName(), ((MultipartUploadRequest)this.mRequest).getObjectKey(), this.mUploadId, this.mPartETags);
            complete.setMetadata(((MultipartUploadRequest)this.mRequest).getMetadata());
            if (((MultipartUploadRequest)this.mRequest).getCallbackParam() != null) {
                complete.setCallbackParam(((MultipartUploadRequest)this.mRequest).getCallbackParam());
            }
            if (((MultipartUploadRequest)this.mRequest).getCallbackVars() != null) {
                complete.setCallbackVars(((MultipartUploadRequest)this.mRequest).getCallbackVars());
            }
            complete.setCRC64(((OSSRequest)this.mRequest).getCRC64());
            completeResult = this.mApiOperation.syncCompleteMultipartUpload(complete);
        }
        this.mUploadedLength = 0L;
        return completeResult;
    }

    protected void releasePool() {
        if (this.mPoolExecutor != null) {
            this.mPoolExecutor.getQueue().clear();
            this.mPoolExecutor.shutdown();
        }
    }

    protected void checkException() throws IOException, ServiceException, ClientException {
        if (this.mUploadException != null) {
            this.releasePool();
            if (this.mUploadException instanceof IOException) {
                throw (IOException)this.mUploadException;
            }
            if (this.mUploadException instanceof ServiceException) {
                throw (ServiceException)this.mUploadException;
            }
            if (this.mUploadException instanceof ClientException) {
                throw (ClientException)this.mUploadException;
            }
            ClientException clientException = new ClientException(this.mUploadException.getMessage(), this.mUploadException);
            throw clientException;
        }
    }

    protected boolean checkWaitCondition(int partNum) {
        return this.mPartETags.size() != partNum;
    }

    protected void notifyMultipartThread() {
        this.mLock.notify();
        this.mPartExceptionCount = 0;
    }

    protected void checkPartSize(int[] partAttr) {
        long partSize = ((MultipartUploadRequest)this.mRequest).getPartSize();
        OSSLog.logDebug("[checkPartSize] - mFileLength : " + this.mFileLength);
        OSSLog.logDebug("[checkPartSize] - partSize : " + partSize);
        int partNumber = (int)(this.mFileLength / partSize);
        if (this.mFileLength % partSize != 0L) {
            ++partNumber;
        }
        int MAX_PART_NUM = 5000;
        if (partNumber == 1) {
            partSize = this.mFileLength;
        } else if (partNumber > MAX_PART_NUM) {
            partSize = this.mFileLength / (long)MAX_PART_NUM;
            partNumber = MAX_PART_NUM;
        }
        partAttr[0] = (int)partSize;
        partAttr[1] = partNumber;
        ((MultipartUploadRequest)this.mRequest).setPartSize((int)partSize);
        OSSLog.logDebug("[checkPartSize] - partNumber : " + partNumber);
        OSSLog.logDebug("[checkPartSize] - partSize : " + (int)partSize);
        long lastPartSize = this.mFileLength % partSize;
        this.mLastPartSize = lastPartSize == 0L ? partSize : lastPartSize;
    }

    protected void onProgressCallback(Request request, long currentSize, long totalSize) {
        if (this.mProgressCallback != null) {
            this.mProgressCallback.onProgress(request, currentSize, totalSize);
        }
    }
}

