/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.internal;

import android.util.Log;
import com.alibaba.sdk.android.oss.ClientException;
import com.alibaba.sdk.android.oss.ServiceException;
import com.alibaba.sdk.android.oss.TaskCancelException;
import com.alibaba.sdk.android.oss.callback.OSSCompletedCallback;
import com.alibaba.sdk.android.oss.callback.OSSProgressCallback;
import com.alibaba.sdk.android.oss.common.OSSLog;
import com.alibaba.sdk.android.oss.common.utils.BinaryUtil;
import com.alibaba.sdk.android.oss.common.utils.CRC64;
import com.alibaba.sdk.android.oss.common.utils.OSSUtils;
import com.alibaba.sdk.android.oss.exception.InconsistentException;
import com.alibaba.sdk.android.oss.internal.InternalRequestOperation;
import com.alibaba.sdk.android.oss.model.GetObjectMetaRequest;
import com.alibaba.sdk.android.oss.model.GetObjectMetaResult;
import com.alibaba.sdk.android.oss.model.GetObjectRequest;
import com.alibaba.sdk.android.oss.model.GetObjectResult;
import com.alibaba.sdk.android.oss.model.OSSRequest;
import com.alibaba.sdk.android.oss.model.OSSResult;
import com.alibaba.sdk.android.oss.model.ObjectMetadata;
import com.alibaba.sdk.android.oss.model.Range;
import com.alibaba.sdk.android.oss.model.ResumableDownloadRequest;
import com.alibaba.sdk.android.oss.model.ResumableDownloadResult;
import com.alibaba.sdk.android.oss.network.ExecutionContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.zip.CheckedInputStream;

public class ResumableDownloadTask<Requst extends ResumableDownloadRequest, Result extends ResumableDownloadResult>
implements Callable<Result> {
    protected final int CPU_SIZE = Runtime.getRuntime().availableProcessors() * 2;
    protected final int MAX_CORE_POOL_SIZE = this.CPU_SIZE < 5 ? this.CPU_SIZE : 5;
    protected final int MAX_IMUM_POOL_SIZE = this.CPU_SIZE;
    protected final int KEEP_ALIVE_TIME = 3000;
    protected final int PART_SIZE_ALIGN_NUM = 4096;
    protected final int MAX_QUEUE_SIZE = 5000;
    protected static final String TEMP_SUFFIX = ".temp";
    protected ThreadPoolExecutor mPoolExecutor;
    private ResumableDownloadRequest mRequest;
    private InternalRequestOperation mOperation;
    private OSSCompletedCallback mCompletedCallback;
    private ExecutionContext mContext;
    private OSSProgressCallback mProgressCallback;
    private CheckPoint mCheckPoint;
    protected Object mLock = new Object();
    protected Exception mDownloadException;
    protected long completedPartSize;
    protected long downloadPartSize;
    protected long mPartExceptionCount;
    protected String checkpointPath;

    ResumableDownloadTask(InternalRequestOperation operation, ResumableDownloadRequest request, OSSCompletedCallback completedCallback, ExecutionContext context) {
        this.mRequest = request;
        this.mOperation = operation;
        this.mCompletedCallback = completedCallback;
        this.mContext = context;
        this.mProgressCallback = request.getProgressListener();
        int maxCorePoolSize = this.MAX_CORE_POOL_SIZE;
        int maximunPoolSize = this.MAX_IMUM_POOL_SIZE;
        if (request.getThreadNum() != null && request.getThreadNum() > 0) {
            maxCorePoolSize = request.getThreadNum();
            maximunPoolSize = request.getThreadNum();
        }
        this.mPoolExecutor = new ThreadPoolExecutor(maxCorePoolSize, maximunPoolSize, 3000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(5000), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "oss-android-multipart-thread");
            }
        });
    }

    @Override
    public Result call() throws Exception {
        try {
            this.checkInitData();
            ResumableDownloadResult result = this.doMultipartDownload();
            if (this.mCompletedCallback != null) {
                this.mCompletedCallback.onSuccess(this.mRequest, result);
            }
            return (Result)result;
        }
        catch (ServiceException e) {
            if (this.mCompletedCallback != null) {
                this.mCompletedCallback.onFailure(this.mRequest, null, e);
            }
            throw e;
        }
        catch (Exception e) {
            ClientException temp = e instanceof ClientException ? (ClientException)e : new ClientException(e.toString(), e);
            if (this.mCompletedCallback != null) {
                this.mCompletedCallback.onFailure(this.mRequest, temp, null);
            }
            throw temp;
        }
    }

    protected void checkInitData() throws ClientException, ServiceException, IOException {
        if (this.mRequest.getRange() != null && !this.mRequest.getRange().checkIsValid()) {
            throw new ClientException("Range is invalid");
        }
        String recordFileName = BinaryUtil.calculateMd5Str((this.mRequest.getBucketName() + this.mRequest.getObjectKey() + String.valueOf(this.mRequest.getPartSize()) + (this.mRequest.getCRC64() == OSSRequest.CRC64Config.YES ? "-crc64" : "")).getBytes());
        this.checkpointPath = this.mRequest.getCheckPointFilePath() + File.separator + recordFileName;
        String checkpointPathTemp = this.checkpointPath + TEMP_SUFFIX;
        this.mCheckPoint = new CheckPoint();
        if (this.mRequest.getEnableCheckPoint().booleanValue()) {
            try {
                this.mCheckPoint.load(this.checkpointPath);
            }
            catch (Exception e) {
                this.removeFile(this.checkpointPath);
                this.removeFile(checkpointPathTemp);
                this.removeFile(this.mRequest.getTempFilePath());
            }
            if (!this.mCheckPoint.isValid(this.mOperation)) {
                this.removeFile(this.checkpointPath);
                this.removeFile(checkpointPathTemp);
                this.removeFile(this.mRequest.getTempFilePath());
                this.initCheckPoint();
            }
        } else {
            this.initCheckPoint();
        }
    }

    protected boolean removeFile(String filePath) {
        boolean flag = false;
        File file = new File(filePath);
        if (file.isFile() && file.exists()) {
            flag = file.delete();
        }
        return flag;
    }

    private void initCheckPoint() throws ClientException, ServiceException, IOException {
        FileStat fileStat = FileStat.getFileStat(this.mOperation, this.mRequest.getBucketName(), this.mRequest.getObjectKey());
        Range range = this.correctRange(this.mRequest.getRange(), fileStat.fileLength);
        long downloadSize = range.getEnd() - range.getBegin();
        this.createFile(this.mRequest.getTempFilePath(), downloadSize);
        this.mCheckPoint.bucketName = this.mRequest.getBucketName();
        this.mCheckPoint.objectKey = this.mRequest.getObjectKey();
        this.mCheckPoint.fileStat = fileStat;
        this.mCheckPoint.parts = this.splitFile(range, this.mCheckPoint.fileStat.fileLength, this.mRequest.getPartSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResumableDownloadResult doMultipartDownload() throws ClientException, ServiceException, IOException, InterruptedException {
        String checkpointPathTemp = this.checkpointPath + TEMP_SUFFIX;
        this.checkCancel();
        ResumableDownloadResult resumableDownloadResult = new ResumableDownloadResult();
        final DownloadFileResult result = new DownloadFileResult();
        result.partResults = new ArrayList();
        for (final DownloadPart part : this.mCheckPoint.parts) {
            this.checkException();
            if (this.mPoolExecutor != null && !part.isCompleted) {
                this.mPoolExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        ResumableDownloadTask.this.downloadPart(result, part);
                        Log.i((String)"partResults", (String)("start: " + part.start + ", end: " + part.end));
                    }
                });
                continue;
            }
            DownloadPartResult partResult = new DownloadPartResult();
            partResult.partNumber = part.partNumber;
            partResult.requestId = this.mCheckPoint.fileStat.requestId;
            partResult.length = part.length;
            if (this.mRequest.getCRC64() == OSSRequest.CRC64Config.YES) {
                partResult.clientCRC = part.crc;
            }
            result.partResults.add(partResult);
            ++this.downloadPartSize;
            ++this.completedPartSize;
        }
        if (this.checkWaitCondition(this.mCheckPoint.parts.size())) {
            Object object = this.mLock;
            synchronized (object) {
                this.mLock.wait();
            }
        }
        this.checkException();
        Collections.sort(result.partResults, new Comparator<DownloadPartResult>(){

            @Override
            public int compare(DownloadPartResult downloadPartResult, DownloadPartResult t1) {
                return downloadPartResult.partNumber - t1.partNumber;
            }
        });
        if (this.mRequest.getCRC64() == OSSRequest.CRC64Config.YES && this.mRequest.getRange() == null) {
            Long clientCRC = ResumableDownloadTask.calcObjectCRCFromParts(result.partResults);
            resumableDownloadResult.setClientCRC(clientCRC);
            try {
                OSSUtils.checkChecksum(clientCRC, this.mCheckPoint.fileStat.serverCRC, result.partResults.get((int)0).requestId);
            }
            catch (InconsistentException e) {
                this.removeFile(this.checkpointPath);
                this.removeFile(checkpointPathTemp);
                this.removeFile(this.mRequest.getTempFilePath());
                throw e;
            }
        }
        this.removeFile(this.checkpointPath);
        this.removeFile(checkpointPathTemp);
        File fromFile = new File(this.mRequest.getTempFilePath());
        File toFile = new File(this.mRequest.getDownloadToFilePath());
        this.moveFile(fromFile, toFile);
        resumableDownloadResult.setServerCRC(this.mCheckPoint.fileStat.serverCRC);
        resumableDownloadResult.setMetadata(result.metadata);
        resumableDownloadResult.setRequestId(result.partResults.get((int)0).requestId);
        resumableDownloadResult.setStatusCode(200);
        return resumableDownloadResult;
    }

    private static Long calcObjectCRCFromParts(List<DownloadPartResult> partResults) {
        long crc = 0L;
        for (DownloadPartResult partResult : partResults) {
            if (partResult.clientCRC == null || partResult.length <= 0L) {
                return null;
            }
            crc = CRC64.combine(crc, partResult.clientCRC, partResult.length);
        }
        return new Long(crc);
    }

    private ArrayList<DownloadPart> splitFile(Range range, long fileSize, long partSize) {
        if (fileSize <= 0L) {
            DownloadPart part = new DownloadPart();
            part.start = 0L;
            part.end = -1L;
            part.length = 0L;
            part.partNumber = 0;
            ArrayList<DownloadPart> parts = new ArrayList<DownloadPart>();
            parts.add(part);
            return parts;
        }
        long start = range.getBegin();
        long size = range.getEnd() - range.getBegin();
        int[] partArr = new int[2];
        this.checkPartSize(size, partArr);
        partSize = partArr[0];
        long count = partArr[1];
        ArrayList<DownloadPart> parts = new ArrayList<DownloadPart>();
        int i = 0;
        while ((long)i < count) {
            DownloadPart part = new DownloadPart();
            part.start = start + partSize * (long)i;
            part.end = start + partSize * (long)(i + 1) - 1L;
            part.length = part.end - part.start + 1L;
            if (part.end >= start + size) {
                part.end = -1L;
                part.length = start + size - part.start;
            }
            part.partNumber = i;
            part.fileStart = (long)i * partSize;
            parts.add(part);
            ++i;
        }
        return parts;
    }

    private Range correctRange(Range range, long totalSize) {
        long start = 0L;
        long size = totalSize;
        if (range != null) {
            start = range.getBegin();
            if (range.getBegin() == -1L) {
                start = 0L;
            }
            size = range.getEnd() - range.getBegin();
            if (range.getEnd() == -1L) {
                size = totalSize - start;
            }
        }
        return new Range(start, start + size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadPart(DownloadFileResult downloadResult, DownloadPart part) {
        RandomAccessFile output = null;
        InputStream content = null;
        try {
            if (this.mContext.getCancellationHandler().isCancelled()) {
                this.mPoolExecutor.getQueue().clear();
            }
            ++this.downloadPartSize;
            output = new RandomAccessFile(this.mRequest.getTempFilePath(), "rw");
            output.seek(part.fileStart);
            Map<String, String> requestHeader = this.mRequest.getRequestHeader();
            GetObjectRequest request = new GetObjectRequest(this.mRequest.getBucketName(), this.mRequest.getObjectKey());
            request.setRange(new Range(part.start, part.end));
            request.setRequestHeaders(requestHeader);
            GetObjectResult result = this.mOperation.getObject(request, null).getResult();
            content = result.getObjectContent();
            byte[] buffer = new byte[(int)part.length];
            long readLength = 0L;
            if (this.mRequest.getCRC64() == OSSRequest.CRC64Config.YES) {
                content = new CheckedInputStream(content, new CRC64());
            }
            while ((readLength = (long)content.read(buffer)) != -1L) {
                output.write(buffer, 0, (int)readLength);
            }
            Object object = this.mLock;
            synchronized (object) {
                DownloadPartResult partResult = new DownloadPartResult();
                partResult.partNumber = part.partNumber;
                partResult.requestId = result.getRequestId();
                partResult.length = result.getContentLength();
                if (this.mRequest.getCRC64() == OSSRequest.CRC64Config.YES) {
                    Long clientCRC;
                    partResult.clientCRC = clientCRC = Long.valueOf(((CheckedInputStream)content).getChecksum().getValue());
                    part.crc = clientCRC;
                }
                downloadResult.partResults.add(partResult);
                if (downloadResult.metadata == null) {
                    downloadResult.metadata = result.getMetadata();
                }
                ++this.completedPartSize;
                if (this.mContext.getCancellationHandler().isCancelled()) {
                    if (this.downloadPartSize == this.completedPartSize - this.mPartExceptionCount) {
                        this.checkCancel();
                    }
                } else {
                    if ((long)this.mCheckPoint.parts.size() == this.completedPartSize - this.mPartExceptionCount) {
                        this.notifyMultipartThread();
                    }
                    this.mCheckPoint.update(part.partNumber, true);
                    if (this.mRequest.getEnableCheckPoint().booleanValue()) {
                        this.mCheckPoint.dump(this.checkpointPath);
                    }
                    Range range = this.correctRange(this.mRequest.getRange(), this.mCheckPoint.fileStat.fileLength);
                    if (this.mProgressCallback != null) {
                        this.mProgressCallback.onProgress(this.mRequest, this.mCheckPoint.downloadLength, range.getEnd() - range.getBegin());
                    }
                }
            }
        }
        catch (Exception e) {
            this.processException(e);
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
                if (content != null) {
                    content.close();
                }
            }
            catch (IOException e) {
                OSSLog.logThrowable2Local(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFile(String filePath, long length) throws IOException {
        File file = new File(filePath);
        RandomAccessFile accessFile = null;
        try {
            accessFile = new RandomAccessFile(file, "rw");
            accessFile.setLength(length);
        }
        finally {
            if (accessFile != null) {
                accessFile.close();
            }
        }
    }

    private void moveFile(File fromFile, File toFile) throws IOException {
        boolean rename = fromFile.renameTo(toFile);
        if (!rename) {
            Log.i((String)"moveFile", (String)"rename");
            FileInputStream ist = null;
            OutputStream ost = null;
            try {
                ist = new FileInputStream(fromFile);
                ost = new FileOutputStream(toFile);
                this.copyFile(ist, ost);
                if (!fromFile.delete()) {
                    throw new IOException("Failed to delete original file '" + fromFile + "'");
                }
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            finally {
                if (ist != null) {
                    ((InputStream)ist).close();
                }
                if (ost != null) {
                    ost.close();
                }
            }
        }
    }

    private void copyFile(InputStream ist, OutputStream ost) throws IOException {
        int byteCount;
        byte[] buffer = new byte[4096];
        while ((byteCount = ist.read(buffer)) != -1) {
            ost.write(buffer, 0, byteCount);
        }
    }

    protected void notifyMultipartThread() {
        this.mLock.notify();
        this.mPartExceptionCount = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processException(Exception e) {
        Object object = this.mLock;
        synchronized (object) {
            ++this.mPartExceptionCount;
            if (this.mDownloadException == null) {
                this.mDownloadException = e;
                this.mLock.notify();
            }
        }
    }

    protected void releasePool() {
        if (this.mPoolExecutor != null) {
            this.mPoolExecutor.getQueue().clear();
            this.mPoolExecutor.shutdown();
        }
    }

    protected void checkException() throws IOException, ServiceException, ClientException {
        if (this.mDownloadException != null) {
            this.releasePool();
            if (this.mDownloadException instanceof IOException) {
                throw (IOException)this.mDownloadException;
            }
            if (this.mDownloadException instanceof ServiceException) {
                throw (ServiceException)this.mDownloadException;
            }
            if (this.mDownloadException instanceof ClientException) {
                throw (ClientException)this.mDownloadException;
            }
            ClientException clientException = new ClientException(this.mDownloadException.getMessage(), this.mDownloadException);
            throw clientException;
        }
    }

    protected boolean checkWaitCondition(int partNum) {
        return this.completedPartSize != (long)partNum;
    }

    protected void checkCancel() throws ClientException {
        if (this.mContext.getCancellationHandler().isCancelled()) {
            TaskCancelException e = new TaskCancelException("Resumable download cancel");
            throw new ClientException(e.getMessage(), e, true);
        }
    }

    private void checkPartSize(long fileLength, int[] partAttr) {
        long partSize = this.mRequest.getPartSize();
        OSSLog.logDebug("[checkPartSize] - mFileLength : " + fileLength);
        OSSLog.logDebug("[checkPartSize] - partSize : " + partSize);
        long partNumber = fileLength / partSize;
        if (fileLength % partSize != 0L) {
            ++partNumber;
        }
        int MAX_PART_NUM = 5000;
        if (partNumber == 1L) {
            partSize = fileLength;
        } else if (partNumber > (long)MAX_PART_NUM) {
            partSize = fileLength / (long)(MAX_PART_NUM - 1);
            partSize = this.ceilPartSize(partSize);
            partNumber = fileLength / partSize;
            partNumber += fileLength % partSize != 0L ? 1L : 0L;
        }
        partAttr[0] = (int)partSize;
        partAttr[1] = (int)partNumber;
        OSSLog.logDebug("[checkPartSize] - partNumber : " + partNumber);
        OSSLog.logDebug("[checkPartSize] - partSize : " + (int)partSize);
    }

    private long ceilPartSize(long partSize) {
        partSize = (partSize + 4095L) / 4096L * 4096L;
        return partSize;
    }

    class DownloadFileResult
    extends OSSResult {
        public ArrayList<DownloadPartResult> partResults;
        public ObjectMetadata metadata;

        DownloadFileResult() {
        }
    }

    static class DownloadPartResult {
        public int partNumber;
        public String requestId;
        public Long clientCRC;
        public long length;

        DownloadPartResult() {
        }
    }

    static class FileStat
    implements Serializable {
        private static final long serialVersionUID = 3896323364904643963L;
        public long fileLength;
        public String md5;
        public Date lastModified;
        public String etag;
        public Long serverCRC;
        public String requestId;

        FileStat() {
        }

        public static FileStat getFileStat(InternalRequestOperation operation, String bucketName, String objectKey) throws ClientException, ServiceException {
            GetObjectMetaRequest request = new GetObjectMetaRequest(bucketName, objectKey);
            GetObjectMetaResult result = operation.getObjectMeta(request, null).getResult();
            FileStat fileStat = new FileStat();
            fileStat.fileLength = result.getMetadata().getContentLength();
            fileStat.etag = result.getMetadata().getETag();
            fileStat.lastModified = result.getMetadata().getLastModified();
            fileStat.serverCRC = result.getServerCRC();
            fileStat.requestId = result.getRequestId();
            return fileStat;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.etag == null ? 0 : this.etag.hashCode());
            result = 31 * result + (this.lastModified == null ? 0 : this.lastModified.hashCode());
            result = 31 * result + (int)(this.fileLength ^ this.fileLength >>> 32);
            return result;
        }
    }

    static class CheckPoint
    implements Serializable {
        private static final long serialVersionUID = -8470273912385636504L;
        public int md5;
        public String downloadFile;
        public String bucketName;
        public String objectKey;
        public FileStat fileStat;
        public ArrayList<DownloadPart> parts;
        public long downloadLength;

        CheckPoint() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void load(String cpFile) throws IOException, ClassNotFoundException {
            FileInputStream fileIn = null;
            ObjectInputStream in = null;
            try {
                fileIn = new FileInputStream(cpFile);
                in = new ObjectInputStream(fileIn);
                CheckPoint dcp = (CheckPoint)in.readObject();
                this.assign(dcp);
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (fileIn != null) {
                    fileIn.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void dump(String cpFile) throws IOException {
            this.md5 = this.hashCode();
            FileOutputStream fileOut = null;
            ObjectOutputStream outStream = null;
            File tempFile = new File(cpFile + ResumableDownloadTask.TEMP_SUFFIX);
            try {
                fileOut = new FileOutputStream(tempFile);
                outStream = new ObjectOutputStream(fileOut);
                outStream.writeObject(this);
                tempFile.renameTo(new File(cpFile));
            }
            finally {
                if (outStream != null) {
                    outStream.close();
                }
                if (fileOut != null) {
                    fileOut.close();
                }
            }
        }

        public synchronized void update(int index, boolean completed) throws IOException {
            this.parts.get((int)index).isCompleted = completed;
            this.downloadLength += this.parts.get((int)index).length;
        }

        public synchronized boolean isValid(InternalRequestOperation operation) throws ClientException, ServiceException {
            if (this.md5 != this.hashCode()) {
                return false;
            }
            FileStat fileStat = FileStat.getFileStat(operation, this.bucketName, this.objectKey);
            return !(this.fileStat.lastModified == null ? this.fileStat.fileLength != fileStat.fileLength || !this.fileStat.etag.equals(fileStat.etag) : this.fileStat.fileLength != fileStat.fileLength || !this.fileStat.lastModified.equals(fileStat.lastModified) || !this.fileStat.etag.equals(fileStat.etag));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.bucketName == null ? 0 : this.bucketName.hashCode());
            result = 31 * result + (this.downloadFile == null ? 0 : this.downloadFile.hashCode());
            result = 31 * result + (this.objectKey == null ? 0 : this.objectKey.hashCode());
            result = 31 * result + (this.fileStat == null ? 0 : this.fileStat.hashCode());
            result = 31 * result + (this.parts == null ? 0 : this.parts.hashCode());
            result = 31 * result + (int)(this.downloadLength ^ this.downloadLength >>> 32);
            return result;
        }

        private void assign(CheckPoint dcp) {
            this.md5 = dcp.md5;
            this.downloadFile = dcp.downloadFile;
            this.bucketName = dcp.bucketName;
            this.objectKey = dcp.objectKey;
            this.fileStat = dcp.fileStat;
            this.parts = dcp.parts;
            this.downloadLength = dcp.downloadLength;
        }
    }

    static class DownloadPart
    implements Serializable {
        private static final long serialVersionUID = -3506020776131733942L;
        public int partNumber;
        public long start;
        public long end;
        public boolean isCompleted;
        public long length;
        public long fileStart;
        public long crc;

        DownloadPart() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.partNumber;
            result = 31 * result + (this.isCompleted ? 1231 : 1237);
            result = 31 * result + (int)(this.end ^ this.end >>> 32);
            result = 31 * result + (int)(this.start ^ this.start >>> 32);
            result = 31 * result + (int)(this.crc ^ this.crc >>> 32);
            return result;
        }
    }
}

