/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.common.auth;

import com.alibaba.sdk.android.oss.common.auth.OSSCredentialProvider;
import com.alibaba.sdk.android.oss.common.auth.OSSFederationToken;

public class OSSStsTokenCredentialProvider
implements OSSCredentialProvider {
    private String accessKeyId;
    private String secretKeyId;
    private String securityToken;

    public OSSStsTokenCredentialProvider(String accessKeyId, String secretKeyId, String securityToken) {
        this.setAccessKeyId(accessKeyId.trim());
        this.setSecretKeyId(secretKeyId.trim());
        this.setSecurityToken(securityToken.trim());
    }

    public OSSStsTokenCredentialProvider(OSSFederationToken token) {
        this.setAccessKeyId(token.getTempAK().trim());
        this.setSecretKeyId(token.getTempSK().trim());
        this.setSecurityToken(token.getSecurityToken().trim());
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getSecretKeyId() {
        return this.secretKeyId;
    }

    public void setSecretKeyId(String secretKeyId) {
        this.secretKeyId = secretKeyId;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    @Override
    public OSSFederationToken getFederationToken() {
        return new OSSFederationToken(this.accessKeyId, this.secretKeyId, this.securityToken, Long.MAX_VALUE);
    }
}

