/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.common;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class LogThreadPoolManager {
    private static final int SIZE_CORE_POOL = 1;
    private static final int SIZE_MAX_POOL = 1;
    private static final int TIME_KEEP_ALIVE = 5000;
    private static final int SIZE_WORK_QUEUE = 500;
    private static final int PERIOD_TASK_QOS = 1000;
    private static final int SIZE_CACHE_QUEUE = 200;
    private static LogThreadPoolManager sThreadPoolManager = new LogThreadPoolManager();
    private final Queue<Runnable> mTaskQueue = new LinkedList<Runnable>();
    private final RejectedExecutionHandler mHandler = new RejectedExecutionHandler(){

        @Override
        public void rejectedExecution(Runnable task, ThreadPoolExecutor executor) {
            if (LogThreadPoolManager.this.mTaskQueue.size() >= 200) {
                LogThreadPoolManager.this.mTaskQueue.poll();
            }
            LogThreadPoolManager.this.mTaskQueue.offer(task);
        }
    };
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final ThreadPoolExecutor mThreadPool = new ThreadPoolExecutor(1, 1, 5000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(500), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "oss-android-log-thread");
        }
    }, this.mHandler);
    private final Runnable mAccessBufferThread = new Runnable(){

        @Override
        public void run() {
            if (LogThreadPoolManager.this.hasMoreAcquire()) {
                LogThreadPoolManager.this.mThreadPool.execute((Runnable)LogThreadPoolManager.this.mTaskQueue.poll());
            }
        }
    };
    protected final ScheduledFuture<?> mTaskHandler = this.scheduler.scheduleAtFixedRate(this.mAccessBufferThread, 0L, 1000L, TimeUnit.MILLISECONDS);

    private LogThreadPoolManager() {
    }

    public static LogThreadPoolManager newInstance() {
        if (sThreadPoolManager == null) {
            sThreadPoolManager = new LogThreadPoolManager();
        }
        return sThreadPoolManager;
    }

    private boolean hasMoreAcquire() {
        return !this.mTaskQueue.isEmpty();
    }

    public void addExecuteTask(Runnable task) {
        if (task != null) {
            this.mThreadPool.execute(task);
        }
    }
}

