/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.credentials.provider;

import com.aliyun.credentials.exception.CredentialException;
import com.aliyun.credentials.http.CompatibleUrlConnClient;
import com.aliyun.credentials.http.HttpRequest;
import com.aliyun.credentials.http.HttpResponse;
import com.aliyun.credentials.http.MethodType;
import com.aliyun.credentials.models.CredentialModel;
import com.aliyun.credentials.provider.RefreshResult;
import com.aliyun.credentials.utils.ParameterHelper;
import com.google.gson.Gson;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ECSMetadataServiceCredentialsFetcher {
    private static final String URL_IN_ECS_METADATA = "/latest/meta-data/ram/security-credentials/";
    private static final String URL_IN_METADATA_TOKEN = "/latest/api/token";
    private static final String ECS_METADAT_FETCH_ERROR_MSG = "Failed to get RAM session credentials from ECS metadata service.";
    private URL credentialUrl;
    private String roleName;
    private String metadataServiceHost = "100.100.100.200";
    private int connectionTimeout = 1000;
    private int readTimeout = 1000;
    private String metadataToken;
    private final boolean enableIMDSv2;
    private int metadataTokenDuration;
    private volatile long staleTime;
    private static final long REFRESH_BLOCKING_MAX_WAIT = 5000L;
    private final Lock refreshLock = new ReentrantLock();

    public ECSMetadataServiceCredentialsFetcher(String roleName, int connectionTimeout, int readTimeout) {
        if (connectionTimeout > 1000) {
            this.connectionTimeout = connectionTimeout;
        }
        if (readTimeout > 1000) {
            this.readTimeout = readTimeout;
        }
        this.enableIMDSv2 = false;
        this.roleName = roleName;
        this.setCredentialUrl();
    }

    public ECSMetadataServiceCredentialsFetcher(String roleName, boolean enableIMDSv2, int metadataTokenDuration, int connectionTimeout, int readTimeout) {
        if (connectionTimeout > 1000) {
            this.connectionTimeout = connectionTimeout;
        }
        if (readTimeout > 1000) {
            this.readTimeout = readTimeout;
        }
        this.enableIMDSv2 = enableIMDSv2;
        this.metadataTokenDuration = metadataTokenDuration;
        this.roleName = roleName;
        this.setCredentialUrl();
    }

    public ECSMetadataServiceCredentialsFetcher(String roleName) {
        this.roleName = roleName;
        this.enableIMDSv2 = false;
        this.setCredentialUrl();
    }

    private void setCredentialUrl() {
        try {
            this.credentialUrl = new URL("http://" + this.metadataServiceHost + URL_IN_ECS_METADATA + this.roleName);
        }
        catch (MalformedURLException e) {
            throw new CredentialException(e.getMessage(), e);
        }
    }

    public String fetchRoleName(CompatibleUrlConnClient client) {
        return this.getMetadata(client);
    }

    public String getMetadata(CompatibleUrlConnClient client) {
        HttpResponse response;
        HttpRequest request = new HttpRequest(this.credentialUrl.toString());
        request.setSysMethod(MethodType.GET);
        request.setSysConnectTimeout(this.connectionTimeout);
        request.setSysReadTimeout(this.readTimeout);
        if (this.enableIMDSv2) {
            this.refreshMetadataToken(client);
            request.putHeaderParameter("X-aliyun-ecs-metadata-token", this.metadataToken);
        }
        try {
            response = client.syncInvoke(request);
        }
        catch (Exception e) {
            throw new CredentialException("Failed to connect ECS Metadata Service: " + e);
        }
        finally {
            client.close();
        }
        if (response.getResponseCode() == 404) {
            throw new CredentialException("The role name was not found in the instance");
        }
        if (response.getResponseCode() != 200) {
            throw new CredentialException("Failed to get RAM session credentials from ECS metadata service. HttpCode=" + response.getResponseCode());
        }
        return new String(response.getHttpContent());
    }

    public RefreshResult<CredentialModel> fetch(CompatibleUrlConnClient client) {
        String jsonContent = this.getMetadata(client);
        Map result = (Map)new Gson().fromJson(jsonContent, Map.class);
        if (!"Success".equals(result.get("Code"))) {
            throw new CredentialException(ECS_METADAT_FETCH_ERROR_MSG);
        }
        long expiration = ParameterHelper.getUTCDate((String)result.get("Expiration")).getTime();
        CredentialModel credential = CredentialModel.builder().accessKeyId((String)result.get("AccessKeyId")).accessKeySecret((String)result.get("AccessKeySecret")).securityToken((String)result.get("SecurityToken")).type("ecs_ram_role").expiration(expiration).build();
        return RefreshResult.builder(credential).staleTime(expiration - 180000L).build();
    }

    public URL getCredentialUrl() {
        return this.credentialUrl;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public boolean getEnableIMDSv2() {
        return this.enableIMDSv2;
    }

    public int getMetadataTokenDuration() {
        return this.metadataTokenDuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshMetadataToken(CompatibleUrlConnClient client) {
        block9: {
            try {
                if (!this.refreshLock.tryLock(5000L, TimeUnit.MILLISECONDS)) break block9;
                try {
                    HttpResponse response;
                    if (!this.needToRefresh()) break block9;
                    HttpRequest request = new HttpRequest("http://" + this.metadataServiceHost + URL_IN_METADATA_TOKEN);
                    request.setSysMethod(MethodType.PUT);
                    request.setSysConnectTimeout(this.connectionTimeout);
                    request.setSysReadTimeout(this.readTimeout);
                    request.putHeaderParameter("X-aliyun-ecs-metadata-token-ttl-seconds", String.valueOf(this.metadataTokenDuration));
                    long tmpTime = this.staleTime;
                    this.staleTime = new Date().getTime() + (long)this.metadataTokenDuration * 1000L - 10000L;
                    try {
                        response = client.syncInvoke(request);
                    }
                    catch (Exception e) {
                        this.staleTime = tmpTime;
                        throw new CredentialException("Failed to connect ECS Metadata Service: " + e);
                    }
                    if (response.getResponseCode() != 200) {
                        this.staleTime = tmpTime;
                        throw new CredentialException("Failed to get token from ECS Metadata Service. HttpCode=" + response.getResponseCode());
                    }
                    this.metadataToken = new String(response.getHttpContent());
                }
                finally {
                    this.refreshLock.unlock();
                }
            }
            catch (InterruptedException ex) {
                throw new IllegalStateException("Interrupted waiting to refresh the metadata token.", ex);
            }
            catch (Exception ex) {
                throw ex;
            }
        }
    }

    private boolean needToRefresh() {
        return new Date().getTime() >= this.staleTime;
    }
}

