/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.http;

import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.utils.ParameterHelper;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.X509TrustManager;

public abstract class HttpMessage {
    protected static final String CONTENT_TYPE = "Content-Type";
    protected static final String CONTENT_MD5 = "Content-MD5";
    protected static final String CONTENT_LENGTH = "Content-Length";
    protected FormatType httpContentType = null;
    protected byte[] httpContent = null;
    protected String encoding = null;
    protected Map<String, String> headers = new HashMap<String, String>();
    protected Integer connectTimeout = null;
    protected Integer readTimeout = null;
    private String url = null;
    private MethodType method = null;
    protected boolean ignoreSSLCerts = false;
    private KeyManager[] keyManagers = null;
    private X509TrustManager[] x509TrustManagers = null;

    public KeyManager[] getKeyManagers() {
        return this.keyManagers;
    }

    public void setKeyManagers(KeyManager[] keyManagers) {
        this.keyManagers = keyManagers;
    }

    public X509TrustManager[] getX509TrustManagers() {
        return this.x509TrustManagers;
    }

    public void setX509TrustManagers(X509TrustManager[] x509TrustManagers) {
        this.x509TrustManagers = x509TrustManagers;
    }

    public boolean isIgnoreSSLCerts() {
        return this.ignoreSSLCerts;
    }

    public void setIgnoreSSLCerts(boolean ignoreSSLCerts) {
        this.ignoreSSLCerts = ignoreSSLCerts;
    }

    public HttpMessage(String strUrl) {
        this.url = strUrl;
    }

    public HttpMessage() {
    }

    @Deprecated
    public String getUrl() {
        return this.url;
    }

    @Deprecated
    protected void setUrl(String url) {
        this.url = url;
    }

    @Deprecated
    public MethodType getMethod() {
        return this.method;
    }

    @Deprecated
    public void setMethod(MethodType method) {
        this.method = method;
    }

    public FormatType getHttpContentType() {
        return this.httpContentType;
    }

    public void setHttpContentType(FormatType httpContentType) {
        this.httpContentType = httpContentType;
        if (null != this.httpContent || null != httpContentType) {
            this.headers.put(CONTENT_TYPE, this.getContentTypeValue(this.httpContentType, this.encoding));
        } else {
            this.headers.remove(CONTENT_TYPE);
        }
    }

    public byte[] getHttpContent() {
        return this.httpContent;
    }

    public void setHttpContent(byte[] content, String encoding, FormatType format) {
        if (null == content) {
            this.headers.remove(CONTENT_MD5);
            this.headers.put(CONTENT_LENGTH, "0");
            this.headers.remove(CONTENT_TYPE);
            this.httpContentType = null;
            this.httpContent = null;
            this.encoding = null;
            return;
        }
        if (this.getSysMethod() != null && !this.getSysMethod().hasContent()) {
            content = new byte[]{};
        }
        this.httpContent = content;
        this.encoding = encoding;
        String contentLen = String.valueOf(content.length);
        String strMd5 = ParameterHelper.md5Sum(content);
        this.headers.put(CONTENT_MD5, strMd5);
        this.headers.put(CONTENT_LENGTH, contentLen);
        if (null != format) {
            this.headers.put(CONTENT_TYPE, FormatType.mapFormatToAccept(format));
        }
    }

    @Deprecated
    public String getEncoding() {
        return this.encoding;
    }

    @Deprecated
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void putHeaderParameter(String name, String value) {
        if (null != name && null != value) {
            this.headers.put(name, value);
        }
    }

    public String getHeaderValue(String name) {
        return this.headers.get(name);
    }

    @Deprecated
    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    @Deprecated
    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Deprecated
    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    @Deprecated
    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Deprecated
    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public String getContentTypeValue(FormatType contentType, String encoding) {
        if (null != contentType && null != encoding) {
            return FormatType.mapFormatToAccept(contentType) + ";charset=" + encoding.toLowerCase();
        }
        if (null != contentType) {
            return FormatType.mapFormatToAccept(contentType);
        }
        return null;
    }

    public String getHttpContentString() throws ClientException {
        String stringContent = "";
        if (this.httpContent != null) {
            try {
                stringContent = this.encoding == null ? new String(this.httpContent) : new String(this.httpContent, this.encoding);
            }
            catch (UnsupportedEncodingException exp) {
                throw new ClientException("SDK.UnsupportedEncoding", "Can not parse response due to unsupported encoding.");
            }
        }
        return stringContent;
    }

    public String getSysUrl() {
        return this.url;
    }

    protected void setSysUrl(String url) {
        this.url = url;
    }

    public MethodType getSysMethod() {
        return this.method;
    }

    public void setSysMethod(MethodType method) {
        this.method = method;
    }

    public String getSysEncoding() {
        return this.encoding;
    }

    public void setSysEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Integer getSysConnectTimeout() {
        return this.connectTimeout;
    }

    public void setSysConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Integer getSysReadTimeout() {
        return this.readTimeout;
    }

    public void setSysReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public Map<String, String> getSysHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public String getSysStrToSign() {
        return null;
    }

    public String toString() {
        return "HttpMessage(httpContentType=" + (Object)((Object)this.getHttpContentType()) + ", httpContent=" + Arrays.toString(this.getHttpContent()) + ", encoding=" + this.getEncoding() + ", headers=" + this.getHeaders() + ", connectTimeout=" + this.getConnectTimeout() + ", readTimeout=" + this.getReadTimeout() + ", url=" + this.getUrl() + ", method=" + (Object)((Object)this.getMethod()) + ", ignoreSSLCerts=" + this.isIgnoreSSLCerts() + ", keyManagers=" + Arrays.deepToString(this.getKeyManagers()) + ", x509TrustManagers=" + Arrays.deepToString(this.getX509TrustManagers()) + ")";
    }
}

