/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.endpoint;

import com.aliyuncs.endpoint.LocalConfigRegionalEndpointResolver;
import com.aliyuncs.endpoint.ResolveEndpointRequest;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashSet;
import java.util.Map;

public class LocalConfigGlobalEndpointResolver
extends LocalConfigRegionalEndpointResolver {
    public LocalConfigGlobalEndpointResolver() {
        this.initLocalConfig(LocalConfigRegionalEndpointResolver.ENDPOINTS_JSON);
    }

    public LocalConfigGlobalEndpointResolver(String configJsonStr) {
        JsonObject obj = JsonParser.parseString((String)configJsonStr).getAsJsonObject();
        this.initLocalConfig(obj);
    }

    protected void initLocalConfig(JsonObject obj) {
        this.initGlobalEndpointData(obj);
        this.initRegionIds(obj);
        this.initLocationCodeMapping(obj);
    }

    private void initGlobalEndpointData(JsonObject obj) {
        if (!obj.has("global_endpoints")) {
            return;
        }
        JsonObject globalEndpoints = obj.get("global_endpoints").getAsJsonObject();
        HashSet globalEndpointsKeySet = new HashSet();
        for (Map.Entry entry : globalEndpoints.entrySet()) {
            globalEndpointsKeySet.add(entry.getKey());
        }
        for (String locationServiceCode : globalEndpointsKeySet) {
            String endpoint = globalEndpoints.get(locationServiceCode).getAsString();
            this.putEndpointEntry(this.makeEndpointKey(locationServiceCode), endpoint);
        }
    }

    @Override
    public String resolve(ResolveEndpointRequest request) {
        if (request.isOpenApiEndpoint() && this.isRegionIdValid(request)) {
            return this.fetchEndpointEntry(request);
        }
        return null;
    }

    @Override
    public String makeEndpointKey(ResolveEndpointRequest request) {
        return this.makeEndpointKey(request.productCodeLower);
    }

    public String makeEndpointKey(String productCodeLower) {
        return this.getNormalizedProductCode(productCodeLower);
    }
}

