/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.http.clients;

import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.CallBack;
import com.aliyuncs.http.CompositeX509TrustManager;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.HttpClientConfig;
import com.aliyuncs.http.HttpRequest;
import com.aliyuncs.http.HttpResponse;
import com.aliyuncs.http.HttpUtil;
import com.aliyuncs.http.IHttpClient;
import com.aliyuncs.http.clients.ApacheIdleConnectionCleaner;
import com.aliyuncs.utils.EnvironmentUtils;
import com.aliyuncs.utils.IOUtils;
import com.aliyuncs.utils.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class ApacheHttpClient
extends IHttpClient {
    protected static final String CONTENT_TYPE = "Content-Type";
    protected static final String ACCEPT_ENCODING = "Accept-Encoding";
    private static final String EXT_PARAM_KEY_BUILDER = "apache.httpclient.builder";
    private static final int DEFAULT_THREAD_KEEP_ALIVE_TIME = 60;
    private ExecutorService executorService;
    private CloseableHttpClient httpClient;
    private PoolingHttpClientConnectionManager connectionManager;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private CountDownLatch latch = new CountDownLatch(1);
    private static volatile ApacheHttpClient client;

    @Deprecated
    public static ApacheHttpClient getInstance(HttpClientConfig config) throws ClientException {
        throw new IllegalStateException("use ApacheHttpClient.getInstance() instead");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApacheHttpClient getInstance() {
        if (client != null) return client;
        Class<ApacheHttpClient> clazz = ApacheHttpClient.class;
        synchronized (ApacheHttpClient.class) {
            if (client != null) return client;
            client = new ApacheHttpClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return client;
        }
    }

    private ApacheHttpClient() {
    }

    private SSLConnectionSocketFactory createSSLConnectionSocketFactory() throws ClientException {
        try {
            if (null == this.clientConfig.getSslSocketFactory()) {
                ArrayList<TrustManager> trustManagerList = new ArrayList<TrustManager>();
                X509TrustManager[] trustManagers = this.clientConfig.getX509TrustManagers();
                if (null != trustManagers) {
                    trustManagerList.addAll(Arrays.asList(trustManagers));
                }
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init((KeyStore)null);
                trustManagerList.addAll(Arrays.asList(tmf.getTrustManagers()));
                ArrayList<X509TrustManager> finalTrustManagerList = new ArrayList<X509TrustManager>();
                for (TrustManager tm : trustManagerList) {
                    if (!(tm instanceof X509TrustManager)) continue;
                    finalTrustManagerList.add((X509TrustManager)tm);
                }
                CompositeX509TrustManager compositeX509TrustManager = new CompositeX509TrustManager(finalTrustManagerList);
                compositeX509TrustManager.setIgnoreSSLCert(this.clientConfig.isIgnoreSSLCerts());
                KeyManager[] keyManagers = null;
                if (this.clientConfig.getKeyManagers() != null) {
                    keyManagers = this.clientConfig.getKeyManagers();
                }
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(keyManagers, new TrustManager[]{compositeX509TrustManager}, this.clientConfig.getSecureRandom());
                Object hostnameVerifier = null;
                hostnameVerifier = this.clientConfig.isIgnoreSSLCerts() ? new NoopHostnameVerifier() : (this.clientConfig.getHostnameVerifier() != null ? this.clientConfig.getHostnameVerifier() : new DefaultHostnameVerifier());
                SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
                return sslConnectionSocketFactory;
            }
            Object hostnameVerifier = null == this.clientConfig.getHostnameVerifier() ? new NoopHostnameVerifier() : this.clientConfig.getHostnameVerifier();
            return new SSLConnectionSocketFactory(this.clientConfig.getSslSocketFactory(), (HostnameVerifier)hostnameVerifier);
        }
        catch (Exception e) {
            throw new ClientException("SDK.InitFailed", "Init https with SSL socket failed", e);
        }
    }

    private void initConnectionManager() throws ClientException {
        RegistryBuilder socketFactoryRegistryBuilder = RegistryBuilder.create();
        socketFactoryRegistryBuilder.register("http", (Object)new PlainConnectionSocketFactory());
        SSLConnectionSocketFactory sslConnectionSocketFactory = this.createSSLConnectionSocketFactory();
        socketFactoryRegistryBuilder.register("https", (Object)sslConnectionSocketFactory);
        this.connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistryBuilder.build());
        this.connectionManager.setMaxTotal(this.clientConfig.getMaxRequests());
        this.connectionManager.setDefaultMaxPerRoute(this.clientConfig.getMaxRequestsPerHost());
    }

    private HttpClientBuilder initHttpClientBuilder() {
        HttpClientBuilder builder = this.clientConfig.containsExtParam(EXT_PARAM_KEY_BUILDER) ? (HttpClientBuilder)this.clientConfig.getExtParam(EXT_PARAM_KEY_BUILDER) : HttpClientBuilder.create();
        return builder;
    }

    private void initExecutor() {
        this.executorService = this.clientConfig.getExecutorService() == null ? new ThreadPoolExecutor(0, this.clientConfig.getMaxRequests(), 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DefaultAsyncThreadFactory()) : this.clientConfig.getExecutorService();
    }

    @Override
    protected void init(HttpClientConfig config0) throws ClientException {
        HttpClientConfig config;
        if (!this.initialized.compareAndSet(false, true)) {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                throw new ClientException("SDK.InitFailed", "Init apacheHttpClient failed", e);
            }
            return;
        }
        this.clientConfig = config = config0 != null ? config0 : HttpClientConfig.getDefault();
        HttpClientBuilder builder = this.initHttpClientBuilder();
        CredentialsProvider credentialsProvider = this.clientConfig.getCredentialsProvider();
        if (null != credentialsProvider) {
            builder.setDefaultCredentialsProvider(credentialsProvider);
        }
        RequestConfig defaultConfig = RequestConfig.custom().setConnectTimeout((int)config.getConnectionTimeoutMillis()).setSocketTimeout((int)config.getReadTimeoutMillis()).setConnectionRequestTimeout((int)config.getWriteTimeoutMillis()).build();
        builder.setDefaultRequestConfig(defaultConfig);
        this.initConnectionManager();
        builder.setConnectionManager((HttpClientConnectionManager)this.connectionManager);
        ApacheIdleConnectionCleaner.registerConnectionManager((HttpClientConnectionManager)this.connectionManager, config.getMaxIdleTimeMillis());
        this.initExecutor();
        builder.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false));
        if (config.getKeepAliveDurationMillis() > 0L) {
            builder.setKeepAliveStrategy(new ConnectionKeepAliveStrategy(){

                public long getKeepAliveDuration(org.apache.http.HttpResponse response, HttpContext context) {
                    long duration = DefaultConnectionKeepAliveStrategy.INSTANCE.getKeepAliveDuration(response, context);
                    if (duration > 0L && duration < config.getKeepAliveDurationMillis()) {
                        return duration;
                    }
                    return config.getKeepAliveDurationMillis();
                }
            });
        }
        this.httpClient = builder.build();
        this.latch.countDown();
    }

    /*
     * WARNING - void declaration
     */
    private HttpUriRequest parseToHttpRequest(HttpRequest apiReq) throws IOException, ClientException {
        void var5_9;
        RequestBuilder builder = RequestBuilder.create((String)apiReq.getSysMethod().name());
        builder.setUri(apiReq.getSysUrl());
        if (apiReq.getSysMethod().hasContent() && apiReq.getHttpContent() != null && apiReq.getHttpContent().length > 0) {
            EntityBuilder bodyBuilder = EntityBuilder.create();
            Object contentType = apiReq.getHeaderValue(CONTENT_TYPE);
            if (StringUtils.isEmpty((CharSequence)contentType)) {
                contentType = apiReq.getContentTypeValue(apiReq.getHttpContentType(), apiReq.getSysEncoding());
            }
            bodyBuilder.setContentType(ContentType.parse((String)contentType));
            bodyBuilder.setBinary(apiReq.getHttpContent());
            builder.setEntity(bodyBuilder.build());
        }
        builder.addHeader(ACCEPT_ENCODING, "identity");
        HttpHost proxy = this.calcProxy(apiReq);
        for (Map.Entry entry : apiReq.getSysHeaders().entrySet()) {
            if ("Content-Length".equalsIgnoreCase((String)entry.getKey())) continue;
            builder.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        int connectTimeout = null != apiReq.getSysConnectTimeout() ? apiReq.getSysConnectTimeout() : (int)this.clientConfig.getConnectionTimeoutMillis();
        if (null != apiReq.getSysReadTimeout()) {
            int n = apiReq.getSysReadTimeout();
        } else {
            int n = (int)this.clientConfig.getReadTimeoutMillis();
        }
        RequestConfig requestConfig = RequestConfig.custom().setProxy(proxy).setConnectTimeout(connectTimeout).setSocketTimeout((int)var5_9).setConnectionRequestTimeout((int)this.clientConfig.getWriteTimeoutMillis()).build();
        builder.setConfig(requestConfig);
        return builder.build();
    }

    private HttpHost calcProxy(HttpRequest apiReq) throws MalformedURLException, ClientException {
        boolean needProxy = HttpUtil.needProxy(new URL(apiReq.getSysUrl()).getHost(), this.clientConfig.getNoProxy(), EnvironmentUtils.getNoProxy());
        if (!needProxy) {
            return null;
        }
        URL url = new URL(apiReq.getSysUrl());
        HttpHost proxy = null;
        proxy = "https".equalsIgnoreCase(url.getProtocol()) ? HttpUtil.getApacheProxy(this.clientConfig.getHttpsProxy(), EnvironmentUtils.getHttpsProxy(), apiReq) : HttpUtil.getApacheProxy(this.clientConfig.getHttpProxy(), EnvironmentUtils.getHttpProxy(), apiReq);
        return proxy;
    }

    private HttpResponse parseToHttpResponse(org.apache.http.HttpResponse httpResponse) throws IOException {
        boolean existed;
        HttpResponse result = new HttpResponse();
        result.setStatus(httpResponse.getStatusLine().getStatusCode());
        result.setReasonPhrase(httpResponse.getStatusLine().getReasonPhrase());
        boolean bl = existed = httpResponse.getEntity() != null && (httpResponse.getEntity().getContentLength() > 0L || httpResponse.getEntity().isChunked());
        if (existed) {
            Header contentTypeHeader = httpResponse.getEntity().getContentType();
            ContentType contentType = ContentType.parse((String)contentTypeHeader.getValue());
            FormatType formatType = FormatType.mapAcceptToFormat(contentType.getMimeType());
            result.setHttpContentType(formatType);
            String charset = "utf-8";
            if (contentType.getCharset() != null) {
                charset = contentType.getCharset().toString();
            }
            result.setHttpContent(EntityUtils.toByteArray((HttpEntity)httpResponse.getEntity()), charset, formatType);
        }
        for (Header header : httpResponse.getAllHeaders()) {
            result.putHeaderParameter(header.getName(), header.getValue());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final HttpResponse syncInvoke(HttpRequest apiRequest) throws IOException, ClientException {
        HttpResponse httpResponse;
        HttpUriRequest httpRequest = this.parseToHttpRequest(apiRequest);
        CloseableHttpResponse httpResponse2 = null;
        try {
            httpResponse2 = this.httpClient.execute(httpRequest);
            httpResponse = this.parseToHttpResponse((org.apache.http.HttpResponse)httpResponse2);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(httpResponse2);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)httpResponse2);
        return httpResponse;
    }

    @Override
    public final Future<HttpResponse> asyncInvoke(final HttpRequest apiRequest, final CallBack callback) {
        return this.executorService.submit(new Callable<HttpResponse>(){

            @Override
            public HttpResponse call() throws Exception {
                HttpResponse result;
                try {
                    result = ApacheHttpClient.this.syncInvoke(apiRequest);
                }
                catch (Exception e) {
                    if (callback != null) {
                        callback.onFailure(apiRequest, e);
                    }
                    throw e;
                }
                if (callback != null) {
                    callback.onResponse(apiRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void ignoreSSLCertificate() {
        throw new IllegalStateException("Apache httpclient does not support modify sslFactory after inited, use HttpClientConfig.setIgnoreSSLCerts(true) while building client");
    }

    @Override
    public void restoreSSLCertificate() {
        throw new IllegalStateException("Apache httpclient does not support modify sslFactory after inited, use HttpClientConfig.setIgnoreSSLCerts(true) while building client");
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public void close() throws IOException {
        client = null;
        if (this.initialized.compareAndSet(true, false)) {
            this.executorService.shutdown();
            ApacheIdleConnectionCleaner.removeConnectionManager((HttpClientConnectionManager)this.connectionManager);
            this.connectionManager.shutdown();
            IOUtils.closeQuietly((Closeable)this.httpClient);
        }
    }

    private class DefaultAsyncThreadFactory
    implements ThreadFactory {
        private AtomicInteger counter = new AtomicInteger(0);

        private DefaultAsyncThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, "Aliyun_SDK_Async_ThreadPool_" + this.counter.incrementAndGet());
        }
    }
}

