/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.core.http;

import com.aliyun.core.http.HttpHeaders;
import com.aliyun.core.http.HttpResponse;
import com.aliyun.core.utils.BaseUtils;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public final class BufferedHttpResponse
extends HttpResponse {
    private final HttpResponse innerHttpResponse;
    private final ByteBuffer cachedBody;

    public BufferedHttpResponse(HttpResponse innerHttpResponse) {
        super(innerHttpResponse.getRequest());
        this.innerHttpResponse = innerHttpResponse;
        this.cachedBody = innerHttpResponse.getBody();
    }

    @Override
    public int getStatusCode() {
        return this.innerHttpResponse.getStatusCode();
    }

    @Override
    public String getHeaderValue(String name) {
        return this.innerHttpResponse.getHeaderValue(name);
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.innerHttpResponse.getHeaders();
    }

    @Override
    public ByteBuffer getBody() {
        return this.cachedBody;
    }

    @Override
    public byte[] getBodyAsByteArray() {
        return this.cachedBody.array();
    }

    @Override
    public String getBodyAsString() {
        return BaseUtils.bomAwareToString(this.cachedBody.array(), this.innerHttpResponse.getHeaderValue("Content-Type"));
    }

    @Override
    public String getBodyAsString(Charset charset) {
        return new String(this.cachedBody.array(), charset);
    }

    @Override
    public BufferedHttpResponse buffer() {
        return this;
    }
}

