/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.auth.credentials.provider;

import com.aliyun.auth.credentials.ICredential;
import com.aliyun.auth.credentials.exception.CredentialException;
import com.aliyun.auth.credentials.provider.ICredentialProvider;
import com.aliyun.auth.credentials.utils.NonBlocking;
import com.aliyun.auth.credentials.utils.RefreshCachedSupplier;
import com.aliyun.auth.credentials.utils.RefreshResult;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;

public abstract class HttpCredentialProvider
implements ICredentialProvider {
    private final boolean asyncCredentialUpdateEnabled;
    private Optional<RefreshCachedSupplier<ICredential>> credentialsCache;

    protected HttpCredentialProvider(BuilderImpl<?, ?> builder) {
        this.asyncCredentialUpdateEnabled = ((BuilderImpl)builder).asyncCredentialUpdateEnabled;
    }

    protected void buildRefreshCache() {
        RefreshCachedSupplier.Builder cacheBuilder = RefreshCachedSupplier.builder(this::refreshCredentials);
        if (this.asyncCredentialUpdateEnabled) {
            cacheBuilder.prefetchStrategy(new NonBlocking());
        }
        this.credentialsCache = Optional.of(cacheBuilder.build());
    }

    public abstract RefreshResult<ICredential> refreshCredentials();

    public Instant getStaleTime(Instant expiration) {
        return expiration == null ? null : expiration.minus(Duration.ofMinutes(1L));
    }

    public Instant getPrefetchTime(Instant expiration) {
        Instant oneHourFromNow = Instant.now().plus(Duration.ofHours(1L));
        if (expiration == null) {
            return oneHourFromNow;
        }
        Instant prefetchTime = expiration.minus(Duration.ofMinutes(15L));
        return oneHourFromNow.isAfter(prefetchTime) ? prefetchTime : oneHourFromNow;
    }

    @Override
    public ICredential getCredentials() {
        return this.credentialsCache.map(RefreshCachedSupplier::get).orElseThrow(() -> new CredentialException("Unable to get credentials"));
    }

    public void close() {
        this.credentialsCache.ifPresent(RefreshCachedSupplier::close);
    }

    protected static abstract class BuilderImpl<ProviderT extends HttpCredentialProvider, BuilderT extends Builder>
    implements Builder<ProviderT, BuilderT> {
        private boolean asyncCredentialUpdateEnabled = false;

        protected BuilderImpl() {
        }

        @Override
        public BuilderT asyncCredentialUpdateEnabled(Boolean asyncCredentialUpdateEnabled) {
            this.asyncCredentialUpdateEnabled = asyncCredentialUpdateEnabled;
            return (BuilderT)this;
        }
    }

    public static interface Builder<ProviderT extends HttpCredentialProvider, BuilderT extends Builder> {
        public BuilderT asyncCredentialUpdateEnabled(Boolean var1);

        public ProviderT build();
    }
}

