/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.auth.credentials.provider;

import com.aliyun.auth.credentials.Credential;
import com.aliyun.auth.credentials.ICredential;
import com.aliyun.auth.credentials.exception.CredentialException;
import com.aliyun.auth.credentials.provider.ICredentialProvider;
import com.aliyun.auth.credentials.utils.AuthUtils;
import com.aliyun.core.utils.StringUtils;

public class EnvironmentVariableCredentialProvider
implements ICredentialProvider {
    public static EnvironmentVariableCredentialProvider create() {
        return new EnvironmentVariableCredentialProvider();
    }

    @Override
    public ICredential getCredentials() {
        String accessKeyId = AuthUtils.getEnvironmentAccessKeyId();
        String accessKeySecret = AuthUtils.getEnvironmentAccessKeySecret();
        String securityToken = AuthUtils.getEnvironmentSecurityToken();
        if (StringUtils.isEmpty((CharSequence)accessKeyId) || StringUtils.isEmpty((CharSequence)accessKeySecret)) {
            throw new CredentialException("Environment variable accessKeyId/accessKeySecret cannot be empty");
        }
        if (!StringUtils.isEmpty((CharSequence)securityToken)) {
            return Credential.builder().accessKeyId(accessKeyId).accessKeySecret(accessKeySecret).securityToken(securityToken).build();
        }
        return Credential.builder().accessKeyId(accessKeyId).accessKeySecret(accessKeySecret).build();
    }

    public void close() {
    }
}

