/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encryptionsdk.stream;

import com.aliyun.encryptionsdk.handler.AlgorithmHandler;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class CryptoInputStream
extends InputStream {
    private InputStream inputStream;
    private AlgorithmHandler handler;
    private int encryptBlock;
    private boolean done = false;
    private ByteBuffer outByteBuffer = ByteBuffer.allocate(0);

    public CryptoInputStream(InputStream inputStream, AlgorithmHandler handler, int encryptBlock) {
        this.inputStream = inputStream;
        this.handler = handler;
        this.encryptBlock = encryptBlock;
    }

    private int processBytes() throws IOException {
        if (this.done) {
            return -1;
        }
        byte[] readBytes = new byte[this.encryptBlock];
        int readLen = this.inputStream.read(readBytes);
        if (readLen <= 0) {
            this.done = true;
            byte[] finalBytes = this.handler.doFinal();
            this.outByteBuffer = ByteBuffer.wrap(finalBytes);
        } else {
            byte[] processBytes = this.handler.update(readBytes, 0, readLen);
            this.outByteBuffer = processBytes == null ? ByteBuffer.allocate(0) : ByteBuffer.wrap(processBytes);
        }
        return this.outByteBuffer.capacity();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.outByteBuffer.hasRemaining()) {
            int readLen = 0;
            while (readLen == 0) {
                readLen = this.processBytes();
            }
            if (readLen < 0) {
                return -1;
            }
        }
        int copyLen = Math.min(len, this.outByteBuffer.remaining());
        this.outByteBuffer.get(b, 0, copyLen);
        return copyLen;
    }

    @Override
    public int read() throws IOException {
        if (!this.outByteBuffer.hasRemaining()) {
            int readLen = 0;
            while (readLen == 0) {
                readLen = this.processBytes();
            }
            if (readLen < 0) {
                return -1;
            }
        }
        return this.outByteBuffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }
}

