/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encryptionsdk.stream;

import com.aliyun.encryptionsdk.exception.AliyunException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CopyStreamUtil {
    private static final int MAX_READ_BYTES = 1024;

    private CopyStreamUtil() {
    }

    public static void copyIsToOs(InputStream inputStream, OutputStream outputStream) {
        try {
            int readLen;
            byte[] readBytes = new byte[1024];
            while ((readLen = inputStream.read(readBytes)) != -1) {
                outputStream.write(readBytes, 0, readLen);
            }
            inputStream.close();
            outputStream.close();
        }
        catch (IOException e) {
            throw new AliyunException(e);
        }
    }

    public static byte[] intToBytes(int data) {
        return new byte[]{(byte)(data & 0xFF), (byte)(data >> 8 & 0xFF), (byte)(data >> 16 & 0xFF), (byte)(data >> 24 & 0xFF)};
    }

    public static int bytesToInt(byte[] bytes) {
        return bytes[0] & 0xFF | (bytes[1] & 0xFF) << 8 | (bytes[2] & 0xFF) << 16 | (bytes[3] & 0xFF) << 24;
    }
}

