/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encryptionsdk.provider.dataKey;

import com.aliyun.encryptionsdk.exception.AliyunException;
import com.aliyun.encryptionsdk.model.CipherBody;
import com.aliyun.encryptionsdk.model.CipherHeader;
import com.aliyun.encryptionsdk.model.CipherMaterial;
import com.aliyun.encryptionsdk.model.CryptoAlgorithm;
import com.aliyun.encryptionsdk.provider.BaseDataKeyProvider;
import com.aliyun.encryptionsdk.stream.CopyStreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DefaultDataKeyProvider
extends BaseDataKeyProvider {
    public DefaultDataKeyProvider(String keyId) {
        super(keyId);
    }

    public DefaultDataKeyProvider(String keyId, CryptoAlgorithm algorithm) {
        super(keyId, algorithm);
    }

    @Override
    public CipherMaterial getCipherMaterial(byte[] cipherText) {
        return this.handler.deserialize(cipherText);
    }

    @Override
    public CipherMaterial getCipherMaterial(InputStream inputStream) {
        try {
            CipherHeader cipherHeader = new CipherHeader();
            cipherHeader.deserialize(inputStream);
            byte[] ivLen = new byte[4];
            inputStream.read(ivLen);
            byte[] iv = new byte[CopyStreamUtil.bytesToInt(ivLen)];
            inputStream.read(iv);
            CipherBody cipherBody = new CipherBody(iv, null);
            return new CipherMaterial(cipherHeader, cipherBody);
        }
        catch (IOException e) {
            throw new AliyunException("Failed to get CipherMaterial from InputStream", e);
        }
    }

    @Override
    public byte[] processCipherMaterial(CipherMaterial cipherMaterial) {
        return this.handler.serialize(cipherMaterial);
    }

    @Override
    public void writeCipherHeader(CipherHeader cipherHeader, OutputStream outputStream) {
        byte[] serializeBytes = cipherHeader.serialize();
        try {
            outputStream.write(serializeBytes);
            outputStream.flush();
        }
        catch (IOException e) {
            throw new AliyunException("Failed to write CipherHeader to OutputStream", e);
        }
    }
}

