/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encryptionsdk.model;

import com.aliyun.encryptionsdk.exception.InvalidArgumentException;
import com.aliyuncs.utils.StringUtils;
import java.util.Objects;

public class CmkId {
    public static final String PREFIX = "acs:";
    private String keyId;
    private String region;
    private String rawKeyId;
    private boolean isArn = false;

    public CmkId(String keyId) {
        if (StringUtils.isEmpty((CharSequence)keyId)) {
            throw new InvalidArgumentException("keyId cannot be empty");
        }
        this.keyId = keyId;
        if (keyId.startsWith(PREFIX)) {
            this.parsingKeyId(keyId);
        }
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getRegion() {
        return this.region;
    }

    public String getRawKeyId() {
        return this.rawKeyId;
    }

    public boolean isArn() {
        return this.isArn;
    }

    private void parsingKeyId(String keyId) {
        String[] strArr = keyId.split(":");
        if (strArr.length != 5) {
            throw new InvalidArgumentException("ARN parsing error, ARN format would be 'acs:kms:<region>:<uid>:key/<cmkid>'");
        }
        if (!"acs".equals(strArr[0])) {
            throw new InvalidArgumentException("ARN must start with 'acs:'");
        }
        if (!"kms".equals(strArr[1])) {
            throw new InvalidArgumentException("ARN must specify service");
        }
        if (StringUtils.isEmpty((CharSequence)strArr[2])) {
            throw new InvalidArgumentException("ARN must specify region");
        }
        if (StringUtils.isEmpty((CharSequence)strArr[3])) {
            throw new InvalidArgumentException("ARN must specify user id");
        }
        if (StringUtils.isEmpty((CharSequence)strArr[4])) {
            throw new InvalidArgumentException("ARN must specify resource");
        }
        if (!strArr[4].startsWith("key/")) {
            throw new InvalidArgumentException("ARN resource type must be 'key'");
        }
        this.region = strArr[2];
        this.rawKeyId = strArr[4].substring(strArr[4].indexOf("/") + 1);
        this.isArn = true;
    }

    public boolean isCommonRegion(CmkId cmkId) {
        if (!StringUtils.isEmpty((CharSequence)this.region) && !StringUtils.isEmpty((CharSequence)cmkId.getRegion())) {
            return this.region.equalsIgnoreCase(cmkId.getRegion());
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CmkId cmkId = (CmkId)o;
        return this.keyId.equals(cmkId.keyId);
    }

    public int hashCode() {
        return Objects.hash(this.keyId);
    }
}

