/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encryptionsdk.model;

import com.aliyun.encryptionsdk.exception.AliyunException;
import com.aliyun.encryptionsdk.handler.AlgorithmHandler;
import com.aliyun.encryptionsdk.model.CryptoAlgorithm;
import com.aliyun.encryptionsdk.model.EncryptedDataKey;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class CipherHeader {
    private int version;
    private CryptoAlgorithm algorithm;
    private Map<String, String> encryptionContext;
    private byte[] encryptionContextBytes;
    private List<EncryptedDataKey> encryptedDataKeys;
    private byte[] headerIv;
    private byte[] headerAuthTag;
    public static int HEADER_IV_LEN = 12;

    public CipherHeader(List<EncryptedDataKey> encryptedDataKeys, Map<String, String> encryptionContext, CryptoAlgorithm algorithm) {
        this.version = 1;
        this.encryptedDataKeys = encryptedDataKeys;
        this.encryptionContext = encryptionContext;
        this.serializeContext();
        this.algorithm = algorithm;
    }

    public CipherHeader(List<EncryptedDataKey> encryptedDataKeys, Map<String, String> encryptionContext, CryptoAlgorithm algorithm, byte[] headerIv, byte[] headerAuthTag) {
        this.version = 1;
        this.encryptedDataKeys = encryptedDataKeys;
        this.encryptionContext = encryptionContext;
        this.serializeContext();
        this.algorithm = algorithm;
        this.headerIv = headerIv;
        this.headerAuthTag = headerAuthTag;
    }

    public CipherHeader(int version, List<EncryptedDataKey> encryptedDataKeys, Map<String, String> encryptionContext, CryptoAlgorithm algorithm) {
        this.version = version;
        this.encryptedDataKeys = encryptedDataKeys;
        this.encryptionContext = encryptionContext;
        this.serializeContext();
        this.algorithm = algorithm;
    }

    public CipherHeader(int version, List<EncryptedDataKey> encryptedDataKeys, Map<String, String> encryptionContext, CryptoAlgorithm algorithm, byte[] headerIv, byte[] headerAuthTag) {
        this.version = version;
        this.encryptedDataKeys = encryptedDataKeys;
        this.encryptionContext = encryptionContext;
        this.serializeContext();
        this.algorithm = algorithm;
        this.headerIv = headerIv;
        this.headerAuthTag = headerAuthTag;
    }

    public CipherHeader() {
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public void setHeaderIv(byte[] headerIv) {
        this.headerIv = headerIv;
    }

    public void setAlgorithm(CryptoAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public List<EncryptedDataKey> getEncryptedDataKeys() {
        return this.encryptedDataKeys;
    }

    public Map<String, String> getEncryptionContext() {
        return this.encryptionContext;
    }

    public byte[] getEncryptionContextBytes() {
        return this.encryptionContextBytes;
    }

    public CryptoAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getHeaderIv() {
        return this.headerIv;
    }

    public byte[] getHeaderAuthTag() {
        return this.headerAuthTag;
    }

    public void calculateHeaderAuthTag(AlgorithmHandler handler) {
        byte[] headerFieldsBytes = this.serializeAuthenticatedFields();
        byte[] headerIv = new byte[HEADER_IV_LEN];
        SecureRandom random = new SecureRandom();
        random.nextBytes(headerIv);
        byte[] headerAuthTag = handler.headerGcmEncrypt(headerIv, headerFieldsBytes, new byte[0], 0, 0);
        this.headerIv = headerIv;
        this.headerAuthTag = headerAuthTag;
    }

    public boolean verifyHeaderAuthTag(AlgorithmHandler handler) {
        try {
            byte[] headerAuthTagCalc = handler.headerGcmEncrypt(this.headerIv, this.serializeAuthenticatedFields(), new byte[0], 0, 0);
            if (headerAuthTagCalc == null) {
                return false;
            }
            return Arrays.equals(this.headerAuthTag, headerAuthTagCalc);
        }
        catch (Exception e) {
            return false;
        }
    }

    public byte[] serializeAuthenticatedFields() {
        try {
            ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(outBytes);
            dataStream.writeInt(this.version);
            dataStream.writeInt(this.algorithm.getValue());
            dataStream.writeInt(this.encryptionContext.size());
            dataStream.write(this.encryptionContextBytes);
            dataStream.writeInt(this.encryptedDataKeys.size());
            TreeSet<EncryptedDataKey> set = new TreeSet<EncryptedDataKey>(this.encryptedDataKeys);
            for (EncryptedDataKey dataKey : set) {
                dataStream.write(dataKey.toByteArray());
            }
            dataStream.close();
            return outBytes.toByteArray();
        }
        catch (IOException e) {
            throw new AliyunException("Failed to serialize cipher text headers", e);
        }
    }

    public byte[] serialize() {
        try {
            ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(outBytes);
            dataStream.writeInt(this.version);
            dataStream.writeInt(this.algorithm.getValue());
            dataStream.writeInt(this.encryptionContextBytes.length);
            dataStream.write(this.encryptionContextBytes);
            dataStream.writeInt(this.encryptedDataKeys.size());
            TreeSet<EncryptedDataKey> set = new TreeSet<EncryptedDataKey>(this.encryptedDataKeys);
            for (EncryptedDataKey dataKey : set) {
                dataStream.write(dataKey.toByteArray());
            }
            dataStream.writeInt(this.headerIv.length);
            dataStream.write(this.headerIv);
            dataStream.writeInt(this.headerAuthTag.length);
            dataStream.write(this.headerAuthTag);
            dataStream.close();
            return outBytes.toByteArray();
        }
        catch (IOException e) {
            throw new AliyunException("Failed to serialize cipher text headers", e);
        }
    }

    public void deserialize(InputStream inputStream) throws IOException {
        DataInputStream dataStream = new DataInputStream(inputStream);
        this.version = dataStream.readInt();
        this.algorithm = CryptoAlgorithm.getAlgorithm(dataStream.readInt());
        int encryptionContextBytesLen = dataStream.readInt();
        this.encryptionContextBytes = new byte[encryptionContextBytesLen];
        dataStream.read(this.encryptionContextBytes);
        this.deserializeContext();
        int dataKeySize = dataStream.readInt();
        this.encryptedDataKeys = new ArrayList<EncryptedDataKey>();
        for (int i = 0; i < dataKeySize; ++i) {
            int keyIdLen = dataStream.readInt();
            byte[] keyIdBytes = new byte[keyIdLen];
            dataStream.read(keyIdBytes);
            int dataKeyLen = dataStream.readInt();
            byte[] dataKeyBytes = new byte[dataKeyLen];
            dataStream.read(dataKeyBytes);
            this.encryptedDataKeys.add(new EncryptedDataKey(keyIdBytes, dataKeyBytes));
        }
        int headerIvLen = dataStream.readInt();
        this.headerIv = new byte[headerIvLen];
        dataStream.read(this.headerIv);
        int headerAuthTagLen = dataStream.readInt();
        this.headerAuthTag = new byte[headerAuthTagLen];
        dataStream.read(this.headerAuthTag);
    }

    private void serializeContext() {
        if (this.encryptionContext.size() == 0) {
            this.encryptionContextBytes = new byte[0];
            return;
        }
        TreeMap<String, String> map = new TreeMap<String, String>((o1, o2) -> {
            byte[] o1bytes = o1.getBytes(StandardCharsets.UTF_8);
            byte[] o2bytes = o2.getBytes(StandardCharsets.UTF_8);
            int len = Math.min(o1bytes.length, o2bytes.length);
            for (int i = 0; i < len; ++i) {
                int b1 = o1bytes[i] & 0xFF;
                int b2 = o2bytes[i] & 0xFF;
                if (b1 == b2) continue;
                return b1 - b2;
            }
            return o1bytes.length - o2bytes.length;
        });
        map.putAll(this.encryptionContext);
        ByteBuffer result = ByteBuffer.allocate(Short.MAX_VALUE);
        result.order(ByteOrder.BIG_ENDIAN);
        result.putInt(this.encryptionContext.size());
        try {
            for (Map.Entry mapEntry : map.entrySet()) {
                byte[] keyBytes = ((String)mapEntry.getKey()).getBytes(StandardCharsets.UTF_8);
                result.putInt(keyBytes.length);
                result.put(keyBytes);
                byte[] valueBytes = ((String)mapEntry.getValue()).getBytes(StandardCharsets.UTF_8);
                result.putInt(valueBytes.length);
                result.put(valueBytes);
            }
        }
        catch (BufferUnderflowException e) {
            throw new AliyunException("encryptionContext must be shorter than 32767", e);
        }
        result.flip();
        this.encryptionContextBytes = new byte[result.limit()];
        result.get(this.encryptionContextBytes);
    }

    private void deserializeContext() {
        if (this.encryptionContextBytes.length == 0) {
            this.encryptionContext = Collections.emptyMap();
            return;
        }
        ByteBuffer contextBytes = ByteBuffer.wrap(this.encryptionContextBytes);
        contextBytes.order(ByteOrder.BIG_ENDIAN);
        int encryptionContextSize = contextBytes.getInt();
        this.encryptionContext = new HashMap<String, String>();
        for (int i = 0; i < encryptionContextSize; ++i) {
            int keyLen = contextBytes.getInt();
            byte[] keyBytes = new byte[keyLen];
            contextBytes.get(keyBytes);
            int valueLen = contextBytes.getInt();
            byte[] valueBytes = new byte[valueLen];
            contextBytes.get(valueBytes);
            this.encryptionContext.put(new String(keyBytes, StandardCharsets.UTF_8), new String(valueBytes, StandardCharsets.UTF_8));
        }
    }
}

