/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encryptionsdk.kms;

import com.aliyun.encryptionsdk.AliyunConfig;
import com.aliyun.encryptionsdk.exception.AliyunException;
import com.aliyun.encryptionsdk.kms.AliyunKms;
import com.aliyun.encryptionsdk.kms.AliyunKmsClientFactory;
import com.aliyun.encryptionsdk.kms.BackoffUtils;
import com.aliyun.encryptionsdk.logger.CommonLogger;
import com.aliyun.encryptionsdk.model.CmkId;
import com.aliyun.encryptionsdk.model.CryptoAlgorithm;
import com.aliyun.encryptionsdk.model.EncryptedDataKey;
import com.aliyun.encryptionsdk.model.SignatureAlgorithm;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.AcsResponse;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.kms.model.v20160120.AsymmetricSignRequest;
import com.aliyuncs.kms.model.v20160120.AsymmetricSignResponse;
import com.aliyuncs.kms.model.v20160120.AsymmetricVerifyRequest;
import com.aliyuncs.kms.model.v20160120.AsymmetricVerifyResponse;
import com.aliyuncs.kms.model.v20160120.CreateSecretRequest;
import com.aliyuncs.kms.model.v20160120.CreateSecretResponse;
import com.aliyuncs.kms.model.v20160120.DecryptRequest;
import com.aliyuncs.kms.model.v20160120.DecryptResponse;
import com.aliyuncs.kms.model.v20160120.EncryptRequest;
import com.aliyuncs.kms.model.v20160120.EncryptResponse;
import com.aliyuncs.kms.model.v20160120.GenerateDataKeyRequest;
import com.aliyuncs.kms.model.v20160120.GenerateDataKeyResponse;
import com.aliyuncs.kms.model.v20160120.GetPublicKeyRequest;
import com.aliyuncs.kms.model.v20160120.GetPublicKeyResponse;
import com.aliyuncs.kms.model.v20160120.GetSecretValueRequest;
import com.aliyuncs.kms.model.v20160120.GetSecretValueResponse;
import com.aliyuncs.kms.model.v20160120.ReEncryptRequest;
import com.aliyuncs.kms.model.v20160120.ReEncryptResponse;
import com.aliyuncs.utils.StringUtils;
import com.google.gson.Gson;
import java.util.Base64;
import java.util.Map;

public class DefaultAliyunKms
implements AliyunKms {
    private AliyunConfig config;

    public DefaultAliyunKms(AliyunConfig config) {
        this.config = config;
    }

    @Override
    public AliyunKms.GenerateDataKeyResult generateDataKey(CmkId keyId, CryptoAlgorithm algorithm, Map<String, String> context) {
        GenerateDataKeyRequest request = new GenerateDataKeyRequest();
        request.setKeyId(keyId.getRawKeyId());
        if (algorithm.getKeySpec().equals("SM4_128")) {
            request.setNumberOfBytes(Integer.valueOf(16));
        } else {
            request.setKeySpec(algorithm.getKeySpec());
        }
        request.setKeySpec(algorithm.getKeySpec());
        Gson gson = new Gson();
        request.setEncryptionContext(context.isEmpty() ? null : gson.toJson(context));
        GenerateDataKeyResponse response = this.getResult((Class)GenerateDataKeyResponse.class, (AcsRequest)request, keyId);
        return new AliyunKms.GenerateDataKeyResult(keyId.getKeyId(), response.getKeyVersionId(), response.getPlaintext(), response.getCiphertextBlob());
    }

    @Override
    public AliyunKms.DecryptDataKeyResult decryptDataKey(EncryptedDataKey encryptedDataKey, Map<String, String> context) {
        DecryptRequest request = new DecryptRequest();
        request.setCiphertextBlob(encryptedDataKey.getDataKeyString());
        Gson gson = new Gson();
        request.setEncryptionContext(context.isEmpty() ? null : gson.toJson(context));
        DecryptResponse response = this.getResult((Class)DecryptResponse.class, (AcsRequest)request, new CmkId(encryptedDataKey.getKeyIdString()));
        return new AliyunKms.DecryptDataKeyResult(response.getKeyId(), response.getKeyVersionId(), response.getPlaintext());
    }

    @Override
    public EncryptedDataKey encryptDataKey(CmkId keyId, String plaintext, Map<String, String> context) {
        EncryptRequest request = new EncryptRequest();
        request.setKeyId(keyId.getRawKeyId());
        request.setPlaintext(plaintext);
        Gson gson = new Gson();
        request.setEncryptionContext(context.isEmpty() ? null : gson.toJson(context));
        EncryptResponse response = this.getResult((Class)EncryptResponse.class, (AcsRequest)request, keyId);
        return new EncryptedDataKey(keyId.getKeyId(), response.getCiphertextBlob());
    }

    @Override
    public EncryptedDataKey reEncryptDataKey(CmkId keyId, EncryptedDataKey encryptedDataKey, Map<String, String> context) {
        ReEncryptRequest request = new ReEncryptRequest();
        request.setCiphertextBlob(encryptedDataKey.getDataKeyString());
        Gson gson = new Gson();
        request.setSourceEncryptionContext(context.isEmpty() ? null : gson.toJson(context));
        request.setDestinationKeyId(keyId.getRawKeyId());
        request.setDestinationEncryptionContext(context.isEmpty() ? null : gson.toJson(context));
        ReEncryptResponse response = this.getResult((Class)ReEncryptResponse.class, (AcsRequest)request, new CmkId(encryptedDataKey.getKeyIdString()));
        return new EncryptedDataKey(keyId.getKeyId(), response.getCiphertextBlob());
    }

    @Override
    public AliyunKms.AsymmetricSignResult asymmetricSign(CmkId keyId, String keyVersionId, SignatureAlgorithm algorithm, byte[] digest) {
        AsymmetricSignRequest req = new AsymmetricSignRequest();
        String base64Digest = Base64.getEncoder().encodeToString(digest);
        req.setAcceptFormat(FormatType.JSON);
        req.setKeyId(keyId.getRawKeyId());
        req.setKeyVersionId(keyVersionId);
        req.setAlgorithm(algorithm.getAlgorithm());
        req.setDigest(base64Digest);
        AsymmetricSignResponse response = this.getResult((Class)AsymmetricSignResponse.class, (AcsRequest)req, keyId);
        return new AliyunKms.AsymmetricSignResult(response.getKeyId(), response.getKeyVersionId(), response.getValue());
    }

    @Override
    public AliyunKms.AsymmetricVerifyResult asymmetricVerify(CmkId keyId, String keyVersionId, SignatureAlgorithm algorithm, byte[] digest, byte[] signature) {
        AsymmetricVerifyRequest req = new AsymmetricVerifyRequest();
        String base64Digest = Base64.getEncoder().encodeToString(digest);
        String base64Signature = Base64.getEncoder().encodeToString(signature);
        req.setAcceptFormat(FormatType.JSON);
        req.setKeyId(keyId.getRawKeyId());
        req.setKeyVersionId(keyVersionId);
        req.setAlgorithm(algorithm.getAlgorithm());
        req.setDigest(base64Digest);
        req.setValue(base64Signature);
        AsymmetricVerifyResponse response = this.getResult((Class)AsymmetricVerifyResponse.class, (AcsRequest)req, keyId);
        return new AliyunKms.AsymmetricVerifyResult(response.getKeyId(), response.getKeyVersionId(), response.getValue());
    }

    @Override
    public AliyunKms.CreateSecretResult createSecret(CmkId keyId, String secretName, String versionId, String secretData, String secretDataType) {
        CreateSecretRequest request = new CreateSecretRequest();
        request.setVersionId(versionId);
        request.setEncryptionKeyId(keyId.getRawKeyId());
        request.setSecretName(secretName);
        request.setSecretData(secretData);
        request.setSecretDataType(secretDataType);
        CreateSecretResponse response = this.getResult((Class)CreateSecretResponse.class, (AcsRequest)request, keyId);
        return new AliyunKms.CreateSecretResult(response.getArn(), response.getSecretName(), response.getVersionId());
    }

    @Override
    public AliyunKms.GetSecretValueResult getSecretValue(CmkId keyId, String secretName) {
        GetSecretValueRequest request = new GetSecretValueRequest();
        request.setSecretName(secretName);
        GetSecretValueResponse response = this.getResult((Class)GetSecretValueResponse.class, (AcsRequest)request, keyId);
        return new AliyunKms.GetSecretValueResult(response.getSecretName(), response.getSecretData(), response.getSecretDataType());
    }

    @Override
    public AliyunKms.GetSecretValueResult getSecretValue(CmkId keyId, String secretName, String versionId) {
        GetSecretValueRequest request = new GetSecretValueRequest();
        request.setSecretName(secretName);
        request.setVersionId(versionId);
        GetSecretValueResponse response = this.getResult((Class)GetSecretValueResponse.class, (AcsRequest)request, keyId);
        return new AliyunKms.GetSecretValueResult(response.getSecretName(), response.getSecretData(), response.getSecretDataType());
    }

    @Override
    public String getPublicKey(CmkId keyId, String keyVersionId) {
        GetPublicKeyRequest request = new GetPublicKeyRequest();
        request.setAcceptFormat(FormatType.JSON);
        request.setKeyId(keyId.getRawKeyId());
        request.setKeyVersionId(keyVersionId);
        GetPublicKeyResponse response = this.getResult((Class)GetPublicKeyResponse.class, (AcsRequest)request, keyId);
        return response.getPublicKey();
    }

    private <T extends AcsResponse> T getResult(Class<T> clz, AcsRequest<T> request, CmkId keyId) {
        if (StringUtils.isEmpty((CharSequence)keyId.getRegion())) {
            throw new AliyunException("region information not obtained");
        }
        IAcsClient client = AliyunKmsClientFactory.getClient(this.config, keyId.getRegion());
        int maxRetries = this.config.getMaxRetries();
        if (maxRetries <= 0) {
            maxRetries = 1;
        }
        for (int i = 0; i < maxRetries; ++i) {
            try {
                AcsResponse response = client.getAcsResponse(request);
                return (T)((AcsResponse)clz.cast(response));
            }
            catch (ClientException e) {
                CommonLogger.getCommonLogger("encryptionsdk").errorf("Request kms error", new Object[]{e});
                if (BackoffUtils.judgeNeedBackoff(e)) {
                    try {
                        Thread.sleep(this.config.getBackoffStrategy().getWaitTimeExponential(i + 1));
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                throw new AliyunException(e.getMessage(), e);
            }
        }
        CommonLogger.getCommonLogger("encryptionsdk").errorf("No results obtained after retrying " + maxRetries + " times", new Object[0]);
        throw new AliyunException("No results obtained after retrying " + maxRetries + " times");
    }
}

