/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encryptionsdk.kms;

import com.aliyun.encryptionsdk.model.CmkId;
import com.aliyun.encryptionsdk.model.CryptoAlgorithm;
import com.aliyun.encryptionsdk.model.EncryptedDataKey;
import com.aliyun.encryptionsdk.model.SignatureAlgorithm;
import java.util.Map;

public interface AliyunKms {
    public GenerateDataKeyResult generateDataKey(CmkId var1, CryptoAlgorithm var2, Map<String, String> var3);

    public DecryptDataKeyResult decryptDataKey(EncryptedDataKey var1, Map<String, String> var2);

    public EncryptedDataKey encryptDataKey(CmkId var1, String var2, Map<String, String> var3);

    public EncryptedDataKey reEncryptDataKey(CmkId var1, EncryptedDataKey var2, Map<String, String> var3);

    public AsymmetricSignResult asymmetricSign(CmkId var1, String var2, SignatureAlgorithm var3, byte[] var4);

    public AsymmetricVerifyResult asymmetricVerify(CmkId var1, String var2, SignatureAlgorithm var3, byte[] var4, byte[] var5);

    public String getPublicKey(CmkId var1, String var2);

    public CreateSecretResult createSecret(CmkId var1, String var2, String var3, String var4, String var5);

    public GetSecretValueResult getSecretValue(CmkId var1, String var2);

    public GetSecretValueResult getSecretValue(CmkId var1, String var2, String var3);

    public static class GetSecretValueResult {
        private String secretName;
        private String secretData;
        private String secretDataType;

        public GetSecretValueResult(String secretName, String secretData, String secretDataType) {
            this.secretName = secretName;
            this.secretData = secretData;
            this.secretDataType = secretDataType;
        }

        public String getSecretName() {
            return this.secretName;
        }

        public String getSecretData() {
            return this.secretData;
        }

        public String getSecretDataType() {
            return this.secretDataType;
        }
    }

    public static class CreateSecretResult {
        private String arn;
        private String secretName;
        private String versionId;

        public CreateSecretResult(String arn, String secretName, String versionId) {
            this.arn = arn;
            this.secretName = secretName;
            this.versionId = versionId;
        }

        public String getArn() {
            return this.arn;
        }

        public String getSecretName() {
            return this.secretName;
        }

        public String getVersionId() {
            return this.versionId;
        }
    }

    public static class AsymmetricVerifyResult
    extends BaseResult {
        private final Boolean value;

        public AsymmetricVerifyResult(String keyId, String keyVersionId, Boolean value) {
            super(keyId, keyVersionId);
            this.value = value;
        }

        public Boolean getValue() {
            return this.value;
        }
    }

    public static class AsymmetricSignResult
    extends BaseResult {
        private final String value;

        public AsymmetricSignResult(String keyId, String keyVersionId, String value) {
            super(keyId, keyVersionId);
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class DecryptDataKeyResult
    extends BaseResult {
        private String plaintext;

        public DecryptDataKeyResult(String keyId, String keyVersionId, String plaintext) {
            super(keyId, keyVersionId);
            this.plaintext = plaintext;
        }

        public String getPlaintext() {
            return this.plaintext;
        }
    }

    public static class GenerateDataKeyResult
    extends BaseResult {
        private String plaintext;
        private EncryptedDataKey encryptedDataKey;

        public GenerateDataKeyResult(String keyId, String keyVersionId, String plaintext, String cipherTextBlob) {
            super(keyId, keyVersionId);
            this.plaintext = plaintext;
            this.encryptedDataKey = new EncryptedDataKey(keyId, cipherTextBlob);
        }

        public String getPlaintext() {
            return this.plaintext;
        }

        public EncryptedDataKey getEncryptedDataKey() {
            return this.encryptedDataKey;
        }
    }

    public static class BaseResult {
        private String keyId;
        private String keyVersionId;

        public BaseResult(String keyId, String keyVersionId) {
            this.keyId = keyId;
            this.keyVersionId = keyVersionId;
        }

        public String getKeyId() {
            return this.keyId;
        }

        public String getKeyVersionId() {
            return this.keyVersionId;
        }
    }
}

