/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encryptionsdk.handler;

import com.aliyun.encryptionsdk.exception.InvalidAlgorithmException;
import com.aliyun.encryptionsdk.exception.SecurityProcessException;
import com.aliyun.encryptionsdk.logger.CommonLogger;
import com.aliyun.encryptionsdk.model.CipherHeader;
import com.aliyun.encryptionsdk.model.CryptoAlgorithm;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AlgorithmHandler {
    private int mode;
    private Cipher cipher;
    private CryptoAlgorithm algorithm;
    private SecretKey keySpec;
    private boolean initialized = false;

    public AlgorithmHandler(CryptoAlgorithm algorithm, SecretKey keySpec, int mode) {
        try {
            this.cipher = Cipher.getInstance(algorithm.getCryptoName(), "BC");
        }
        catch (Exception e) {
            CommonLogger.getCommonLogger("encryptionsdk").errorf("Invalid algorithm: " + algorithm.getCryptoName(), e);
            throw new InvalidAlgorithmException("Invalid algorithm: " + algorithm.getCryptoName(), e);
        }
        this.algorithm = algorithm;
        this.keySpec = keySpec;
        this.mode = mode;
    }

    public CryptoAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public void cipherInit(byte[] iv) {
        if (iv != null && iv.length != this.algorithm.getIvLen()) {
            throw new IllegalArgumentException("Invalid iv length: " + iv.length);
        }
        AlgorithmParameterSpec spec = this.algorithm.getSpec(iv);
        try {
            if (spec == null) {
                this.cipher.init(this.mode, this.keySpec);
            } else {
                this.cipher.init(this.mode, (Key)this.keySpec, spec);
            }
            this.initialized = true;
        }
        catch (Exception e) {
            CommonLogger.getCommonLogger("encryptionsdk").errorf(this.algorithm.getCryptoName() + " init failed", e);
            throw new SecurityProcessException(this.algorithm.getCryptoName() + " init failed", e);
        }
    }

    public byte[] cipherData(byte[] iv, byte[] contentAad, byte[] content, int off, int len) {
        try {
            this.cipherInit(iv);
            if (contentAad != null && this.algorithm.isWithAad()) {
                this.cipher.updateAAD(contentAad);
            }
            return this.cipher.doFinal(content, off, len);
        }
        catch (Exception e) {
            CommonLogger.getCommonLogger("encryptionsdk").errorf("Failed to obtain " + this.algorithm.getCryptoName() + " cipher result", e);
            throw new SecurityProcessException("Failed to obtain " + this.algorithm.getCryptoName() + " cipher result", e);
        }
    }

    public void updateAAD(byte[] contentAad) {
        this.cipher.updateAAD(contentAad);
    }

    public byte[] update(byte[] content, int off, int len) {
        if (this.initialized) {
            return this.cipher.update(content, off, len);
        }
        CommonLogger.getCommonLogger("encryptionsdk").errorf("cipher is not initialized", new Object[0]);
        throw new SecurityProcessException("cipher is not initialized");
    }

    public byte[] doFinal() {
        if (this.initialized) {
            try {
                return this.cipher.doFinal();
            }
            catch (Exception e) {
                CommonLogger.getCommonLogger("encryptionsdk").errorf(this.algorithm.getCryptoName() + " doFinal failed", e);
                throw new SecurityProcessException(this.algorithm.getCryptoName() + " doFinal failed", e);
            }
        }
        CommonLogger.getCommonLogger("encryptionsdk").errorf("cipher is not initialized", new Object[0]);
        throw new SecurityProcessException("cipher is not initialized");
    }

    public byte[] headerGcmEncrypt(byte[] iv, byte[] contentAad, byte[] content, int off, int len) {
        try {
            Cipher gcmCipher = this.algorithm.getKeyName().equals("SM4") ? Cipher.getInstance("SM4/GCM/NoPadding", "BC") : Cipher.getInstance("AES/GCM/NoPadding", "BC");
            if (iv.length != CipherHeader.HEADER_IV_LEN) {
                throw new IllegalArgumentException("Invalid iv length: " + iv.length);
            }
            GCMParameterSpec spec = new GCMParameterSpec(this.algorithm.getBlockSize() * 8, iv);
            gcmCipher.init(1, (Key)this.keySpec, spec);
            if (contentAad != null) {
                gcmCipher.updateAAD(contentAad);
            }
            return gcmCipher.doFinal(content, off, len);
        }
        catch (Exception e) {
            CommonLogger.getCommonLogger("encryptionsdk").errorf("Failed to obtain " + this.algorithm.getCryptoName() + " cipher result", e);
            throw new SecurityProcessException("Failed to obtain " + this.algorithm.getCryptoName() + " cipher result", e);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

