/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encryptionsdk.cache;

import com.aliyun.encryptionsdk.cache.DataKeyCache;
import com.aliyun.encryptionsdk.model.DecryptionMaterial;
import com.aliyun.encryptionsdk.model.EncryptionMaterial;
import java.util.LinkedHashMap;
import java.util.TreeSet;

public class LocalDataKeyMaterialCache
implements DataKeyCache {
    private static final int DEFAULT_CAPACITY = 10;
    private LinkedHashMap<String, BaseEntry> cacheMap = new LinkedHashMap(16, 0.75f, true);
    private TreeSet<BaseEntry> sortMap = new TreeSet();
    private final int capacity;

    public LocalDataKeyMaterialCache() {
        this.capacity = 10;
    }

    public LocalDataKeyMaterialCache(int capacity) {
        this.capacity = capacity;
    }

    private synchronized void removeEntry(BaseEntry entry) {
        this.cacheMap.remove(entry.key, entry);
        this.sortMap.remove(entry);
    }

    @Override
    public DataKeyCache.EncryptEntry getEncryptEntry(String key, DataKeyCache.UsageInfo usageInfo) {
        EncryptionEntry entry = (EncryptionEntry)this.getEntry(key);
        if (entry == null) {
            return null;
        }
        DataKeyCache.UsageInfo info = entry.addUsageInfo(usageInfo);
        return new EncryptionEntryExposed(entry, info);
    }

    @Override
    public void putEncryptEntry(String key, long survivalTime, EncryptionMaterial material, DataKeyCache.UsageInfo usageInfo) {
        EncryptionEntry encryptEntry = new EncryptionEntry(key, System.currentTimeMillis() + survivalTime, material, usageInfo);
        this.putEntry(encryptEntry);
    }

    @Override
    public DataKeyCache.DecryptEntry getDecryptEntry(String key) {
        return (DataKeyCache.DecryptEntry)((Object)this.getEntry(key));
    }

    @Override
    public void putDecryptEntry(String key, long survivalTime, DecryptionMaterial material) {
        DecryptionEntry entry = new DecryptionEntry(key, System.currentTimeMillis() + survivalTime, material);
        this.putEntry(entry);
    }

    private synchronized BaseEntry getEntry(String key) {
        BaseEntry entry = this.cacheMap.get(key);
        if (entry == null) {
            return null;
        }
        if (entry.isExpired()) {
            entry.expired();
            return null;
        }
        return entry;
    }

    private synchronized void putEntry(BaseEntry entry) {
        BaseEntry oldEntry = this.cacheMap.put(entry.key, entry);
        if (oldEntry != null) {
            this.removeEntry(oldEntry);
        }
        this.sortMap.add(entry);
        this.checkCapacity();
    }

    private synchronized void checkCapacity() {
        this.eliminate();
        while (this.cacheMap.size() > this.capacity) {
            this.removeEntry(this.cacheMap.values().iterator().next());
        }
    }

    private void eliminate() {
        while (!this.sortMap.isEmpty() && this.sortMap.first().expireTime < System.currentTimeMillis()) {
            this.removeEntry(this.sortMap.first());
        }
    }

    private class DecryptionEntry
    extends BaseEntry
    implements DataKeyCache.DecryptEntry {
        private DecryptionMaterial material;

        public DecryptionEntry(String key, long expireTime, DecryptionMaterial material) {
            super(key, expireTime);
            this.material = material;
        }

        @Override
        public String getCacheId() {
            return this.getKey();
        }

        @Override
        public DecryptionMaterial getMaterial() {
            return this.material;
        }

        @Override
        public void invalid() {
            LocalDataKeyMaterialCache.this.removeEntry(this);
        }
    }

    private class EncryptionEntryExposed
    implements DataKeyCache.EncryptEntry {
        private EncryptionEntry entry;
        private DataKeyCache.UsageInfo usageInfo;

        private EncryptionEntryExposed(EncryptionEntry entry, DataKeyCache.UsageInfo usageInfo) {
            this.entry = entry;
            this.usageInfo = usageInfo;
        }

        @Override
        public String getCacheId() {
            return this.entry.getKey();
        }

        @Override
        public EncryptionMaterial getMaterial() {
            return this.entry.material;
        }

        @Override
        public DataKeyCache.UsageInfo getUsageInfo() {
            return this.usageInfo;
        }

        @Override
        public void invalid() {
            LocalDataKeyMaterialCache.this.removeEntry(this.entry);
        }
    }

    private class EncryptionEntry
    extends BaseEntry {
        private EncryptionMaterial material;
        private DataKeyCache.UsageInfo usageInfo;

        private EncryptionEntry(String key, long expireTime, EncryptionMaterial material, DataKeyCache.UsageInfo usageInfo) {
            super(key, expireTime);
            this.material = material;
            this.usageInfo = usageInfo;
        }

        synchronized DataKeyCache.UsageInfo addUsageInfo(DataKeyCache.UsageInfo usageInfo) {
            this.usageInfo = this.usageInfo.add(usageInfo);
            return this.usageInfo;
        }
    }

    private class BaseEntry
    implements Comparable<BaseEntry> {
        private String key;
        private long expireTime;
        private long createTime = System.currentTimeMillis();

        private BaseEntry(String key, long expireTime) {
            this.key = key;
            this.expireTime = expireTime;
        }

        public String getKey() {
            return this.key;
        }

        boolean isExpired() {
            return System.currentTimeMillis() > this.expireTime;
        }

        void expired() {
            LocalDataKeyMaterialCache.this.removeEntry(this);
        }

        @Override
        public int compareTo(BaseEntry o) {
            int num = Long.compare(this.expireTime, o.expireTime);
            return num == 0 ? Long.compare(this.createTime, o.createTime) : num;
        }
    }
}

