/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encryptionsdk;

import com.aliyun.encryptionsdk.kms.BackoffStrategy;
import com.aliyun.encryptionsdk.kms.FullJitterBackoffStrategy;
import com.aliyuncs.auth.AlibabaCloudCredentials;
import com.aliyuncs.auth.AlibabaCloudCredentialsProvider;
import com.aliyuncs.auth.BasicCredentials;
import com.aliyuncs.auth.BasicSessionCredentials;
import com.aliyuncs.auth.InstanceProfileCredentialsProvider;
import com.aliyuncs.auth.STSAssumeRoleSessionCredentialsProvider;
import com.aliyuncs.auth.StaticCredentialsProvider;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;

public class AliyunConfig {
    private static final int MAX_RETRIES = 5;
    private String region;
    private int maxRetries = 5;
    private BackoffStrategy backoffStrategy = new FullJitterBackoffStrategy(200L, 10000L);
    private AlibabaCloudCredentialsProvider provider;

    public AliyunConfig() {
    }

    public AliyunConfig(AlibabaCloudCredentialsProvider provider) {
        this.provider = provider;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public BackoffStrategy getBackoffStrategy() {
        return this.backoffStrategy;
    }

    public void setBackoffStrategy(BackoffStrategy backoffStrategy) {
        this.backoffStrategy = backoffStrategy;
    }

    public AlibabaCloudCredentialsProvider getProvider() {
        return this.provider;
    }

    public void setProvider(AlibabaCloudCredentialsProvider provider) {
        this.provider = provider;
    }

    public void withAccessKey(String accessKeyId, String accessKeySecret) {
        this.provider = new StaticCredentialsProvider((AlibabaCloudCredentials)new BasicCredentials(accessKeyId, accessKeySecret));
    }

    public void withToken(String stsAccessKeyId, String stsAccessKeySecret, String stsToken) {
        this.provider = new StaticCredentialsProvider((AlibabaCloudCredentials)new BasicSessionCredentials(stsAccessKeyId, stsAccessKeySecret, stsToken));
    }

    public void withRamRoleArnOrSts(String accessKeyId, String accessKeySecret, String regionId, String roleArn) {
        this.provider = new STSAssumeRoleSessionCredentialsProvider((AlibabaCloudCredentials)new BasicCredentials(accessKeyId, accessKeySecret), roleArn, (IClientProfile)DefaultProfile.getProfile((String)regionId));
    }

    public void withEcsRamRole(String roleName) {
        this.provider = new InstanceProfileCredentialsProvider(roleName);
    }
}

