/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encryptionsdk.ckm;

import com.aliyun.encryptionsdk.cache.DataKeyCache;
import com.aliyun.encryptionsdk.ckm.CryptoKeyManager;
import com.aliyun.encryptionsdk.exception.AliyunException;
import com.aliyun.encryptionsdk.exception.InvalidArgumentException;
import com.aliyun.encryptionsdk.logger.CommonLogger;
import com.aliyun.encryptionsdk.model.ContentType;
import com.aliyun.encryptionsdk.model.CryptoAlgorithm;
import com.aliyun.encryptionsdk.model.DecryptionMaterial;
import com.aliyun.encryptionsdk.model.EncryptedDataKey;
import com.aliyun.encryptionsdk.model.EncryptionMaterial;
import com.aliyun.encryptionsdk.model.SignatureMaterial;
import com.aliyun.encryptionsdk.model.VerifyMaterial;
import com.aliyun.encryptionsdk.provider.BaseDataKeyProvider;
import com.aliyun.encryptionsdk.provider.SignatureProvider;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class CachingCryptoKeyManager
implements CryptoKeyManager {
    private static final long MAX_TIME = 60000L;
    private static final long MAX_BYTE = Long.MAX_VALUE;
    private static final long MAX_MESSAGE = Long.MAX_VALUE;
    private DataKeyCache cache;
    private long maxSurvivalTime;
    private long maxEncryptionBytes;
    private long maxEncryptionMessages;

    public CachingCryptoKeyManager(DataKeyCache cache) {
        this.cache = cache;
        this.maxSurvivalTime = 60000L;
        this.maxEncryptionBytes = Long.MAX_VALUE;
        this.maxEncryptionMessages = Long.MAX_VALUE;
    }

    public long getMaxSurvivalTime() {
        return this.maxSurvivalTime;
    }

    public void setMaxSurvivalTime(long maxSurvivalTime) {
        if (maxSurvivalTime < 0L) {
            throw new InvalidArgumentException("maxSurvivalTime must be set to positive");
        }
        this.maxSurvivalTime = maxSurvivalTime;
    }

    public long getMaxEncryptionBytes() {
        return this.maxEncryptionBytes;
    }

    public void setMaxEncryptionBytes(long maxEncryptionBytes) {
        if (maxEncryptionBytes < 0L) {
            throw new InvalidArgumentException("maxEncryptionBytes must be set to positive");
        }
        this.maxEncryptionBytes = maxEncryptionBytes;
    }

    public long getMaxEncryptionMessages() {
        return this.maxEncryptionMessages;
    }

    public void setMaxEncryptionMessages(long maxEncryptionMessages) {
        if (maxEncryptionMessages < 0L) {
            throw new InvalidArgumentException("maxEncryptionMessages must be set to positive");
        }
        this.maxEncryptionMessages = maxEncryptionMessages;
    }

    @Override
    public EncryptionMaterial getEncryptDataKeyMaterial(BaseDataKeyProvider provider, Map<String, String> encryptionContext, long plaintextSize) {
        DataKeyCache.UsageInfo usageInfo;
        CommonLogger.getCommonLogger("encryptionsdk").infof("This encryption will enable caching", new Object[0]);
        EncryptionMaterial material = new EncryptionMaterial();
        material.setEncryptionContext(encryptionContext);
        material.setAlgorithm(provider.getAlgorithm());
        if (plaintextSize == -1L || plaintextSize > this.maxEncryptionBytes) {
            return provider.encryptDataKey(material);
        }
        String cacheId = this.getCacheId(provider.getAlgorithm(), encryptionContext);
        DataKeyCache.EncryptEntry entry = this.cache.getEncryptEntry(cacheId, usageInfo = new DataKeyCache.UsageInfo(plaintextSize, 1L));
        if (entry != null) {
            if (!this.isExceedMaxLimit(entry.getUsageInfo())) {
                DataKeyCache.UsageInfo nowUse = entry.getUsageInfo();
                CommonLogger.getCommonLogger("encryptionsdk").infof(String.format("This encryption hits the cache to obtain the encryptionMaterial[CacheId: %s, EncryptionBytes: Total(%d) Used(%d->%d), EncryptionMessages: Total(%d) Used(%d->%d)]", entry.getCacheId(), this.maxEncryptionBytes, nowUse.getEncryptedBytes() - plaintextSize, nowUse.getEncryptedBytes(), this.maxEncryptionMessages, nowUse.getEncryptedMessages() - 1L, nowUse.getEncryptedMessages()), new Object[0]);
                return entry.getMaterial();
            }
            entry.invalid();
        }
        CommonLogger.getCommonLogger("encryptionsdk").infof("This encryption misses the cache", new Object[0]);
        EncryptionMaterial result = provider.encryptDataKey(material);
        this.cache.putEncryptEntry(cacheId, this.maxSurvivalTime, result, usageInfo);
        CommonLogger.getCommonLogger("encryptionsdk").infof(String.format("Cache a encryptionMaterial[CacheId: %s]", cacheId), new Object[0]);
        return result;
    }

    private boolean isExceedMaxLimit(DataKeyCache.UsageInfo usageInfo) {
        return usageInfo.getEncryptedBytes() > this.maxEncryptionBytes || usageInfo.getEncryptedMessages() > this.maxEncryptionMessages;
    }

    private String getCacheId(CryptoAlgorithm algorithm, Map<String, String> encryptionContext) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA");
            this.digestAlgorithm(digest, algorithm);
            this.digestContext(digest, encryptionContext);
            return Base64.getEncoder().encodeToString(digest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new AliyunException("SHA MessageDigest not available", e);
        }
    }

    @Override
    public DecryptionMaterial getDecryptDataKeyMaterial(BaseDataKeyProvider provider, Map<String, String> encryptionContext, List<EncryptedDataKey> encryptedDataKeys) {
        CommonLogger.getCommonLogger("encryptionsdk").infof("This decryption will enable caching", new Object[0]);
        DecryptionMaterial material = new DecryptionMaterial();
        material.setEncryptionContext(encryptionContext);
        material.setAlgorithm(provider.getAlgorithm());
        String cacheId = this.getCacheId(provider.getAlgorithm(), encryptionContext, encryptedDataKeys);
        DataKeyCache.DecryptEntry entry = this.cache.getDecryptEntry(cacheId);
        if (entry != null) {
            CommonLogger.getCommonLogger("encryptionsdk").infof(String.format("This decryption hits the cache to obtain the decryptionMaterial[CacheId: %s]", entry.getCacheId()), new Object[0]);
            return entry.getMaterial();
        }
        CommonLogger.getCommonLogger("encryptionsdk").infof("This decryption misses the cache", new Object[0]);
        DecryptionMaterial result = provider.decryptDataKey(material, encryptedDataKeys);
        this.cache.putDecryptEntry(cacheId, this.maxSurvivalTime, result);
        CommonLogger.getCommonLogger("encryptionsdk").infof(String.format("Cache a decryptionMaterial[CacheId: %s]", cacheId), new Object[0]);
        return result;
    }

    private String getCacheId(CryptoAlgorithm algorithm, Map<String, String> encryptionContext, List<EncryptedDataKey> encryptedDataKeys) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA");
            this.digestAlgorithm(digest, algorithm);
            this.digestContext(digest, encryptionContext);
            this.digestEncryptedDataKeys(digest, encryptedDataKeys);
            return Base64.getEncoder().encodeToString(digest.digest());
        }
        catch (Exception e) {
            throw new AliyunException("SHA MessageDigest not available", e);
        }
    }

    private void digestAlgorithm(MessageDigest digest, CryptoAlgorithm algorithm) {
        if (algorithm == null) {
            digest.update((byte)0);
        } else {
            digest.update((byte)1);
            algorithm.digestAlgorithm(digest);
        }
    }

    private void digestContext(MessageDigest digest, Map<String, String> encryptionContext) {
        if (encryptionContext == null) {
            digest.update((byte)0);
        } else {
            digest.update((byte)1);
            digest.update((byte)encryptionContext.size());
            TreeMap<String, String> map = new TreeMap<String, String>(encryptionContext);
            map.forEach((key, value) -> {
                digest.update(key.getBytes(ENCODING));
                digest.update(value.getBytes(ENCODING));
            });
        }
    }

    private void digestEncryptedDataKeys(MessageDigest digest, List<EncryptedDataKey> encryptedDataKeys) {
        if (encryptedDataKeys == null) {
            digest.update((byte)0);
        } else {
            digest.update((byte)1);
            digest.update((byte)encryptedDataKeys.size());
            TreeSet<EncryptedDataKey> set = new TreeSet<EncryptedDataKey>(encryptedDataKeys);
            set.forEach(key -> {
                digest.update(key.getKeyId());
                digest.update(key.getDataKey());
            });
        }
    }

    @Override
    public SignatureMaterial getSignatureMaterial(SignatureProvider provider, byte[] content, ContentType type) {
        SignatureMaterial material = new SignatureMaterial();
        material.setSignatureAlgorithm(provider.getSignatureAlgorithm());
        if (type.equals((Object)ContentType.DIGEST)) {
            material.setDigest(content);
        } else {
            material.setMessage(content);
        }
        return provider.sign(material);
    }

    @Override
    public VerifyMaterial getVerifyMaterial(SignatureProvider provider, byte[] content, byte[] signature, ContentType type) {
        VerifyMaterial material = new VerifyMaterial();
        material.setSignature(signature);
        material.setSignatureAlgorithm(provider.getSignatureAlgorithm());
        if (type.equals((Object)ContentType.DIGEST)) {
            material.setDigest(content);
        } else {
            material.setMessage(content);
        }
        return provider.verify(material);
    }
}

