/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encryptionsdk;

import com.aliyun.encryptionsdk.AliyunConfig;
import com.aliyun.encryptionsdk.ckm.CryptoKeyManager;
import com.aliyun.encryptionsdk.ckm.DefaultCryptoKeyManager;
import com.aliyun.encryptionsdk.handler.DefaultEncryptHandler;
import com.aliyun.encryptionsdk.handler.EncryptHandler;
import com.aliyun.encryptionsdk.kms.DefaultAliyunKms;
import com.aliyun.encryptionsdk.logger.CommonLogger;
import com.aliyun.encryptionsdk.model.CipherHeader;
import com.aliyun.encryptionsdk.model.CipherMaterial;
import com.aliyun.encryptionsdk.model.ContentType;
import com.aliyun.encryptionsdk.model.CryptoResult;
import com.aliyun.encryptionsdk.model.DecryptionMaterial;
import com.aliyun.encryptionsdk.model.EncryptionMaterial;
import com.aliyun.encryptionsdk.model.SignatureMaterial;
import com.aliyun.encryptionsdk.model.SignatureResult;
import com.aliyun.encryptionsdk.model.VerifyMaterial;
import com.aliyun.encryptionsdk.provider.BaseDataKeyProvider;
import com.aliyun.encryptionsdk.provider.SignatureProvider;
import java.util.Base64;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunCrypto {
    private EncryptHandler encryptHandler;
    private AliyunConfig config;
    private CryptoKeyManager cryptoKeyManager;

    public AliyunCrypto(AliyunConfig config) {
        this(config, LoggerFactory.getLogger((String)"encryptionsdk"));
    }

    public AliyunCrypto(AliyunConfig config, Logger logger) {
        this.config = config;
        this.encryptHandler = new DefaultEncryptHandler();
        this.cryptoKeyManager = new DefaultCryptoKeyManager();
        if (!CommonLogger.isRegistered("encryptionsdk")) {
            CommonLogger.registerLogger("encryptionsdk", logger);
        }
    }

    public void setEncryptHandler(EncryptHandler encryptHandler) {
        this.encryptHandler = encryptHandler;
    }

    public void setConfig(AliyunConfig config) {
        this.config = config;
    }

    public void setCryptoKeyManager(CryptoKeyManager cryptoKeyManager) {
        this.cryptoKeyManager = cryptoKeyManager;
    }

    public CryptoResult<byte[]> encrypt(BaseDataKeyProvider provider, byte[] plainText, Map<String, String> encryptionContext) {
        provider.setAliyunKms(new DefaultAliyunKms(this.config));
        EncryptionMaterial material = this.cryptoKeyManager.getEncryptDataKeyMaterial(provider, encryptionContext, plainText.length);
        CipherMaterial cipherMaterial = this.encryptHandler.encrypt(plainText, material);
        byte[] processBytes = provider.processCipherMaterial(cipherMaterial);
        return new CryptoResult<byte[]>(processBytes, cipherMaterial);
    }

    public CryptoResult<byte[]> decrypt(BaseDataKeyProvider provider, byte[] cipherText) {
        provider.setAliyunKms(new DefaultAliyunKms(this.config));
        CipherMaterial cipherMaterial = provider.getCipherMaterial(cipherText);
        CipherHeader cipherHeader = cipherMaterial.getCipherHeader();
        provider.setAlgorithm(cipherHeader.getAlgorithm());
        DecryptionMaterial material = this.cryptoKeyManager.getDecryptDataKeyMaterial(provider, cipherHeader.getEncryptionContext(), cipherHeader.getEncryptedDataKeys());
        return new CryptoResult<byte[]>(this.encryptHandler.decrypt(cipherMaterial, material), cipherMaterial);
    }

    public SignatureResult<byte[]> sign(SignatureProvider provider, byte[] content, ContentType type) {
        if (provider == null) {
            throw new NullPointerException("signature provider must not be null");
        }
        provider.setAliyunKms(new DefaultAliyunKms(this.config));
        SignatureMaterial signatureMaterial = this.cryptoKeyManager.getSignatureMaterial(provider, content, type);
        return new SignatureResult<byte[]>(Base64.getDecoder().decode(signatureMaterial.getValue()));
    }

    public SignatureResult<Boolean> verify(SignatureProvider provider, byte[] content, byte[] signature, ContentType type) {
        if (provider == null) {
            throw new NullPointerException("signature provider must not be null");
        }
        provider.setAliyunKms(new DefaultAliyunKms(this.config));
        VerifyMaterial verifyMaterial = this.cryptoKeyManager.getVerifyMaterial(provider, content, signature, type);
        return new SignatureResult<Boolean>(verifyMaterial.getValue());
    }
}

