/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encryptionsdk.provider.dataKey;

import com.aliyun.encryptionsdk.exception.AliyunException;
import com.aliyun.encryptionsdk.kms.AliyunKms;
import com.aliyun.encryptionsdk.logger.CommonLogger;
import com.aliyun.encryptionsdk.model.CipherHeader;
import com.aliyun.encryptionsdk.model.CryptoAlgorithm;
import com.aliyun.encryptionsdk.model.EncryptionMaterial;
import com.aliyun.encryptionsdk.provider.dataKey.AbstractExternalStoreDataKeyProvider;
import com.aliyuncs.exceptions.ClientException;
import java.util.Base64;
import java.util.UUID;

public class SecretManagerDataKeyProvider
extends AbstractExternalStoreDataKeyProvider {
    private static final String SECRET_DATA_TYPE_TEXT = "text";

    public SecretManagerDataKeyProvider(String keyId, String dataKeyName) {
        super(keyId, dataKeyName);
    }

    public SecretManagerDataKeyProvider(String keyId, CryptoAlgorithm algorithm, String dataKeyName) {
        super(keyId, algorithm, dataKeyName);
    }

    @Override
    public EncryptionMaterial encryptDataKey(EncryptionMaterial material) {
        CipherHeader cipherHeader = this.getCipherHeader(this.dataKeyName);
        if (cipherHeader != null) {
            return this.getEncryptionMaterial(cipherHeader, material);
        }
        EncryptionMaterial newMaterial = super.encryptDataKey(material);
        cipherHeader = new CipherHeader(newMaterial.getEncryptedDataKeys(), newMaterial.getEncryptionContext(), newMaterial.getAlgorithm());
        this.calculateHeaderAuthTag(newMaterial, cipherHeader);
        try {
            this.storeCipherHeader(this.dataKeyName, cipherHeader);
        }
        catch (Exception e) {
            ClientException exception;
            if (e.getCause() instanceof ClientException && "Rejected.ResourceExist".equals((exception = (ClientException)e.getCause()).getErrCode())) {
                cipherHeader = this.getCipherHeader(this.dataKeyName);
                if (cipherHeader != null) {
                    return this.getEncryptionMaterial(cipherHeader, material);
                }
                CommonLogger.getCommonLogger("encryptionsdk").errorf("The cause of the error was ResourceExist, but the obtained dataKey is empty", e);
                throw new AliyunException("The cause of the error was ResourceExist, but the obtained dataKey is empty", e);
            }
            CommonLogger.getCommonLogger("encryptionsdk").errorf("Failed to save dataKey to secretManager", e);
            throw e;
        }
        return newMaterial;
    }

    @Override
    protected CipherHeader getCipherHeader(String dataKeyName) {
        try {
            AliyunKms.GetSecretValueResult result = this.kms.getSecretValue(this.keyId, dataKeyName);
            if (SECRET_DATA_TYPE_TEXT.equals(result.getSecretDataType())) {
                String base64Header = result.getSecretData();
                byte[] header = Base64.getDecoder().decode(base64Header);
                return this.handler.deserializeCipherHeader(header);
            }
            throw new AliyunException("Unprocessed case where secretDataType is binary");
        }
        catch (Exception e) {
            ClientException exception;
            if (e.getCause() instanceof ClientException && "Forbidden.ResourceNotFound".equals((exception = (ClientException)e.getCause()).getErrCode())) {
                return null;
            }
            CommonLogger.getCommonLogger("encryptionsdk").errorf("Failed to get dataKey from secretManager", e);
            throw e;
        }
    }

    private void storeCipherHeader(String dataKeyName, CipherHeader cipherHeader) {
        byte[] header = this.handler.serializeCipherHeader(cipherHeader);
        String base64Header = Base64.getEncoder().encodeToString(header);
        String versionId = UUID.randomUUID().toString();
        this.kms.createSecret(this.keyId, dataKeyName, versionId, base64Header, SECRET_DATA_TYPE_TEXT);
    }
}

