/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encryptionsdk.provider.dataKey;

import com.aliyun.encryptionsdk.exception.AliyunException;
import com.aliyun.encryptionsdk.handler.AlgorithmHandler;
import com.aliyun.encryptionsdk.logger.CommonLogger;
import com.aliyun.encryptionsdk.model.CipherBody;
import com.aliyun.encryptionsdk.model.CipherHeader;
import com.aliyun.encryptionsdk.model.CipherMaterial;
import com.aliyun.encryptionsdk.model.CryptoAlgorithm;
import com.aliyun.encryptionsdk.model.DecryptionMaterial;
import com.aliyun.encryptionsdk.model.EncryptedDataKey;
import com.aliyun.encryptionsdk.model.EncryptionMaterial;
import com.aliyun.encryptionsdk.provider.BaseDataKeyProvider;
import java.util.List;

public abstract class AbstractExternalStoreDataKeyProvider
extends BaseDataKeyProvider {
    protected String dataKeyName;

    public AbstractExternalStoreDataKeyProvider(String keyId, String dataKeyName) {
        super(keyId);
        this.dataKeyName = dataKeyName;
    }

    public AbstractExternalStoreDataKeyProvider(String keyId, CryptoAlgorithm algorithm, String dataKeyName) {
        super(keyId, algorithm);
        this.dataKeyName = dataKeyName;
    }

    @Override
    public DecryptionMaterial decryptDataKey(DecryptionMaterial material, List<EncryptedDataKey> encryptedDataKeys) {
        return super.decryptDataKey(material, encryptedDataKeys);
    }

    @Override
    public CipherMaterial getCipherMaterial(byte[] cipherText) {
        CipherHeader cipherHeader;
        CipherBody cipherBody = this.getCipherBody(cipherText);
        try {
            cipherHeader = this.getCipherHeader(this.dataKeyName);
            if (cipherHeader == null) {
                throw new AliyunException("cipherHeader not obtained");
            }
        }
        catch (Exception e) {
            CommonLogger.getCommonLogger("encryptionsdk").errorf("Can't get dataKey from external", e);
            throw new AliyunException("Can't get dataKey from external", e);
        }
        return new CipherMaterial(cipherHeader, cipherBody);
    }

    @Override
    public byte[] processCipherMaterial(CipherMaterial cipherMaterial) {
        return this.handler.serializeCipherBody(cipherMaterial.getCipherBody());
    }

    EncryptionMaterial getEncryptionMaterial(CipherHeader cipherHeader, EncryptionMaterial material) {
        DecryptionMaterial decryptionMaterial = new DecryptionMaterial();
        decryptionMaterial.setAlgorithm(cipherHeader.getAlgorithm());
        decryptionMaterial.setEncryptionContext(cipherHeader.getEncryptionContext());
        decryptionMaterial = this.decryptDataKey(decryptionMaterial, cipherHeader.getEncryptedDataKeys());
        material.setPlaintextDataKey(decryptionMaterial.getPlaintextDataKey());
        material.setEncryptedDataKeys(cipherHeader.getEncryptedDataKeys());
        return material;
    }

    protected abstract CipherHeader getCipherHeader(String var1);

    private CipherBody getCipherBody(byte[] cipherText) {
        return this.handler.deserializeCipherBody(cipherText);
    }

    protected void calculateHeaderAuthTag(EncryptionMaterial newMaterial, CipherHeader cipherHeader) {
        AlgorithmHandler handler = new AlgorithmHandler(newMaterial.getAlgorithm(), newMaterial.getPlaintextDataKey(), 1);
        cipherHeader.calculateHeaderAuthTag(handler);
    }
}

