/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encryptionsdk.model;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class EncryptedDataKey
implements Comparable<EncryptedDataKey> {
    private static final Charset DATAKEY_ENCODING = StandardCharsets.UTF_8;
    private byte[] keyId;
    private byte[] dataKey;

    public EncryptedDataKey(String keyId, String dataKey) {
        this.keyId = keyId.getBytes(DATAKEY_ENCODING);
        this.dataKey = dataKey.getBytes(DATAKEY_ENCODING);
    }

    public EncryptedDataKey(byte[] keyId, byte[] dataKey) {
        this.keyId = keyId;
        this.dataKey = dataKey;
    }

    public byte[] getKeyId() {
        return this.keyId;
    }

    public byte[] getDataKey() {
        return this.dataKey;
    }

    public String getKeyIdString() {
        return new String(this.keyId, DATAKEY_ENCODING);
    }

    public String getDataKeyString() {
        return new String(this.dataKey, DATAKEY_ENCODING);
    }

    public byte[] toByteArray() {
        int outLen = 8 + this.keyId.length + this.dataKey.length;
        ByteBuffer out = ByteBuffer.allocate(outLen);
        out.putInt(this.keyId.length);
        out.put(this.keyId);
        out.putInt(this.dataKey.length);
        out.put(this.dataKey);
        return out.array();
    }

    @Override
    public int compareTo(EncryptedDataKey o) {
        int min = Math.min(this.keyId.length, o.keyId.length);
        for (int i = 0; i < min; ++i) {
            int a = this.keyId[i] & 0xFF;
            int b = o.keyId[i] & 0xFF;
            if (a == b) continue;
            return a - b;
        }
        return this.keyId.length - o.keyId.length;
    }
}

