/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encryptionsdk.handler;

import com.aliyun.encryptionsdk.exception.CipherTextParseException;
import com.aliyun.encryptionsdk.handler.AlgorithmHandler;
import com.aliyun.encryptionsdk.handler.EncryptHandler;
import com.aliyun.encryptionsdk.model.CipherBody;
import com.aliyun.encryptionsdk.model.CipherHeader;
import com.aliyun.encryptionsdk.model.CipherMaterial;
import com.aliyun.encryptionsdk.model.DecryptionMaterial;
import com.aliyun.encryptionsdk.model.EncryptionMaterial;
import java.security.SecureRandom;
import java.util.Arrays;

public class DefaultEncryptHandler
implements EncryptHandler {
    @Override
    public CipherMaterial encrypt(byte[] plaintext, EncryptionMaterial encryptionMaterial) {
        AlgorithmHandler handler = new AlgorithmHandler(encryptionMaterial.getAlgorithm(), encryptionMaterial.getPlaintextDataKey(), 1);
        CipherHeader cipherHeader = new CipherHeader(encryptionMaterial.getEncryptedDataKeys(), encryptionMaterial.getEncryptionContext(), encryptionMaterial.getAlgorithm());
        cipherHeader.calculateHeaderAuthTag(handler);
        byte[] iv = this.randomIv(encryptionMaterial.getAlgorithm().getIvLen());
        byte[] context = null;
        if (cipherHeader.getAlgorithm().isWithAad()) {
            context = cipherHeader.getEncryptionContextBytes();
        }
        byte[] cipherResult = handler.cipherData(iv, context, plaintext, 0, plaintext.length);
        int tagLen = cipherHeader.getAlgorithm().getTagLen();
        byte[] cipherText = new byte[cipherResult.length - tagLen];
        byte[] authTag = new byte[tagLen];
        if (tagLen != 0) {
            System.arraycopy(cipherResult, 0, cipherText, 0, cipherResult.length - tagLen);
            System.arraycopy(cipherResult, cipherText.length, authTag, 0, tagLen);
        } else {
            cipherText = cipherResult;
        }
        CipherBody cipherBody = new CipherBody(iv, cipherText, authTag);
        return new CipherMaterial(cipherHeader, cipherBody);
    }

    private byte[] randomIv(int len) {
        byte[] iv = new byte[len];
        SecureRandom random = new SecureRandom();
        random.nextBytes(iv);
        return iv;
    }

    @Override
    public byte[] decrypt(CipherMaterial cipherMaterial, DecryptionMaterial decryptionMaterial) {
        AlgorithmHandler handler = new AlgorithmHandler(decryptionMaterial.getAlgorithm(), decryptionMaterial.getPlaintextDataKey(), 2);
        if (!this.verifyHeaderAuthTag(cipherMaterial.getCipherHeader(), handler)) {
            throw new CipherTextParseException("header authTag verify failed");
        }
        CipherBody cipherBody = cipherMaterial.getCipherBody();
        byte[] cipherText = cipherBody.getCipherText();
        byte[] authTag = cipherBody.getAuthTag();
        if (authTag.length != cipherMaterial.getCipherHeader().getAlgorithm().getTagLen()) {
            throw new IllegalArgumentException("Invalid tag length: " + authTag.length);
        }
        byte[] result = new byte[cipherText.length + authTag.length];
        System.arraycopy(cipherText, 0, result, 0, cipherText.length);
        System.arraycopy(authTag, 0, result, cipherText.length, authTag.length);
        return handler.cipherData(cipherBody.getIv(), cipherMaterial.getCipherHeader().getEncryptionContextBytes(), result, 0, result.length);
    }

    private boolean verifyHeaderAuthTag(CipherHeader cipherHeader, AlgorithmHandler handler) {
        try {
            byte[] headerAuthTag = cipherHeader.getHeaderAuthTag();
            byte[] headerAuthTagCalc = handler.headerGcmEncrypt(cipherHeader.getHeaderIv(), cipherHeader.serializeAuthenticatedFields(), new byte[0], 0, 0);
            if (headerAuthTagCalc == null) {
                return false;
            }
            return Arrays.equals(headerAuthTag, headerAuthTagCalc);
        }
        catch (Exception e) {
            return false;
        }
    }
}

