/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encryptionsdk.handler;

import com.aliyun.encryptionsdk.exception.CipherTextParseException;
import com.aliyun.encryptionsdk.handler.FormatHandler;
import com.aliyun.encryptionsdk.model.CipherBody;
import com.aliyun.encryptionsdk.model.CipherHeader;
import com.aliyun.encryptionsdk.model.CipherMaterial;
import com.aliyun.encryptionsdk.model.CryptoAlgorithm;
import com.aliyun.encryptionsdk.model.EncryptedDataKey;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.util.encoders.Base64;

public class Asn1FormatHandler
implements FormatHandler {
    private static final Charset ASN1_ENCODING = StandardCharsets.UTF_8;
    private ASN1Sequence encryptionInfo;
    private ASN1Sequence encryptionHead;
    private ASN1Integer version;
    private ASN1Integer algorithm;
    private ASN1Set encryptedDataKeys;
    private ASN1Set encryptionContext;
    private DEROctetString headerIv;
    private DEROctetString headerAuthTag;
    private ASN1Sequence encryptionBody;
    private DEROctetString iv;
    private DEROctetString cipherText;
    private DEROctetString authTag;

    @Override
    public byte[] serialize(CipherMaterial cipherMaterial) {
        CipherHeader cipherHeader = cipherMaterial.getCipherHeader();
        CipherBody cipherBody = cipherMaterial.getCipherBody();
        if (cipherHeader != null) {
            this.version = new ASN1Integer(1L);
            this.algorithm = new ASN1Integer((long)cipherHeader.getAlgorithm().getValue());
            this.encryptedDataKeys = this.combineEncryptedDataKeys(cipherHeader.getEncryptedDataKeys());
            this.encryptionContext = this.combineEncryptionContext(cipherHeader.getEncryptionContext());
            this.headerIv = new DEROctetString(cipherHeader.getHeaderIv());
            this.headerAuthTag = new DEROctetString(cipherHeader.getHeaderAuthTag());
            this.encryptionHead = this.combineEncryptionHead();
        }
        if (cipherBody != null) {
            this.iv = new DEROctetString(cipherBody.getIv());
            this.cipherText = new DEROctetString(cipherBody.getCipherText());
            this.authTag = new DEROctetString(cipherBody.getAuthTag());
            this.encryptionBody = this.combineEncryptionBody();
        }
        this.encryptionInfo = this.combineEncryptionInfo();
        return this.asn1ToBytes((ASN1Object)this.encryptionInfo);
    }

    @Override
    public CipherMaterial deserialize(byte[] cipherData) {
        ASN1Sequence seq = (ASN1Sequence)this.bytesToAsn1(cipherData);
        if (seq.size() != 2) {
            throw new CipherTextParseException("Abnormal cipherData serialize");
        }
        this.encryptionInfo = seq;
        this.deserializeCipherHeader(seq.getObjectAt(0));
        this.deserializeCipherBody(seq.getObjectAt(1));
        CipherHeader cipherHeader = new CipherHeader(this.parseEncryptedDataKeys(this.encryptedDataKeys), this.parseEncryptionContext(this.encryptionContext), CryptoAlgorithm.getAlgorithm(this.algorithm.getValue().intValue()), this.headerIv.getOctets(), this.headerAuthTag.getOctets());
        CipherBody cipherBody = new CipherBody(this.iv.getOctets(), this.cipherText.getOctets(), this.authTag.getOctets());
        return new CipherMaterial(cipherHeader, cipherBody);
    }

    @Override
    public byte[] serializeCipherHeader(CipherHeader cipherHeader) {
        this.version = new ASN1Integer(1L);
        this.algorithm = new ASN1Integer((long)cipherHeader.getAlgorithm().getValue());
        this.encryptedDataKeys = this.combineEncryptedDataKeys(cipherHeader.getEncryptedDataKeys());
        this.encryptionContext = this.combineEncryptionContext(cipherHeader.getEncryptionContext());
        this.headerIv = new DEROctetString(cipherHeader.getHeaderIv());
        this.headerAuthTag = new DEROctetString(cipherHeader.getHeaderAuthTag());
        this.encryptionHead = this.combineEncryptionHead();
        return this.asn1ToBytes((ASN1Object)this.encryptionHead);
    }

    @Override
    public CipherHeader deserializeCipherHeader(byte[] cipherHeaderBytes) {
        ASN1Sequence seq = (ASN1Sequence)this.bytesToAsn1(cipherHeaderBytes);
        this.deserializeCipherHeader((ASN1Encodable)seq);
        List<EncryptedDataKey> encryptedDataKeys = this.parseEncryptedDataKeys(this.encryptedDataKeys);
        Map<String, String> encryptionContext = this.parseEncryptionContext(this.encryptionContext);
        CryptoAlgorithm algorithm = CryptoAlgorithm.getAlgorithm(this.algorithm.getValue().intValue());
        return new CipherHeader(encryptedDataKeys, encryptionContext, algorithm, this.headerIv.getOctets(), this.headerAuthTag.getOctets());
    }

    @Override
    public byte[] serializeCipherBody(CipherBody cipherBody) {
        this.iv = new DEROctetString(cipherBody.getIv());
        this.cipherText = new DEROctetString(cipherBody.getCipherText());
        this.authTag = new DEROctetString(cipherBody.getAuthTag());
        this.encryptionBody = this.combineEncryptionBody();
        return this.asn1ToBytes((ASN1Object)this.encryptionBody);
    }

    @Override
    public CipherBody deserializeCipherBody(byte[] cipherBody) {
        ASN1Sequence seq = (ASN1Sequence)this.bytesToAsn1(cipherBody);
        this.deserializeCipherBody((ASN1Encodable)seq);
        return new CipherBody(this.iv.getOctets(), this.cipherText.getOctets(), this.authTag.getOctets());
    }

    /*
     * Exception decompiling
     */
    private byte[] asn1ToBytes(ASN1Object seq) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ASN1Object bytesToAsn1(byte[] bytes) {
        ASN1Primitive seq;
        ASN1InputStream aIn = null;
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            aIn = new ASN1InputStream((InputStream)inputStream);
            seq = aIn.readObject();
        }
        catch (IOException e) {
            throw new CipherTextParseException("cipherData parsing failed", e);
        }
        finally {
            if (aIn != null) {
                try {
                    aIn.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return seq;
    }

    private void deserializeCipherHeader(ASN1Encodable encodable) {
        ASN1Sequence head;
        this.encryptionHead = head = (ASN1Sequence)encodable;
        if (head.size() != 6) {
            throw new CipherTextParseException("Abnormal cipherText serialize");
        }
        this.version = (ASN1Integer)head.getObjectAt(0);
        this.algorithm = (ASN1Integer)head.getObjectAt(1);
        this.encryptedDataKeys = (ASN1Set)head.getObjectAt(2);
        this.encryptionContext = (ASN1Set)head.getObjectAt(3);
        this.headerIv = (DEROctetString)head.getObjectAt(4);
        this.headerAuthTag = (DEROctetString)head.getObjectAt(5);
    }

    private void deserializeCipherBody(ASN1Encodable encodable) {
        ASN1Sequence body;
        this.encryptionBody = body = (ASN1Sequence)encodable;
        if (body.size() != 3) {
            throw new CipherTextParseException("Abnormal cipherText serialize");
        }
        this.iv = (DEROctetString)body.getObjectAt(0);
        this.cipherText = (DEROctetString)body.getObjectAt(1);
        this.authTag = (DEROctetString)body.getObjectAt(2);
    }

    private ASN1Sequence combineEncryptionInfo() {
        ASN1EncodableVector infoVec = new ASN1EncodableVector();
        if (this.encryptionHead != null) {
            infoVec.add((ASN1Encodable)this.encryptionHead);
        }
        if (this.encryptionBody != null) {
            infoVec.add((ASN1Encodable)this.encryptionBody);
        }
        return new DERSequence(infoVec);
    }

    private ASN1Sequence combineEncryptionHead() {
        ASN1EncodableVector headVec = new ASN1EncodableVector();
        headVec.add((ASN1Encodable)this.version);
        headVec.add((ASN1Encodable)this.algorithm);
        headVec.add((ASN1Encodable)this.encryptedDataKeys);
        headVec.add((ASN1Encodable)this.encryptionContext);
        if (this.headerIv != null) {
            headVec.add((ASN1Encodable)this.headerIv);
        }
        if (this.headerAuthTag != null) {
            headVec.add((ASN1Encodable)this.headerAuthTag);
        }
        return new DERSequence(headVec);
    }

    private ASN1Sequence combineEncryptionBody() {
        ASN1EncodableVector bodyVec = new ASN1EncodableVector();
        bodyVec.add((ASN1Encodable)this.iv);
        bodyVec.add((ASN1Encodable)this.cipherText);
        bodyVec.add((ASN1Encodable)this.authTag);
        return new DERSequence(bodyVec);
    }

    private ASN1Set combineEncryptedDataKeys(List<EncryptedDataKey> encryptedDataKeys) {
        ASN1EncodableVector dataKeyVec = new ASN1EncodableVector();
        encryptedDataKeys.forEach(dataKey -> {
            ASN1EncodableVector vector = new ASN1EncodableVector();
            vector.add((ASN1Encodable)new DEROctetString(dataKey.getKeyId()));
            vector.add((ASN1Encodable)new DEROctetString(Base64.decode((byte[])dataKey.getDataKey())));
            dataKeyVec.add((ASN1Encodable)new DERSequence(vector));
        });
        return new DERSet(dataKeyVec);
    }

    private List<EncryptedDataKey> parseEncryptedDataKeys(ASN1Set set) {
        ArrayList<EncryptedDataKey> list = new ArrayList<EncryptedDataKey>();
        for (ASN1Encodable aSet : set) {
            DLSequence sequence = (DLSequence)aSet;
            DEROctetString key = (DEROctetString)sequence.getObjectAt(0);
            DEROctetString dataKey = (DEROctetString)sequence.getObjectAt(1);
            list.add(new EncryptedDataKey(key.getOctets(), Base64.encode((byte[])dataKey.getOctets())));
        }
        return list;
    }

    private ASN1Set combineEncryptionContext(Map<String, String> encryptionContext) {
        ASN1EncodableVector contextVec = new ASN1EncodableVector();
        encryptionContext.forEach((key, value) -> {
            ASN1EncodableVector vector = new ASN1EncodableVector();
            vector.add((ASN1Encodable)new DEROctetString(key.getBytes(ASN1_ENCODING)));
            vector.add((ASN1Encodable)new DEROctetString(value.getBytes(ASN1_ENCODING)));
            contextVec.add((ASN1Encodable)new DERSequence(vector));
        });
        return new DERSet(contextVec);
    }

    private Map<String, String> parseEncryptionContext(ASN1Set set) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (ASN1Encodable aSet : set) {
            DLSequence sequence = (DLSequence)aSet;
            DEROctetString key = (DEROctetString)sequence.getObjectAt(0);
            DEROctetString value = (DEROctetString)sequence.getObjectAt(1);
            map.put(new String(key.getOctets(), ASN1_ENCODING), new String(value.getOctets(), ASN1_ENCODING));
        }
        return map;
    }
}

