/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encryptionsdk.ckm;

import com.aliyun.encryptionsdk.ckm.CryptoKeyManager;
import com.aliyun.encryptionsdk.exception.UnFoundDataKeyException;
import com.aliyun.encryptionsdk.logger.CommonLogger;
import com.aliyun.encryptionsdk.model.ContentType;
import com.aliyun.encryptionsdk.model.DecryptionMaterial;
import com.aliyun.encryptionsdk.model.EncryptedDataKey;
import com.aliyun.encryptionsdk.model.EncryptionMaterial;
import com.aliyun.encryptionsdk.model.SignatureMaterial;
import com.aliyun.encryptionsdk.model.VerifyMaterial;
import com.aliyun.encryptionsdk.provider.BaseDataKeyProvider;
import com.aliyun.encryptionsdk.provider.SignatureProvider;
import java.util.List;
import java.util.Map;

public class DefaultCryptoKeyManager
implements CryptoKeyManager {
    @Override
    public EncryptionMaterial getEncryptDataKeyMaterial(BaseDataKeyProvider provider, Map<String, String> encryptionContext, long plaintextSize) {
        EncryptionMaterial material = new EncryptionMaterial();
        material.setEncryptionContext(encryptionContext);
        material.setAlgorithm(provider.getAlgorithm());
        return provider.encryptDataKey(material);
    }

    @Override
    public DecryptionMaterial getDecryptDataKeyMaterial(BaseDataKeyProvider provider, Map<String, String> encryptionContext, List<EncryptedDataKey> encryptedDataKeys) {
        DecryptionMaterial material = new DecryptionMaterial();
        material.setEncryptionContext(encryptionContext);
        material.setAlgorithm(provider.getAlgorithm());
        DecryptionMaterial result = provider.decryptDataKey(material, encryptedDataKeys);
        if (result == null) {
            CommonLogger.getCommonLogger("encryptionsdk").errorf("Failed to get dataKey from encryptedDataKeys", new Object[0]);
            throw new UnFoundDataKeyException("Failed to get dataKey from encryptedDataKeys");
        }
        return result;
    }

    @Override
    public SignatureMaterial getSignatureMaterial(SignatureProvider provider, byte[] content, ContentType type) {
        SignatureMaterial material = new SignatureMaterial();
        material.setSignatureAlgorithm(provider.getSignatureAlgorithm());
        if (type.equals((Object)ContentType.DIGEST)) {
            material.setDigest(content);
        } else {
            material.setMessage(content);
        }
        return provider.sign(material);
    }

    @Override
    public VerifyMaterial getVerifyMaterial(SignatureProvider provider, byte[] content, byte[] signature, ContentType type) {
        VerifyMaterial material = new VerifyMaterial();
        material.setSignature(signature);
        material.setSignatureAlgorithm(provider.getSignatureAlgorithm());
        if (type.equals((Object)ContentType.DIGEST)) {
            material.setDigest(content);
        } else {
            material.setMessage(content);
        }
        return provider.verify(material);
    }
}

