/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encryptionsdk.provider;

import com.aliyun.encryptionsdk.handler.Asn1FormatHandler;
import com.aliyun.encryptionsdk.handler.FormatHandler;
import com.aliyun.encryptionsdk.kms.AliyunKms;
import com.aliyun.encryptionsdk.logger.CommonLogger;
import com.aliyun.encryptionsdk.model.CipherMaterial;
import com.aliyun.encryptionsdk.model.CmkId;
import com.aliyun.encryptionsdk.model.CryptoAlgorithm;
import com.aliyun.encryptionsdk.model.DecryptionMaterial;
import com.aliyun.encryptionsdk.model.EncryptedDataKey;
import com.aliyun.encryptionsdk.model.EncryptionMaterial;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.crypto.spec.SecretKeySpec;

public abstract class BaseDataKeyProvider {
    protected CryptoAlgorithm algorithm;
    protected FormatHandler handler;
    protected AliyunKms kms;
    protected CmkId keyId;
    private List<CmkId> keyIds = new ArrayList<CmkId>();

    public BaseDataKeyProvider(String keyId) {
        this(keyId, CryptoAlgorithm.AES_GCM_NOPADDING_256);
    }

    public BaseDataKeyProvider(String keyId, CryptoAlgorithm algorithm) {
        this.keyId = new CmkId(keyId);
        this.algorithm = algorithm;
        this.handler = new Asn1FormatHandler();
    }

    public void setAliyunKms(AliyunKms kms) {
        if (this.kms == null) {
            this.kms = kms;
        }
    }

    public void setMultiCmkId(List<String> keyIds) {
        ArrayList<CmkId> keyList = new ArrayList<CmkId>();
        if (keyIds != null && !keyIds.isEmpty()) {
            keyIds.remove(this.keyId.getKeyId());
            for (String keyId : keyIds) {
                keyList.add(new CmkId(keyId));
            }
        }
        this.keyIds = keyList;
    }

    public CryptoAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(CryptoAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public void setFormatHandler(FormatHandler handler) {
        this.handler = handler;
    }

    public EncryptionMaterial encryptDataKey(EncryptionMaterial material) {
        EncryptionMaterial newMaterial = this.generateDataKey(material);
        EncryptedDataKey dataKey = newMaterial.getEncryptedDataKeys().get(0);
        for (CmkId key : this.keyIds) {
            if (this.keyId.isCommonRegion(key)) {
                newMaterial = this.reEncryptDataKey(key, dataKey, newMaterial);
                continue;
            }
            newMaterial = this.encryptDataKey(key, newMaterial);
        }
        return newMaterial;
    }

    public DecryptionMaterial decryptDataKey(DecryptionMaterial material, List<EncryptedDataKey> encryptedDataKeys) {
        ArrayList<CmkId> keyIdList = new ArrayList<CmkId>(this.keyIds);
        if (this.keyId != null) {
            keyIdList.add(this.keyId);
        }
        for (EncryptedDataKey encryptedDataKey : encryptedDataKeys) {
            if (!keyIdList.contains(new CmkId(encryptedDataKey.getKeyIdString()))) continue;
            try {
                return this.decryptDataKey(material, encryptedDataKey);
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public abstract CipherMaterial getCipherMaterial(byte[] var1);

    public abstract byte[] processCipherMaterial(CipherMaterial var1);

    private EncryptionMaterial generateDataKey(EncryptionMaterial material) {
        AliyunKms.GenerateDataKeyResult result = this.kms.generateDataKey(this.keyId, material.getAlgorithm(), material.getEncryptionContext());
        byte[] plainText = Base64.getDecoder().decode(result.getPlaintext());
        material.setPlaintextDataKey(new SecretKeySpec(plainText, material.getAlgorithm().getKeyName()));
        material.addEncryptedDataKeys(result.getEncryptedDataKey());
        CommonLogger.getCommonLogger("encryptionsdk").infof(String.format("[keyId: %s] generate and encrypt a dataKey", this.keyId.getKeyId()), new Object[0]);
        return material;
    }

    private EncryptionMaterial encryptDataKey(CmkId keyId, EncryptionMaterial material) {
        EncryptedDataKey result = this.kms.encryptDataKey(keyId, Base64.getEncoder().encodeToString(material.getPlaintextDataKey().getEncoded()), material.getEncryptionContext());
        material.addEncryptedDataKeys(result);
        CommonLogger.getCommonLogger("encryptionsdk").infof(String.format("[keyId: %s] encrypt a dataKey generated by [keyId: %s]", keyId.getKeyId(), this.keyId.getKeyId()), new Object[0]);
        return material;
    }

    private EncryptionMaterial reEncryptDataKey(CmkId keyId, EncryptedDataKey dataKey, EncryptionMaterial material) {
        EncryptedDataKey result = this.kms.reEncryptDataKey(keyId, dataKey, material.getEncryptionContext());
        material.addEncryptedDataKeys(result);
        CommonLogger.getCommonLogger("encryptionsdk").infof(String.format("[keyId: %s] encrypt a dataKey generated by [keyId: %s]", keyId.getKeyId(), this.keyId.getKeyId()), new Object[0]);
        return material;
    }

    private DecryptionMaterial decryptDataKey(DecryptionMaterial material, EncryptedDataKey encryptedDataKey) {
        AliyunKms.DecryptDataKeyResult result = this.kms.decryptDataKey(encryptedDataKey, material.getEncryptionContext());
        byte[] plainText = Base64.getDecoder().decode(result.getPlaintext());
        material.setPlaintextDataKey(new SecretKeySpec(plainText, material.getAlgorithm().getKeyName()));
        CommonLogger.getCommonLogger("encryptionsdk").infof(String.format("[keyId: %s] decrypt a dataKey", encryptedDataKey.getKeyIdString()), new Object[0]);
        return material;
    }
}

